/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.weathergate.server;

import com.unrealdinnerbone.weathergate.level.attachments.TerrainControllerAttachment;
import com.unrealdinnerbone.weathergate.network.packets.s2c.colorsync.RemovePosPacket;
import com.unrealdinnerbone.weathergate.util.Type;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.network.PacketDistributor;

public class TerrainManager {
    public static void addBlockPos(Level level, BlockPos pos) {
        TerrainControllerAttachment attachment = TerrainControllerAttachment.getAttachment(level);
        Biome biome = (Biome)level.getBiome(pos).value();
        HashMap<Type, Color4I> colorMap = new HashMap<Type, Color4I>();
        for (Type type : Type.values()) {
            colorMap.put(type, type.getDefaultColor().apply(biome, pos));
        }
        attachment.data().put(pos, colorMap);
        attachment.save(level);
    }

    public static void removeBlockPos(Level level, BlockPos pos) {
        TerrainControllerAttachment attachment = TerrainControllerAttachment.getAttachment(level);
        attachment.data().remove(pos);
        attachment.save(level);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, (CustomPacketPayload)new RemovePosPacket(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

