/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.weathergate.network.packets.s2c.colorsync;

import com.unrealdinnerbone.weathergate.WeatherGate;
import com.unrealdinnerbone.weathergate.client.WeatherGateClient;
import net.minecraft.client.Minecraft;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RemovePosPacket(GlobalPos globalPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RemovePosPacket> TYPE = new CustomPacketPayload.Type(WeatherGate.rl("remove_pos_packet"));
    public static final StreamCodec<FriendlyByteBuf, RemovePosPacket> CODEC = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, RemovePosPacket::globalPos, RemovePosPacket::new);

    public static void handleRemovePosPacket(RemovePosPacket removePosPacket, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (WeatherGateClient.BLOCK_COLORS.containsKey(removePosPacket.globalPos().dimension())) {
                WeatherGateClient.BLOCK_COLORS.get(removePosPacket.globalPos().dimension()).remove(removePosPacket.globalPos().pos());
                if (WeatherGateClient.isPosInRange(removePosPacket.globalPos().pos())) {
                    Minecraft.getInstance().levelRenderer.allChanged();
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

