/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.weathergate.level.attachments;

import com.mojang.serialization.Codec;
import com.unrealdinnerbone.weathergate.WeatherGateRegistry;
import com.unrealdinnerbone.weathergate.util.RangeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;

public record SnowCatcherAttachment(List<BlockPos> blockPosList) {
    public static final SnowCatcherAttachment EMPTY = new SnowCatcherAttachment(new ArrayList<BlockPos>());
    public static final Codec<SnowCatcherAttachment> CODEC = BlockPos.CODEC.listOf().xmap(SnowCatcherAttachment::of, SnowCatcherAttachment::blockPosList);

    public static SnowCatcherAttachment of(List<BlockPos> data) {
        return new SnowCatcherAttachment(new ArrayList<BlockPos>(data));
    }

    public static SnowCatcherAttachment get(Level level) {
        return (SnowCatcherAttachment)level.getData((AttachmentType)WeatherGateRegistry.SNOW_CATCHER_ATTACHMENT.get());
    }

    public void save(Level level) {
        level.setData((AttachmentType)WeatherGateRegistry.SNOW_CATCHER_ATTACHMENT.get(), (Object)this);
    }

    public static void addBlockPos(Level level, BlockPos blockPos) {
        SnowCatcherAttachment snowCatcherAttachment = SnowCatcherAttachment.get(level);
        snowCatcherAttachment.blockPosList.add(blockPos);
        snowCatcherAttachment.save(level);
    }

    public static void removeBlockPos(Level level, BlockPos blockPos) {
        SnowCatcherAttachment snowCatcherAttachment = SnowCatcherAttachment.get(level);
        snowCatcherAttachment.blockPosList.remove(blockPos);
        snowCatcherAttachment.save(level);
    }

    public static boolean isInRange(Level level, BlockPos blockPos) {
        for (BlockPos location : SnowCatcherAttachment.get(level).blockPosList()) {
            if (!RangeUtils.isWithinRange((Vec3i)location, (Vec3i)blockPos, 64)) continue;
            return true;
        }
        return false;
    }
}

