/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbrifthelper;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbrifthelper.FTBRiftHelper;
import dev.ftb.mods.ftbrifthelper.mixin.ChunkStorageAccess;
import dev.ftb.mods.ftbrifthelper.mixin.IOWorkerAccess;
import dev.ftb.mods.ftbrifthelper.mixin.RegionFileStorageAccess;
import dev.ftb.mods.ftbteambases.util.RegionCoords;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class RiftRegionManager
extends SavedData {
    private static final String DATA_NAME = "RiftRegionData";
    private static ServerLevel riftDimension;
    private static final Codec<Map<RegionCoords, UUID>> REGION_MAP_CODEC;
    private static final Codec<Set<UUID>> UUID_SET_CODEC;
    private static final Codec<Set<RegionCoords>> REGION_COORDS_SET_CODEC;
    public static final Codec<RiftRegionManager> CODEC;
    private final Map<RegionCoords, UUID> region2TeamId;
    private final Set<UUID> pendingRefresh;
    private final Set<RegionCoords> pendingDelete;
    private final Map<UUID, Set<RegionCoords>> team2regions;

    private RiftRegionManager(Map<RegionCoords, UUID> region2TeamId, Set<UUID> pendingRefresh, Set<RegionCoords> pendingDelete) {
        this.region2TeamId = region2TeamId;
        this.pendingRefresh = pendingRefresh;
        this.pendingDelete = pendingDelete;
        this.team2regions = new HashMap<UUID, Set<RegionCoords>>();
    }

    public static RiftRegionManager getInstance() {
        return (RiftRegionManager)RiftRegionManager.getRiftDimension().getDataStorage().computeIfAbsent(RiftRegionManager.factory(), DATA_NAME);
    }

    private static RiftRegionManager load(CompoundTag tag, HolderLookup.Provider provider) {
        return CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound("manager")).resultOrPartial(err -> FTBRiftHelper.LOGGER.error("failed to deserialize rift region data: {}", err)).orElse(RiftRegionManager.createNew());
    }

    private static RiftRegionManager createNew() {
        return new RiftRegionManager(new HashMap<RegionCoords, UUID>(), new HashSet<UUID>(), new HashSet<RegionCoords>());
    }

    private static SavedData.Factory<RiftRegionManager> factory() {
        return new SavedData.Factory(RiftRegionManager::createNew, RiftRegionManager::load, null);
    }

    private static ServerLevel getRiftDimension() {
        if (riftDimension == null && (riftDimension = ServerLifecycleHooks.getCurrentServer().getLevel(FTBRiftHelper.RIFT_DIMENSION)) == null) {
            throw new IllegalStateException("Rift Dimension not available!");
        }
        return riftDimension;
    }

    static void clearCachedRiftDimension() {
        riftDimension = null;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider registries) {
        return (CompoundTag)Util.make((Object)new CompoundTag(), tag -> tag.put("manager", (Tag)CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).resultOrPartial(err -> FTBRiftHelper.LOGGER.error("failed to serialize rift region data: {}", err)).orElse(new CompoundTag())));
    }

    public Optional<UUID> getTeamForRegion(RegionCoords regionCoords) {
        return Optional.ofNullable(this.region2TeamId.get(regionCoords));
    }

    public Set<RegionCoords> getRegionsForTeam(UUID teamId) {
        return this.team2regions.computeIfAbsent(teamId, k -> (Set)Util.make(new HashSet(), set -> this.region2TeamId.forEach((rc, id) -> {
            if (id.equals(teamId)) {
                set.add(rc);
            }
        })));
    }

    public void addRegion(UUID teamId, RegionCoords regionCoords) {
        this.region2TeamId.put(regionCoords, teamId);
        this.team2regions.remove(teamId);
        this.setDirty();
    }

    public void addPendingRefresh(UUID teamId) {
        this.pendingRefresh.add(teamId);
        this.setDirty();
    }

    public Set<UUID> getPendingRefresh() {
        return Set.copyOf(this.pendingRefresh);
    }

    public void clearPendingRefresh(UUID teamId) {
        if (this.pendingRefresh.remove(teamId)) {
            this.setDirty();
        }
    }

    public void onTeamBaseArchived(UUID teamId) {
        HashSet toDelete = new HashSet();
        this.region2TeamId.forEach((rc, id) -> {
            if (id.equals(teamId)) {
                toDelete.add(rc);
            }
        });
        if (!toDelete.isEmpty()) {
            this.pendingDelete.addAll(toDelete);
            toDelete.forEach(this.region2TeamId::remove);
            this.setDirty();
        }
        this.team2regions.remove(teamId);
    }

    public Set<RegionCoords> getPendingDeletion() {
        return Collections.unmodifiableSet(this.pendingDelete);
    }

    public void clearPendingDeletion(Set<RegionCoords> rc) {
        if (!rc.isEmpty()) {
            this.pendingDelete.removeAll(rc);
            this.setDirty();
        }
    }

    public boolean tryCloseRegionFiles(ServerLevel level, UUID teamId) {
        return this.tryCloseRegionFiles(level, this.getRegionsForTeam(teamId));
    }

    public boolean tryCloseRegionFiles(ServerLevel level, Collection<RegionCoords> regions) {
        IOWorker worker = ((ChunkStorageAccess)level.getChunkSource().chunkMap).getWorker();
        RegionFileStorage storage = ((IOWorkerAccess)worker).getStorage();
        Long2ObjectLinkedOpenHashMap<RegionFile> cache = ((RegionFileStorageAccess)storage).getRegionCache();
        int closed = 0;
        for (RegionCoords rc : regions) {
            long key = ChunkPos.asLong((int)rc.x(), (int)rc.z());
            RegionFile regionFile = (RegionFile)cache.get(key);
            if (regionFile != null) {
                try {
                    ((RegionFile)cache.remove(key)).close();
                    FTBRiftHelper.LOGGER.debug("closed and purged region {}/{} from the cache", (Object)level.dimension().location(), (Object)rc);
                    ++closed;
                }
                catch (IOException e) {
                    FTBRiftHelper.LOGGER.error("can't close region file {} for region {}", (Object)regionFile.getPath(), (Object)rc);
                }
                continue;
            }
            FTBRiftHelper.LOGGER.debug("region file for region {} not in cache, already closed? continuing!", (Object)rc);
            ++closed;
        }
        return closed == regions.size();
    }

    static {
        REGION_MAP_CODEC = Codec.unboundedMap((Codec)RegionCoords.STRING_CODEC, (Codec)UUIDUtil.CODEC).xmap(HashMap::new, Map::copyOf);
        UUID_SET_CODEC = UUIDUtil.CODEC.listOf().xmap(HashSet::new, ArrayList::new);
        REGION_COORDS_SET_CODEC = RegionCoords.CODEC.listOf().xmap(HashSet::new, ArrayList::new);
        CODEC = RecordCodecBuilder.create(builder -> builder.group((App)REGION_MAP_CODEC.fieldOf("region_to_team_id").forGetter(d -> d.region2TeamId), (App)UUID_SET_CODEC.fieldOf("pending_refresh").forGetter(d -> d.pendingRefresh), (App)REGION_COORDS_SET_CODEC.fieldOf("pending_delete").forGetter(d -> d.pendingDelete)).apply((Applicative)builder, RiftRegionManager::new));
    }
}

