/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbrifthelper;

import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbrifthelper.Config;
import dev.ftb.mods.ftbrifthelper.FTBRiftHelper;
import dev.ftb.mods.ftbrifthelper.RiftRegionManager;
import dev.ftb.mods.ftbrifthelper.mixin.ChunkMapAccess;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.util.RegionCoords;
import dev.ftb.mods.ftbteambases.util.RegionFileRelocator;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class RiftHelperUtil {
    static void copyAndRelocateRegions(UUID teamId, RegionCoords rc) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            CommandSourceStack source = server.createCommandSourceStack();
            try {
                RegionFileRelocator relocator = new RegionFileRelocator(source, (String)Config.RIFT_TEMPLATE.get(), FTBRiftHelper.RIFT_DIMENSION, XZ.of((int)rc.x(), (int)rc.z()), true);
                relocator.start(success -> {
                    if (success) {
                        RiftRegionManager mgr = RiftRegionManager.getInstance();
                        mgr.clearPendingRefresh(teamId);
                        relocator.getRelocationData().values().forEach(data -> mgr.addRegion(teamId, data.orig().offsetBy(data.regionOffset())));
                        FTBRiftHelper.LOGGER.info("relocated rift template for team {} to {} in rift dimension", (Object)teamId, (Object)rc);
                    } else {
                        FTBRiftHelper.LOGGER.error("failed to relocate rift template for team {} to {} in rift dimension", (Object)teamId, (Object)rc);
                    }
                });
            }
            catch (IOException e) {
                FTBRiftHelper.LOGGER.error("Error relocating rift template for team {} to {}: {}", new Object[]{teamId, rc, e.getMessage()});
            }
        }
    }

    static void sendPlayerToRift(ServerPlayer player, int playerRadius) {
        ServerLevel riftDimension = player.getServer().getLevel(FTBRiftHelper.RIFT_DIMENSION);
        if (riftDimension != null) {
            List allPlayers = playerRadius > 0 ? player.level().getNearbyPlayers(TargetingConditions.forNonCombat(), (LivingEntity)player, player.getBoundingBox().inflate((double)playerRadius)) : List.of();
            RiftHelperUtil.getZoneInPoint(player).ifPresent(pos -> {
                Vec3 vec = Vec3.atBottomCenterOf((Vec3i)pos);
                allPlayers.forEach(p -> p.teleportTo(riftDimension, vec.x, vec.y, vec.z, Set.of(), 0.0f, 0.0f));
                player.teleportTo(riftDimension, vec.x, vec.y, vec.z, Set.of(), ((Double)Config.SPAWN_FACING.get()).floatValue(), 0.0f);
            });
        }
    }

    static Optional<BlockPos> getZoneInPoint(ServerPlayer player) {
        return BaseInstanceManager.get().getBaseForPlayer(player).map(base -> RiftHelperUtil.baseToRiftCoords(base.extents().start()).getBlockPos((Vec3i)Config.getSpawnOffset()));
    }

    static RegionCoords baseToRiftCoords(RegionCoords regionCoords) {
        return regionCoords;
    }

    static RegionCoords riftToBaseCoords(RegionCoords regionCoords) {
        return regionCoords;
    }

    public static Set<RegionCoords> getLoadedRegions(ServerLevel level) {
        return (Set)Util.make(new HashSet(), set -> ((ChunkMapAccess)level.getChunkSource().chunkMap).invokeGetChunks().forEach(holder -> set.add(new RegionCoords(holder.getPos().x >> 5, holder.getPos().z >> 5))));
    }
}

