/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbrifthelper;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import dev.ftb.mods.ftbrifthelper.Config;
import dev.ftb.mods.ftbrifthelper.ModCommands;
import dev.ftb.mods.ftbrifthelper.RiftHelperUtil;
import dev.ftb.mods.ftbrifthelper.RiftRegionManager;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.events.BaseArchivedEvent;
import dev.ftb.mods.ftbteambases.events.BaseCreatedEvent;
import dev.ftb.mods.ftbteambases.util.RegionCoords;
import dev.ftb.mods.ftbteambases.util.RegionFileUtil;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.slf4j.Logger;

@Mod(value="ftbrifthelper")
public class FTBRiftHelper {
    public static final String MODID = "ftbrifthelper";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceKey<Level> RIFT_DIMENSION = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"ftb:the_rift"));
    private static final ResourceLocation RIFT_WEAVER = ResourceLocation.parse((String)"ftboceanmobs:rift_weaver");
    private static final Vec3i ZERO_64_ZERO = new Vec3i(0, 64, 0);
    private static final List<String> SUBDIRS = List.of("region", "entities", "poi");

    public FTBRiftHelper(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.addListener(this::onServerStopping);
        NeoForge.EVENT_BUS.addListener(this::onEntityDeath);
        NeoForge.EVENT_BUS.addListener(this::onServerTick);
        NeoForge.EVENT_BUS.addListener(this::onPlayerDeath);
        BaseCreatedEvent.CREATED.register(this::onTeamBaseCreation);
        BaseArchivedEvent.ARCHIVED.register(this::onTeamBaseArchived);
    }

    private void onTeamBaseCreation(BaseInstanceManager baseInstanceManager, ServerPlayer player, Team team) {
        baseInstanceManager.getBaseForTeam(team).ifPresent(base -> {
            RegionCoords riftCoords = RiftHelperUtil.baseToRiftCoords(base.extents().start());
            RiftHelperUtil.copyAndRelocateRegions(team.getTeamId(), riftCoords);
            this.pasteTempleStructure(player);
        });
    }

    private void onTeamBaseArchived(BaseInstanceManager baseInstanceManager, Team team) {
        RiftRegionManager.getInstance().onTeamBaseArchived(team.getTeamId());
    }

    private void onServerTick(ServerTickEvent.Post event) {
        ServerLevel level;
        if (event.getServer().getTickCount() % (Integer)Config.REFRESH_CHECK_INTERVAL.get() == 0 && (level = event.getServer().getLevel(RIFT_DIMENSION)) != null) {
            Set<UUID> pendingRefresh = RiftRegionManager.getInstance().getPendingRefresh();
            Set<RegionCoords> pendingDelete = RiftRegionManager.getInstance().getPendingDeletion();
            if (!pendingDelete.isEmpty() || !pendingRefresh.isEmpty()) {
                Set<RegionCoords> loadedRegions = RiftHelperUtil.getLoadedRegions(level);
                this.checkForRegionRefresh(level, loadedRegions, pendingRefresh);
                if (((Boolean)Config.REMOVE_RIFT_MCA_ON_BASE_ARCHIVAL.get()).booleanValue()) {
                    this.checkForRegionDeletion(level, loadedRegions, pendingDelete);
                }
            }
        }
    }

    private void onPlayerDeath(LivingDeathEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (player = (ServerPlayer)livingEntity).level().dimension().equals(RIFT_DIMENSION)) {
            FTBTeamsAPI.api().getManager().getTeamForPlayer(player).ifPresent(team -> {
                BaseInstanceManager mgr = BaseInstanceManager.get((MinecraftServer)player.getServer());
                player.setHealth(1.0f);
                event.setCanceled(true);
                if (!mgr.teleportToBaseSpawn(player, team.getId())) {
                    mgr.teleportToLobby(player);
                }
                player.server.executeIfPossible(() -> player.displayClientMessage((Component)Component.translatable((String)"ftbrifthelper.bootedFromRift").withStyle(ChatFormatting.GOLD), false));
            });
        }
    }

    private void checkForRegionRefresh(ServerLevel level, Set<RegionCoords> loadedRegions, Set<UUID> pendingTeams) {
        pendingTeams.forEach(teamId -> BaseInstanceManager.get().getBaseForTeamId(teamId).ifPresent(base -> {
            RegionCoords riftCoords = RiftHelperUtil.baseToRiftCoords(base.extents().start());
            if (!loadedRegions.contains(riftCoords) && RiftRegionManager.getInstance().tryCloseRegionFiles(level, (UUID)teamId)) {
                RiftHelperUtil.copyAndRelocateRegions(teamId, riftCoords);
            }
        }));
    }

    private void checkForRegionDeletion(ServerLevel level, Set<RegionCoords> loadedRegions, Set<RegionCoords> pendingDelete) {
        if (!pendingDelete.isEmpty()) {
            HashSet<RegionCoords> toClear = new HashSet<RegionCoords>();
            pendingDelete.forEach(rc -> {
                if (!loadedRegions.contains(rc) && RiftRegionManager.getInstance().tryCloseRegionFiles(level, List.of(rc))) {
                    for (String subDir : SUBDIRS) {
                        Path path = RegionFileUtil.getPathForDimension((MinecraftServer)level.getServer(), RIFT_DIMENSION, (String)subDir).resolve(String.format("r.%d.%d.mca", rc.x(), rc.z()));
                        try {
                            Files.deleteIfExists(path);
                            toClear.add((RegionCoords)rc);
                            LOGGER.debug("Purged region file {}", (Object)path);
                        }
                        catch (IOException e) {
                            LOGGER.error("can't delete {}: {}", (Object)path, (Object)e.getMessage());
                        }
                    }
                }
            });
            RiftRegionManager.getInstance().clearPendingDeletion(toClear);
        }
    }

    private void onEntityDeath(LivingDeathEvent event) {
        ResourceLocation rl;
        ServerLevel sl;
        Level level = event.getEntity().level();
        if (level instanceof ServerLevel && (sl = (ServerLevel)level).dimension().location().equals((Object)RIFT_DIMENSION.location()) && (rl = BuiltInRegistries.ENTITY_TYPE.getKey((Object)event.getEntity().getType())).equals((Object)RIFT_WEAVER)) {
            BlockPos pos = event.getEntity().blockPosition();
            RegionCoords regionCoords = new RegionCoords(pos.getX() >> 9, pos.getZ() >> 9);
            RiftRegionManager mgr = RiftRegionManager.getInstance();
            mgr.getTeamForRegion(regionCoords).ifPresent(mgr::addPendingRefresh);
        }
    }

    private void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private void onServerStopping(ServerStoppingEvent event) {
        RiftRegionManager.clearCachedRiftDimension();
    }

    private void pasteTempleStructure(ServerPlayer player) {
        Level level;
        ResourceLocation templeLoc = Config.getTempleStructure();
        if (templeLoc != null && (level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            player.getServer().getStructureManager().get(templeLoc).ifPresent(template -> {
                BlockPos pos = new BlockPos(player.getBlockX(), ((Integer)Config.TEMPLATE_STRUCTURE_Y.get()).intValue(), player.getBlockZ());
                StructurePlaceSettings settings = new StructurePlaceSettings();
                template.placeInWorld((ServerLevelAccessor)serverLevel, pos, pos, settings, RandomSource.create((long)Util.getMillis()), 2);
            });
        }
    }
}

