/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.mixin.accessors.ExplosionAccess;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class IEExplosion
extends Explosion {
    public float dropChance = 1.0f;
    private int blockDestroyInt = 0;
    public int blocksPerTick = 8;
    public boolean isExplosionFinished = false;
    private final Level world;
    private final float size;
    private final Explosion.BlockInteraction damagesTerrain;

    public IEExplosion(Level world, Entity igniter, double x, double y, double z, float size, boolean isFlaming, Explosion.BlockInteraction damageTerrain) {
        super(world, igniter, x, y, z, size, isFlaming, damageTerrain);
        this.dropChance = 1.0f / size;
        this.world = world;
        this.damagesTerrain = damageTerrain;
        this.size = size;
    }

    public IEExplosion setDropChance(float chance) {
        this.dropChance = chance;
        return this;
    }

    public void doExplosionTick() {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        int max = Math.min(this.blockDestroyInt + this.blocksPerTick, this.getToBlow().size());
        while (this.blockDestroyInt < max) {
            BlockPos pos = (BlockPos)this.getToBlow().get(this.blockDestroyInt);
            BlockState state = this.world.getBlockState(pos);
            Block block = state.getBlock();
            Vec3 center = this.center();
            double d0 = (float)pos.getX() + ApiUtils.RANDOM.nextFloat();
            double d1 = (float)pos.getY() + ApiUtils.RANDOM.nextFloat();
            double d2 = (float)pos.getZ() + ApiUtils.RANDOM.nextFloat();
            double d3 = d0 - center.x;
            double d4 = d1 - center.y;
            double d5 = d2 - center.z;
            double d6 = Mth.sqrt((float)((float)(d3 * d3 + d4 * d4 + d5 * d5)));
            d3 /= d6;
            d4 /= d6;
            d5 /= d6;
            double d7 = 0.5 / (d6 / (double)this.size + 0.1);
            this.world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (d0 + center.x * 1.0) / 2.0, (d1 + center.y * 1.0) / 2.0, (d2 + center.z * 1.0) / 2.0, d3 *= (d7 *= (double)(ApiUtils.RANDOM.nextFloat() * ApiUtils.RANDOM.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
            this.world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, d3, d4, d5);
            if (!state.isAir() && this.world instanceof ServerLevel && state.canDropFromExplosion((BlockGetter)this.world, pos, (Explosion)this)) {
                BlockEntity tile = this.world.getBlockEntity(pos);
                LootParams.Builder lootCtx = new LootParams.Builder((ServerLevel)this.world).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)tile);
                if (this.damagesTerrain == Explosion.BlockInteraction.DESTROY) {
                    lootCtx.withParameter(LootContextParams.EXPLOSION_RADIUS, (Object)Float.valueOf(this.size));
                }
                state.getDrops(lootCtx).forEach(stack -> ExplosionAccess.callAddOrAppendStack((List<Pair<ItemStack, BlockPos>>)objectarraylist, stack, pos));
                state.onBlockExploded(this.world, pos, (Explosion)this);
            }
            ++this.blockDestroyInt;
        }
        for (Pair pair : objectarraylist) {
            Block.popResource((Level)this.world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
        if (this.blockDestroyInt >= this.getToBlow().size()) {
            this.isExplosionFinished = true;
        }
    }

    public void explode() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.center().x;
                    double d6 = this.center().y;
                    double d8 = this.center().z;
                    float f1 = 0.3f;
                    for (float f = this.size * (0.7f + ApiUtils.RANDOM.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.containing((double)d4, (double)d6, (double)d8);
                        BlockState iblockstate = this.world.getBlockState(blockpos);
                        FluidState ifluidstate = this.world.getFluidState(blockpos);
                        if (!iblockstate.isAir() || !ifluidstate.isEmpty()) {
                            float f2 = Math.max(iblockstate.getExplosionResistance((BlockGetter)this.world, blockpos, (Explosion)this), ifluidstate.getExplosionResistance((BlockGetter)this.world, blockpos, (Explosion)this));
                            if (this.getDirectSourceEntity() != null) {
                                f2 = this.getDirectSourceEntity().getBlockExplosionResistance((Explosion)this, (BlockGetter)this.world, blockpos, iblockstate, ifluidstate, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.getDirectSourceEntity() == null || this.getDirectSourceEntity().shouldBlockExplode((Explosion)this, (BlockGetter)this.world, blockpos, iblockstate, f))) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.getToBlow().addAll(set);
        Vec3 center = this.center();
        this.getToBlow().sort(Comparator.comparingDouble(pos -> pos.distToCenterSqr((Position)center)));
        float f3 = this.size * 2.0f;
        int k1 = Mth.floor((double)(center.x - (double)f3 - 1.0));
        int l1 = Mth.floor((double)(center.x + (double)f3 + 1.0));
        int i2 = Mth.floor((double)(center.y - (double)f3 - 1.0));
        int i1 = Mth.floor((double)(center.y + (double)f3 + 1.0));
        int j2 = Mth.floor((double)(center.z - (double)f3 - 1.0));
        int j1 = Mth.floor((double)(center.z + (double)f3 + 1.0));
        List list = this.world.getEntities(this.getDirectSourceEntity(), new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        EventHooks.onExplosionDetonate((Level)this.world, (Explosion)this, (List)list, (double)f3);
        Vec3 vec3 = new Vec3(center.x, center.y, center.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.ignoreExplosion((Explosion)this) || !((d12 = entity.position().distanceToSqr(center.x, center.y, center.z) / (double)f3) <= 1.0) || (d13 = (double)Mth.sqrt((float)((float)((d5 = entity.getX() - center.x) * d5 + (d7 = entity.getY() + (double)entity.getEyeHeight() - center.y) * d7 + (d9 = entity.getZ() - center.z) * d9)))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = IEExplosion.getSeenPercent((Vec3)vec3, (Entity)entity);
            double d10 = (1.0 - d12) * d14;
            entity.hurt(entity.damageSources().explosion((Explosion)this), (float)((int)((d10 * d10 + d10) / 2.0 * 8.0 * (double)f3 + 1.0)));
            double d11 = d10;
            entity.setDeltaMovement(entity.getDeltaMovement().add(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof Player) || ((Player)entity).getAbilities().invulnerable) continue;
            this.getHitPlayers().put((Player)entity, new Vec3(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void finalizeExplosion(boolean spawnParticles) {
        Vec3 pos = this.center();
        if (this.world.isClientSide) {
            this.world.playLocalSound(pos.x, pos.y, pos.z, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.NEUTRAL, 4.0f, (1.0f + (ApiUtils.RANDOM.nextFloat() - ApiUtils.RANDOM.nextFloat()) * 0.2f) * 0.7f, true);
        }
        if (this.size >= 2.0f && this.damagesTerrain != Explosion.BlockInteraction.KEEP) {
            this.world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, pos.x, pos.y, pos.z, 1.0, 0.0, 0.0);
        } else {
            this.world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, pos.x, pos.y, pos.z, 1.0, 0.0, 0.0);
        }
        if (!this.world.isClientSide) {
            EventHandler.currentExplosions.computeIfAbsent(this.world, $ -> new HashSet()).add(this);
        }
    }
}

