/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.common.items.VoltmeterItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.MessageRedstoneLevel;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageRequestRedstoneUpdate(BlockPos pos) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageRequestRedstoneUpdate> ID = IMessage.createType("request_rs_update");
    public static final StreamCodec<ByteBuf, MessageRequestRedstoneUpdate> CODEC = BlockPos.STREAM_CODEC.map(MessageRequestRedstoneUpdate::new, MessageRequestRedstoneUpdate::pos);

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            Level level = context.player().level();
            BlockState blockState = level.getBlockState(this.pos);
            VoltmeterItem.RemoteRedstoneData data = new VoltmeterItem.RemoteRedstoneData(this.pos, level.getGameTime(), blockState.isSignalSource(), MessageRequestRedstoneUpdate.redstoneLevel(level, this.pos));
            PacketDistributor.sendToPlayer((ServerPlayer)IMessage.serverPlayer(context), (CustomPacketPayload)new MessageRedstoneLevel(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    public static byte redstoneLevel(Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        byte redstoneLevel = 0;
        if (blockState != null) {
            if (blockState.isSignalSource()) {
                redstoneLevel = blockState.getOptionalValue((Property)RedStoneWireBlock.POWER).orElse(0).byteValue();
                for (Direction facing : Direction.values()) {
                    redstoneLevel = (byte)Math.max(redstoneLevel, blockState.getSignal((BlockGetter)level, pos, facing));
                }
            } else {
                redstoneLevel = (byte)Math.max(redstoneLevel, level.getDirectSignalTo(pos));
            }
        }
        return redstoneLevel;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

