/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.codec.IEDualCodecs;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Iterators;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.IntIterators;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;

public class SorterBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IInteractionObjectIE<SorterBlockEntity>,
IEBlockInterfaces.IBlockEntityDrop {
    public static final int FILTER_SLOTS_PER_SIDE = 8;
    public static final int TOTAL_SLOTS = 48;
    public static final DualCodec<ByteBuf, Map<Direction, FilterConfig>> FILTER_CODEC = IEDualCodecs.forMap(IEDualCodecs.forEnum((Enum[])Direction.values()), FilterConfig.CODEC);
    public SorterInventory filter;
    public Map<Direction, FilterConfig> sideFilter = (Map)Util.make(new EnumMap(Direction.class), l -> {
        for (Direction d : Direction.values()) {
            l.put(d, FilterConfig.DEFAULT);
        }
    });
    private static Set<BlockPos> routed = null;
    private final Map<Direction, IEBlockCapabilityCaches.IEBlockCapabilityCache<IItemHandler>> neighborCaps = IEBlockCapabilityCaches.allNeighbors(Capabilities.ItemHandler.BLOCK, this);
    private final EnumMap<Direction, IItemHandler> insertionHandlers = new EnumMap(Direction.class);

    public SorterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.SORTER.get(), pos, state);
        for (Direction f : DirectionUtils.VALUES) {
            this.insertionHandlers.put(f, (IItemHandler)new SorterInventoryHandler(this, f));
        }
        this.filter = new SorterInventory();
    }

    public ItemStack routeItem(Direction inputSide, ItemStack stack, boolean simulate) {
        if (!this.level.isClientSide && this.canRoute()) {
            boolean first = this.startRouting();
            Direction[][] validOutputs = this.getValidOutputs(inputSide, stack);
            stack = this.doInsert(stack, validOutputs[0], simulate);
            if (validOutputs[0].length == 0 || !stack.isEmpty()) {
                stack = this.doInsert(stack, validOutputs[1], simulate);
            }
            if (first) {
                routed = null;
            }
        }
        return stack;
    }

    private boolean canRoute() {
        return routed == null || !routed.contains(this.worldPosition);
    }

    private boolean startRouting() {
        boolean first;
        boolean bl = first = routed == null;
        if (first) {
            routed = new HashSet<BlockPos>();
        }
        routed.add(this.worldPosition);
        return first;
    }

    private ItemStack doInsert(ItemStack stack, Direction[] sides, boolean simulate) {
        for (int lengthFiltered = sides.length; lengthFiltered > 0 && !stack.isEmpty(); --lengthFiltered) {
            int rand = ApiUtils.RANDOM.nextInt(lengthFiltered);
            stack = this.outputItemToInv(stack, sides[rand], simulate);
            sides[rand] = sides[lengthFiltered - 1];
        }
        return stack;
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public SorterBlockEntity getGuiMaster() {
        return this;
    }

    @Override
    public IEMenuTypes.ArgContainer<SorterBlockEntity, ?> getContainerType() {
        return IEMenuTypes.SORTER;
    }

    public Direction[][] getValidOutputs(Direction inputSide, ItemStack stack) {
        if (stack.isEmpty()) {
            return new Direction[][]{new Direction[0], new Direction[0], new Direction[0], new Direction[0]};
        }
        ArrayList<Direction> validFiltered = new ArrayList<Direction>(6);
        ArrayList<Direction> validUnfiltered = new ArrayList<Direction>(6);
        for (Direction side : Direction.values()) {
            if (side == inputSide) continue;
            EnumFilterResult result = this.checkStackAgainstFilter(stack, side);
            if (result == EnumFilterResult.VALID_FILTERED) {
                validFiltered.add(side);
                continue;
            }
            if (result != EnumFilterResult.VALID_UNFILTERED) continue;
            validUnfiltered.add(side);
        }
        return new Direction[][]{validFiltered.toArray(new Direction[0]), validUnfiltered.toArray(new Direction[0])};
    }

    public ItemStack pullItem(Direction outputSide, int amount, boolean simulate) {
        if (!this.level.isClientSide && this.canRoute()) {
            boolean first = this.startRouting();
            for (Direction side : Direction.values()) {
                IEBlockCapabilityCaches.IEBlockCapabilityCache<IItemHandler> capRef;
                IItemHandler itemHandler;
                if (side == outputSide || (itemHandler = (capRef = this.neighborCaps.get(side)).getCapability()) == null) continue;
                Predicate<ItemStack> concatFilter = null;
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack extractItem = itemHandler.extractItem(i, amount, true);
                    if (extractItem.isEmpty()) continue;
                    if (concatFilter == null) {
                        concatFilter = this.concatFilters(outputSide, side);
                    }
                    if (!concatFilter.test(extractItem)) continue;
                    if (first) {
                        routed = null;
                    }
                    if (!simulate) {
                        itemHandler.extractItem(i, amount, false);
                    }
                    return extractItem;
                }
            }
            if (first) {
                routed = null;
            }
        }
        return ItemStack.EMPTY;
    }

    private static DataComponentMap getComponentsWithoutDamage(ItemStack stack) {
        return stack.getComponents().filter(type -> type != DataComponents.DAMAGE);
    }

    private EnumFilterResult checkStackAgainstFilter(ItemStack stack, Direction side) {
        boolean unmapped = true;
        for (ItemStack filterStack : this.filter.getFilterStacksOnSide(side)) {
            if (filterStack.isEmpty()) continue;
            unmapped = false;
            if (!this.sideFilter.get(side).compareStackToFilterstack(stack, filterStack)) continue;
            return EnumFilterResult.VALID_FILTERED;
        }
        if (unmapped) {
            return EnumFilterResult.VALID_UNFILTERED;
        }
        return EnumFilterResult.INVALID;
    }

    private Predicate<ItemStack> concatFilters(final Direction side0, Direction side1) {
        final ArrayList<ItemStack> concat = new ArrayList<ItemStack>();
        for (ItemStack itemStack : this.filter.getFilterStacksOnSide(side0)) {
            if (itemStack.isEmpty()) continue;
            concat.add(itemStack);
        }
        Predicate<ItemStack> matchFilter = concat.isEmpty() ? stack -> true : new Predicate<ItemStack>(){
            final Set<ItemStack> filter;
            final FilterConfig config;
            {
                this.filter = new HashSet<ItemStack>(concat);
                this.config = SorterBlockEntity.this.sideFilter.get(side0);
            }

            @Override
            public boolean test(ItemStack stack) {
                for (ItemStack filterStack : this.filter) {
                    if (!this.config.compareStackToFilterstack(stack, filterStack)) continue;
                    return true;
                }
                return false;
            }
        };
        for (ItemStack filterStack : this.filter.getFilterStacksOnSide(side1)) {
            if (filterStack.isEmpty() || !matchFilter.test(filterStack)) continue;
            concat.add(filterStack);
        }
        FilterConfig filterConfig = this.sideFilter.get(side0);
        FilterConfig filterTo = this.sideFilter.get(side1);
        boolean concatFuzzy = filterConfig.ignoreDamage || filterTo.ignoreDamage;
        boolean concatOredict = filterConfig.allowTags || filterTo.allowTags;
        boolean concatNBT = filterConfig.considerComponents || filterTo.considerComponents;
        FilterConfig combinedFilter = new FilterConfig(concatOredict, concatNBT, concatFuzzy);
        return concat.isEmpty() ? stack -> true : stack -> {
            for (ItemStack filterStack : concat) {
                if (!combinedFilter.compareStackToFilterstack((ItemStack)stack, filterStack)) continue;
                return true;
            }
            return false;
        };
    }

    public ItemStack outputItemToInv(ItemStack stack, Direction side, boolean simulate) {
        return Utils.insertStackIntoInventory(this.neighborCaps.get(side), stack, simulate);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        this.sideFilter = (Map)FILTER_CODEC.fromNBT(nbt.get("sideFilter"));
        if (!descPacket) {
            ListTag filterList = nbt.getList("filter", 10);
            this.filter = new SorterInventory();
            this.filter.readFromNBT(provider, filterList);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        nbt.put("sideFilter", FILTER_CODEC.toNBT(this.sideFilter));
        if (!descPacket) {
            ListTag filterList = new ListTag();
            this.filter.writeToNBT(provider, filterList);
            nbt.put("filter", (Tag)filterList);
        }
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        CompoundTag data = new CompoundTag();
        this.writeCustomNBT(data, false, (HolderLookup.Provider)context.getLevel().registryAccess());
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock(), 1);
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)data));
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        CustomData data = (CustomData)ctx.getItemInHand().get(DataComponents.BLOCK_ENTITY_DATA);
        if (data != null) {
            this.readCustomNBT(data.copyTag(), false, (HolderLookup.Provider)ctx.getLevel().registryAccess());
        }
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<SorterBlockEntity> registrar) {
        registrar.register(Capabilities.ItemHandler.BLOCK, (be, facing) -> facing != null ? be.insertionHandlers.get(facing) : null);
    }

    @Override
    public boolean triggerEvent(int id, int arg) {
        return id == 0;
    }

    public static class SorterInventoryHandler
    implements IItemHandlerModifiable {
        SorterBlockEntity sorter;
        Direction side;

        public SorterInventoryHandler(SorterBlockEntity sorter, Direction side) {
            this.sorter = sorter;
            this.side = side;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.sorter.routeItem(this.side, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.sorter.pullItem(this.side, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }

    public static class SorterInventory
    extends ItemStackHandler {
        public SorterInventory() {
            super(NonNullList.withSize((int)48, (Object)ItemStack.EMPTY));
        }

        public ItemStack getStackBySideAndSlot(Direction side, int slotOnSide) {
            return this.getStackInSlot(this.getSlotId(side, slotOnSide));
        }

        public int getSlotId(Direction side, int slotOnSide) {
            return side.ordinal() * 8 + slotOnSide;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public Iterable<ItemStack> getFilterStacksOnSide(Direction side) {
            return () -> Iterators.transform((Iterator)IntIterators.fromTo((int)0, (int)8), i -> this.getStackBySideAndSlot(side, (int)i));
        }

        public void writeToNBT(HolderLookup.Provider provider, ListTag list) {
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack slot = this.getStackInSlot(i);
                if (slot.isEmpty()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.putByte("Slot", (byte)i);
                list.add((Object)slot.save(provider, (Tag)itemTag));
            }
        }

        public void readFromNBT(HolderLookup.Provider provider, ListTag list) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag itemTag = list.getCompound(i);
                int slot = itemTag.getByte("Slot") & 0xFF;
                if (slot >= this.getSlots()) continue;
                this.setStackInSlot(slot, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemTag));
            }
        }
    }

    private static enum EnumFilterResult {
        INVALID,
        VALID_FILTERED,
        VALID_UNFILTERED;

    }

    public record FilterConfig(boolean allowTags, boolean considerComponents, boolean ignoreDamage) {
        public static final FilterConfig DEFAULT = new FilterConfig(false, false, false);
        public static final DualCodec<ByteBuf, FilterConfig> CODEC = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.BOOL.fieldOf("allowTags"), FilterConfig::allowTags, (DualMapCodec)DualCodecs.BOOL.fieldOf("considerComponents"), FilterConfig::considerComponents, (DualMapCodec)DualCodecs.BOOL.fieldOf("ignoreDamage"), FilterConfig::ignoreDamage, FilterConfig::new);

        public boolean compareStackToFilterstack(ItemStack stack, ItemStack filterStack) {
            DataComponentMap filterTag;
            DataComponentMap stackTag;
            int damageFilter;
            int damageStack;
            if (this.allowTags) {
                if (stack.getItem().builtInRegistryHolder().tags().noneMatch(arg_0 -> ((ItemStack)filterStack).is(arg_0))) {
                    return false;
                }
            } else if (!ItemStack.isSameItem((ItemStack)filterStack, (ItemStack)stack)) {
                return false;
            }
            if (!this.ignoreDamage && (stack.isDamageableItem() || filterStack.isDamageableItem()) && (damageStack = stack.getDamageValue()) != (damageFilter = filterStack.getDamageValue())) {
                return false;
            }
            return !this.considerComponents || (stackTag = SorterBlockEntity.getComponentsWithoutDamage(stack)).equals((Object)(filterTag = SorterBlockEntity.getComponentsWithoutDamage(filterStack)));
        }
    }
}

