/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Unit;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WarningSignBlock
extends IEBaseBlock {
    private final WarningSignIcon icon;
    private static final CachedShapesWithTransform<Unit, Direction> SHAPES = CachedShapesWithTransform.createDirectional($ -> ImmutableList.of((Object)new AABB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 0.0625)));

    public WarningSignBlock(WarningSignIcon icon, BlockBehaviour.Properties properties) {
        super(properties);
        this.icon = icon;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IEProperties.FACING_HORIZONTAL, BlockStateProperties.WATERLOGGED});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)IEProperties.FACING_HORIZONTAL, (Comparable)context.getHorizontalDirection());
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return SHAPES.get(Unit.INSTANCE, (Direction)state.getValue((Property)IEProperties.FACING_HORIZONTAL));
    }

    public static enum WarningSignIcon implements StringRepresentable
    {
        ATTENTION(false),
        MAGNET(true),
        COLD(true),
        ELECTRIC(true),
        HOT(true),
        FIRE(true),
        FALLING(true),
        SOUND(true),
        EAR_DEFENDERS(true),
        CAT(true),
        VILLAGER(false),
        TURRET(true),
        CREEPER(false),
        SHRIEKER(false),
        WARDEN(true),
        ARROW_UP(false),
        ARROW_DOWN(false),
        ARROW_LEFT(false),
        ARROW_RIGHT(false),
        ARROW_DOUBLE_UP(false),
        ARROW_DOUBLE_DOWN(false),
        ARROW_DOUBLE_LEFT(false),
        ARROW_DOUBLE_RIGHT(false);

        private final boolean hasBanner;

        private WarningSignIcon(boolean hasBanner) {
            this.hasBanner = hasBanner;
        }

        public boolean hasBanner() {
            return this.hasBanner;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

