/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorBelt;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.mixin.accessors.ItemEntityAccess;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class ChuteBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.ICollisionBounds {
    private static final String NBT_POS = "immersiveengineering:chutePos";
    private static final String NBT_TIME = "immersiveengineering:chuteTime";
    private static final String NBT_GLITCH = "immersiveengineering:chuteGlitched";
    private static final String NBT_COUNT = "immersiveengineering:chuteCount";
    private boolean diagonal = false;
    static final Map<Direction, AABB> AABB_SIDES = new EnumMap<Direction, AABB>(Direction.class);
    static final AABB AABB_DOWN;
    private static final CachedVoxelShapes<BoundingBoxKey> SHAPES;
    static final VoxelShape selectionShape;
    private final IItemHandler insertionCap = new ChuteInventoryHandler(this);

    public ChuteBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.CHUTE.get(), pos, state);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return !entity.isShiftKeyDown();
    }

    @Override
    public void onEntityCollision(Level world, Entity entity) {
        boolean contact = false;
        Direction facing = this.getFacing();
        if (!this.diagonal) {
            contact = entity.getY() - (double)this.getBlockPos().getY() <= 0.125;
        } else if (facing == Direction.NORTH) {
            contact = entity.getZ() - (double)this.getBlockPos().getZ() <= 0.125;
        } else if (facing == Direction.SOUTH) {
            contact = entity.getZ() - (double)this.getBlockPos().getZ() >= 0.875;
        } else if (facing == Direction.WEST) {
            contact = entity.getX() - (double)this.getBlockPos().getX() <= 0.125;
        } else if (facing == Direction.EAST) {
            boolean bl = contact = entity.getX() - (double)this.getBlockPos().getX() >= 0.875;
        }
        if (this.diagonal && entity.getY() - (double)this.getBlockPos().getY() <= 0.625) {
            boolean glitched;
            boolean opposedChute;
            BlockPos target = this.getBlockPos().relative(facing);
            BlockEntity targetTile = world.getBlockEntity(target);
            boolean bl = opposedChute = targetTile instanceof ChuteBlockEntity && ((ChuteBlockEntity)targetTile).diagonal;
            if (opposedChute) {
                return;
            }
            long time = world.getGameTime();
            long nbt_pos = this.getBlockPos().asLong();
            long timeSince = time - entity.getPersistentData().getLong(NBT_TIME);
            boolean prevent = entity.getPersistentData().contains(NBT_POS) && nbt_pos == entity.getPersistentData().getLong(NBT_POS) && timeSince < 20L;
            boolean bl2 = glitched = entity.getPersistentData().contains(NBT_GLITCH) && time - entity.getPersistentData().getLong(NBT_GLITCH) < 1200L;
            if ((double)entity.getBbWidth() > 0.75 || (double)entity.getBbHeight() > 0.75) {
                if (world.getBlockState(target).isSuffocating((BlockGetter)world, target)) {
                    return;
                }
                if (!glitched) {
                    Vec3 oldPos = entity.position();
                    double py = entity.getBbHeight() > 1.0f ? (double)this.getBlockPos().getY() + 0.125 : entity.getY();
                    entity.setPos((double)target.getX() + 0.5, py, (double)target.getZ() + 0.5);
                    if (entity.isInWall()) {
                        entity.setPos(oldPos.x, oldPos.y, oldPos.z);
                        entity.getPersistentData().putLong(NBT_GLITCH, time);
                    }
                }
            } else {
                double mY = entity.getDeltaMovement().y;
                if (mY == 0.0) {
                    mY = 0.015;
                }
                entity.setDeltaMovement((double)facing.getStepX(), mY, (double)facing.getStepZ());
            }
            if (!(contact || prevent || glitched)) {
                world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)IESounds.chute.value(), SoundSource.BLOCKS, 0.6f + 0.4f * world.random.nextFloat(), 0.5f + 0.5f * world.random.nextFloat());
                CompoundTag entityData = entity.getPersistentData();
                entityData.putLong(NBT_POS, nbt_pos);
                entityData.putLong(NBT_TIME, time);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!world.isClientSide()) {
                        int bonkCount = entityData.getInt(NBT_COUNT) + 1;
                        if (timeSince > 200L) {
                            bonkCount = 1;
                        }
                        entity.getPersistentData().putInt(NBT_COUNT, bonkCount);
                        if (bonkCount >= 6) {
                            Utils.unlockIEAdvancement(player, "main/chute_bonk");
                        }
                    }
                }
            }
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            itemEntity.setPickUpDelay(10);
            if (!contact) {
                if (itemEntity.getAge() > itemEntity.lifespan - 1200) {
                    ((ItemEntityAccess)itemEntity).setAge(itemEntity.lifespan - 1200);
                }
            } else {
                Direction insertFrom;
                BlockPos invPos = this.diagonal ? this.getBlockPos().relative(facing) : this.getBlockPos().below();
                BlockEntity inventoryTile = world.getBlockEntity(invPos);
                Direction direction = insertFrom = this.diagonal ? facing.getOpposite() : Direction.UP;
                if (!world.isClientSide && this.isValidTargetInventory(inventoryTile)) {
                    ItemUtils.tryInsertEntity(world, invPos, insertFrom, itemEntity);
                }
            }
        }
    }

    private boolean isValidTargetInventory(@Nullable BlockEntity inventoryTile) {
        if (inventoryTile != null) {
            if (inventoryTile instanceof ConveyorHandler.IConveyorBlockEntity) {
                ConveyorHandler.IConveyorBlockEntity conveyorTile = (ConveyorHandler.IConveyorBlockEntity)inventoryTile;
                return ChuteBlockEntity.isCovered(conveyorTile.getConveyorInstance());
            }
            return true;
        }
        return false;
    }

    private static <T extends IConveyorBelt> boolean isCovered(IConveyorBelt belt) {
        return IConveyorBelt.isCovered(belt, Blocks.AIR);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        this.diagonal = nbt.getBoolean("diagonal");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        nbt.putBoolean("diagonal", this.diagonal);
    }

    @Override
    public VoxelShape getCollisionShape(CollisionContext ctx) {
        return SHAPES.get(new BoundingBoxKey(this));
    }

    @Override
    public VoxelShape getSelectionShape(@Nullable CollisionContext ctx) {
        return selectionShape;
    }

    public boolean isInwardConveyor(Direction f) {
        Object sub;
        ConveyorHandler.IConveyorBlockEntity conveyorBE;
        BlockEntity te = this.level.getBlockEntity(this.getBlockPos().relative(f));
        if (te instanceof ConveyorHandler.IConveyorBlockEntity) {
            conveyorBE = (ConveyorHandler.IConveyorBlockEntity)te;
            Object sub2 = conveyorBE.getConveyorInstance();
            if (sub2 != null) {
                boolean isInputting = false;
                Direction[] directionArray = sub2.sigTransportDirections();
                int n = directionArray.length;
                for (int i = 0; i < n; ++i) {
                    Direction f2 = directionArray[i];
                    if (f == f2.getOpposite()) {
                        isInputting = true;
                        continue;
                    }
                    if (f2 != Direction.UP) continue;
                    isInputting = false;
                    break;
                }
                if (isInputting) {
                    return true;
                }
            }
        } else if (te instanceof ChuteBlockEntity) {
            ChuteBlockEntity chute = (ChuteBlockEntity)te;
            return chute.diagonal && chute.getFacing() == f.getOpposite();
        }
        if ((te = this.level.getBlockEntity(this.getBlockPos().offset(0, -1, 0).relative(f))) instanceof ConveyorHandler.IConveyorBlockEntity && (sub = (conveyorBE = (ConveyorHandler.IConveyorBlockEntity)te).getConveyorInstance()) != null) {
            int b = 0;
            for (Direction f2 : sub.sigTransportDirections()) {
                if (f == f2.getOpposite()) {
                    ++b;
                } else if (Direction.UP == f2) {
                    ++b;
                }
                if (b != 2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (player.isShiftKeyDown()) {
            if (!this.level.isClientSide) {
                this.diagonal = !this.diagonal;
                this.setChanged();
                this.markContainingBlockForUpdate(null);
                this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean triggerEvent(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    public boolean isDiagonal() {
        return this.diagonal;
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<ChuteBlockEntity> registrar) {
        registrar.registerOnContext(Capabilities.ItemHandler.BLOCK, be -> be.insertionCap, Direction.UP);
    }

    static {
        AABB_SIDES.put(Direction.NORTH, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625));
        AABB_SIDES.put(Direction.SOUTH, new AABB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0));
        AABB_SIDES.put(Direction.WEST, new AABB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0));
        AABB_SIDES.put(Direction.EAST, new AABB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0));
        AABB_DOWN = new AABB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        SHAPES = new CachedVoxelShapes<BoundingBoxKey>(BoundingBoxKey::getBoxes);
        selectionShape = Shapes.block();
    }

    public static class ChuteInventoryHandler
    implements IItemHandler {
        ChuteBlockEntity chute;

        public ChuteInventoryHandler(ChuteBlockEntity chute) {
            this.chute = chute;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!simulate) {
                ItemEntity entity = new ItemEntity(this.chute.getLevelNonnull(), (double)this.chute.getBlockPos().getX() + 0.5, (double)this.chute.getBlockPos().getY() + 0.5, (double)this.chute.getBlockPos().getZ() + 0.5, stack.copy());
                entity.setDeltaMovement(Vec3.ZERO);
                this.chute.getLevelNonnull().addFreshEntity((Entity)entity);
                entity.setPickUpDelay(10);
            }
            return ItemStack.EMPTY;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }

    private static class BoundingBoxKey {
        private final boolean diagonal;
        private final Set<Direction> sidesToAdd;

        private BoundingBoxKey(ChuteBlockEntity te) {
            this.diagonal = te.diagonal;
            this.sidesToAdd = EnumSet.noneOf(Direction.class);
            for (Direction dir : DirectionUtils.BY_HORIZONTAL_INDEX) {
                if (te.isInwardConveyor(dir) || this.diagonal && dir == te.getFacing()) continue;
                this.sidesToAdd.add(dir);
            }
        }

        private List<AABB> getBoxes() {
            ArrayList<AABB> list = new ArrayList<AABB>();
            for (Direction d : this.sidesToAdd) {
                list.add(AABB_SIDES.get(d));
            }
            for (Direction sideA : DirectionUtils.BY_HORIZONTAL_INDEX) {
                Direction sideB = sideA.getClockWise();
                if (this.sidesToAdd.contains(sideA) || this.sidesToAdd.contains(sideB)) continue;
                AABB boxA = AABB_SIDES.get(sideA);
                AABB boxB = AABB_SIDES.get(sideB);
                list.add(boxA.intersect(boxB));
            }
            if (this.diagonal) {
                list.add(AABB_DOWN);
            }
            return list;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundingBoxKey that = (BoundingBoxKey)o;
            return this.diagonal == that.diagonal && this.sidesToAdd.equals(that.sidesToAdd);
        }

        public int hashCode() {
            return Objects.hash(this.diagonal, this.sidesToAdd);
        }
    }
}

