/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.BatchingRenderTypeBuffer;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class GuiHelper {
    public static void drawColouredRect(int x, int y, int w, int h, int colour, MultiBufferSource buffers, PoseStack transform) {
        Matrix4f mat = transform.last().pose();
        VertexConsumer worldrenderer = buffers.getBuffer(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
        worldrenderer.setColor(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF);
        worldrenderer.addVertex(mat, (float)x, (float)(y + h), 0.0f);
        worldrenderer.addVertex(mat, (float)(x + w), (float)(y + h), 0.0f);
        worldrenderer.addVertex(mat, (float)(x + w), (float)y, 0.0f);
        worldrenderer.addVertex(mat, (float)x, (float)y, 0.0f);
    }

    public static void drawColouredRect(GuiGraphics graphics, int x, int y, int w, int h, DyeColor dyeColor) {
        Matrix4f mat = graphics.pose().last().pose();
        VertexConsumer bufferbuilder = graphics.bufferSource().getBuffer(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
        Vector4f color = Utils.vec4fFromDye(dyeColor);
        bufferbuilder.addVertex(mat, (float)x, (float)(y + h), 0.0f).setColor(color.x, color.y, color.z, 1.0f);
        bufferbuilder.addVertex(mat, (float)(x + w), (float)(y + h), 0.0f).setColor(color.x, color.y, color.z, 1.0f);
        bufferbuilder.addVertex(mat, (float)(x + w), (float)y, 0.0f).setColor(color.x, color.y, color.z, 1.0f);
        bufferbuilder.addVertex(mat, (float)x, (float)y, 0.0f).setColor(color.x, color.y, color.z, 1.0f);
    }

    public static void drawTexturedColoredRect(VertexConsumer builder, PoseStack transform, float x, float y, float w, float h, float r, float g, float b, float alpha, float u0, float u1, float v0, float v1) {
        TransformingVertexBuilder innerBuilder = new TransformingVertexBuilder(builder, transform);
        innerBuilder.defaultColor(r, g, b, alpha);
        innerBuilder.setDefaultLight(0xF000F0);
        innerBuilder.setDefaultOverlay(OverlayTexture.NO_OVERLAY);
        innerBuilder.setDefaultNormal(1.0f, 1.0f, 1.0f);
        innerBuilder.addVertex(x, y + h, 0.0f).setUv(u0, v1);
        innerBuilder.addVertex(x + w, y + h, 0.0f).setUv(u1, v1);
        innerBuilder.addVertex(x + w, y, 0.0f).setUv(u1, v0);
        innerBuilder.addVertex(x, y, 0.0f).setUv(u0, v0);
        innerBuilder.unsetDefaultColor();
    }

    public static void drawTexturedRect(VertexConsumer builder, PoseStack transform, int x, int y, int w, int h, float picSize, int u0, int u1, int v0, int v1) {
        GuiHelper.drawTexturedColoredRect(builder, transform, x, y, w, h, 1.0f, 1.0f, 1.0f, 1.0f, (float)u0 / picSize, (float)u1 / picSize, (float)v0 / picSize, (float)v1 / picSize);
    }

    public static void drawRepeatedFluidSpriteGui(MultiBufferSource buffer, PoseStack transform, FluidStack fluid, float x, float y, float w, float h) {
        VertexConsumer builder = buffer.getBuffer(RenderType.TRANSLUCENT);
        GuiHelper.drawRepeatedFluidSprite(builder, transform, fluid, x, y, w, h);
    }

    public static void drawRepeatedFluidSprite(VertexConsumer builder, PoseStack transform, FluidStack fluid, float x, float y, float w, float h) {
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite sprite = ClientUtils.getSprite(props.getStillTexture(fluid));
        int col = props.getTintColor(fluid);
        int iW = sprite.contents().width();
        int iH = sprite.contents().height();
        if (iW > 0 && iH > 0) {
            GuiHelper.drawRepeatedSprite(builder, transform, x, y, w, h, iW, iH, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, (float)(col >> 24 & 0xFF) / 255.0f);
        }
    }

    public static void drawRepeatedSprite(VertexConsumer builder, PoseStack transform, float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float alpha) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                GuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), iconWidth, iconHeight, r, g, b, alpha, uMin, uMax, vMin, vMax);
            }
            GuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), iconWidth, leftoverH, r, g, b, alpha, uMin, uMax, vMin, vMin + iconVDif * leftoverHf);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                GuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, iconHeight, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMax);
            }
            GuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf);
        }
    }

    public static void drawSlot(int x, int y, int w, int h, GuiGraphics graphics) {
        GuiHelper.drawSlot(x, y, w, h, 255, graphics);
    }

    public static void drawSlot(GuiGraphics graphics, int x, int y, int w, int h, int dark, int main, int light) {
        int minX = x + 8 - w / 2;
        int minY = y + 8 - h / 2;
        int maxX = minX + w;
        int maxY = minY + h;
        graphics.fill(minX, minY - 1, maxX, minY, dark);
        graphics.fill(minX - 1, minY - 1, minX, maxY, dark);
        graphics.fill(minX, minY, maxX, maxY, main);
        graphics.fill(minX, maxY, maxX + 1, maxY + 1, light);
        graphics.fill(maxX, minY, maxX + 1, maxY, light);
    }

    public static void drawSlot(int x, int y, int w, int h, int alpha, GuiGraphics graphics) {
        GuiHelper.drawSlot(graphics, x, y, w, h, alpha << 24 | 0x373737, alpha << 24 | 0x8B8B8B, alpha << 24 | 0xFFFFFF);
    }

    public static void drawDarkSlot(GuiGraphics graphics, int x, int y, int w, int h) {
        GuiHelper.drawSlot(graphics, x, y, w, h, 0x77222222, 0x77111111, 0x77999999);
    }

    public static void renderItemWithOverlayIntoGUI(GuiGraphics graphics, ItemStack stack, int x, int y, Level level) {
        ItemRenderer itemRenderer = ClientUtils.mc().getItemRenderer();
        BakedModel bakedModel = itemRenderer.getModel(stack, null, (LivingEntity)ClientUtils.mc().player, 0);
        if (!bakedModel.usesBlockLight()) {
            Lighting.setupForFlatItems();
        }
        PoseStack transform = graphics.pose();
        transform.pushPose();
        transform.translate((float)x, (float)y, 100.0f);
        transform.pushPose();
        transform.translate(8.0f, 8.0f, 0.0f);
        transform.scale(1.0f, -1.0f, 1.0f);
        transform.scale(16.0f, 16.0f, 16.0f);
        BatchingRenderTypeBuffer batchBuffer = new BatchingRenderTypeBuffer();
        itemRenderer.renderStatic(stack, ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.NO_OVERLAY, transform, (MultiBufferSource)batchBuffer, level, 0);
        MultiBufferSource.BufferSource buffer = graphics.bufferSource();
        batchBuffer.pipe((MultiBufferSource)buffer);
        transform.popPose();
        GuiHelper.renderDurabilityBar(stack, (MultiBufferSource)buffer, transform);
        transform.popPose();
    }

    public static void renderDurabilityBar(ItemStack stack, MultiBufferSource buffer, PoseStack transform) {
        if (!stack.isEmpty() && stack.getItem().isBarVisible(stack)) {
            int width = stack.getItem().getBarWidth(stack);
            int color = stack.getItem().getBarColor(stack);
            GuiHelper.draw(transform, buffer, 2, 13, 13, 2, 0, 0, 0);
            GuiHelper.draw(transform, buffer, 2, 13, width, 1, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
        }
    }

    private static void draw(PoseStack transform, MultiBufferSource buffer, int x, int y, int width, int height, int red, int green, int blue) {
        VertexConsumer builder = buffer.getBuffer(IERenderTypes.ITEM_DAMAGE_BAR);
        transform.pushPose();
        transform.translate((float)x, (float)y, 0.0f);
        Matrix4f mat = transform.last().pose();
        builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(red, green, blue, 255);
        builder.addVertex(mat, 0.0f, (float)height, 0.0f).setColor(red, green, blue, 255);
        builder.addVertex(mat, (float)width, (float)height, 0.0f).setColor(red, green, blue, 255);
        builder.addVertex(mat, (float)width, 0.0f, 0.0f).setColor(red, green, blue, 255);
        transform.popPose();
    }
}

