/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.common.entities.IEExplosiveEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Quaternionf;

public class IEExplosiveRenderer
extends EntityRenderer<IEExplosiveEntity> {
    public IEExplosiveRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
        this.shadowRadius = 0.5f;
    }

    public void render(IEExplosiveEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (entity.block == null) {
            return;
        }
        BlockRenderDispatcher blockrendererdispatcher = Minecraft.getInstance().getBlockRenderer();
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0f, 0.5f, 0.0f);
        if ((float)entity.getFuse() - partialTicks + 1.0f < 10.0f) {
            float f = 1.0f - ((float)entity.getFuse() - partialTicks + 1.0f) / 10.0f;
            f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f1 = 1.0f + f * 0.3f;
            matrixStackIn.scale(f1, f1, f1);
        }
        matrixStackIn.mulPose(new Quaternionf().rotateXYZ(0.0f, -1.5707964f, 0.0f));
        matrixStackIn.translate(-0.5, -0.5, 0.5);
        matrixStackIn.mulPose(new Quaternionf().rotateXYZ(0.0f, 1.5707964f, 0.0f));
        int overlay = entity.getFuse() / 5 % 2 == 0 ? OverlayTexture.pack((int)OverlayTexture.u((float)1.0f), (int)10) : OverlayTexture.NO_OVERLAY;
        blockrendererdispatcher.renderSingleBlock(entity.block, matrixStackIn, bufferIn, packedLightIn, overlay);
        matrixStackIn.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(IEExplosiveEntity entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

