/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.Ingredient;

public class IECodecs {
    public static final Codec<NonNullList<Ingredient>> NONNULL_INGREDIENTS = Ingredient.LIST_CODEC.xmap(l -> {
        NonNullList result = NonNullList.create();
        result.addAll((Collection)l);
        return result;
    }, Function.identity());

    public static <E extends Enum<E>> Codec<E> enumCodec(E[] keys) {
        Map reverseLookup = Arrays.stream(keys).collect(Collectors.toMap(Enum::name, Function.identity()));
        return Codec.STRING.xmap(reverseLookup::get, Enum::name);
    }

    public static <K, T> Codec<Map<K, T>> listBasedMap(Codec<K> keyCodec, Codec<T> valueCodec) {
        Codec entryCodec = RecordCodecBuilder.create(inst -> inst.group((App)keyCodec.fieldOf("key").forGetter(Pair::getFirst), (App)valueCodec.fieldOf("value").forGetter(Pair::getSecond)).apply((Applicative)inst, Pair::of));
        return entryCodec.listOf().xmap(IECodecs::listToMap, IECodecs::mapToList);
    }

    public static <E extends Enum<E>, T> Codec<EnumMap<E, T>> listBasedEnumMap(E[] keys, Codec<T> valueCodec) {
        Codec keyCodec = IECodecs.enumCodec(keys);
        return IECodecs.listBasedMap(keyCodec, valueCodec).xmap(EnumMap::new, Function.identity());
    }

    public static <V> Codec<List<V>> directDispatchMap(final Function<String, Codec<V>> valueCodec, final Function<V, String> getKey) {
        return new Codec<List<V>>(){

            public <T> DataResult<Pair<List<V>, T>> decode(DynamicOps<T> ops, T input) {
                return ops.getMapValues(input).flatMap(s -> {
                    DataResult result = DataResult.success(new ArrayList());
                    for (Pair entry : s.toList()) {
                        result = result.flatMap(current -> ops.getStringValue(entry.getFirst()).flatMap(key -> ((Codec)valueCodec.apply(key)).decode(ops, entry.getSecond()).map(value -> {
                            ArrayList<Object> newMap = new ArrayList<Object>((Collection<Object>)current);
                            newMap.add(value.getFirst());
                            return newMap;
                        })));
                    }
                    return result.map(m -> new Pair(m, ops.empty()));
                });
            }

            public <T> DataResult<T> encode(List<V> input, DynamicOps<T> ops, T prefix) {
                DataResult result = DataResult.success(prefix);
                for (Object entry : input) {
                    result = result.flatMap(oldT -> {
                        String type = (String)getKey.apply(entry);
                        DataResult maybeValue = ((Codec)valueCodec.apply(type)).encodeStart(ops, entry);
                        Object key = ops.createString(type);
                        return maybeValue.flatMap(valueT -> ops.mergeToMap(oldT, key, valueT));
                    });
                }
                return result;
            }
        };
    }

    public static <C> Codec<Set<C>> setOf(Codec<C> codec) {
        return codec.listOf().xmap(Set::copyOf, List::copyOf);
    }

    static <K, T> Map<K, T> listToMap(List<Pair<K, T>> l) {
        return l.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    static <K, T> List<Pair<K, T>> mapToList(Map<K, T> m) {
        return m.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue())).toList();
    }
}

