/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.utils.codec.IEDualCodecs;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DyeColor;

public class LogicCircuitHandler {

    public static interface ILogicCircuitHandler {
        public boolean getLogicCircuitRegister(LogicCircuitRegister var1);

        public void setLogicCircuitRegister(LogicCircuitRegister var1, boolean var2);
    }

    public static final class LogicCircuitInstruction {
        public static final DualCodec<ByteBuf, LogicCircuitInstruction> CODECS = DualCompositeCodecs.composite((DualMapCodec)LogicCircuitOperator.CODECS.fieldOf("operator"), i -> i.operator, (DualMapCodec)LogicCircuitRegister.CODECS.fieldOf("output"), i -> i.output, (DualMapCodec)LogicCircuitRegister.CODECS.listOf().map(l -> l.toArray(new LogicCircuitRegister[0]), Arrays::asList).fieldOf("inputs"), i -> i.inputs, LogicCircuitInstruction::new);
        private final LogicCircuitOperator operator;
        private final LogicCircuitRegister output;
        private final LogicCircuitRegister[] inputs;
        private final MutableComponent formattedString;

        public LogicCircuitInstruction(LogicCircuitOperator operator, LogicCircuitRegister output, LogicCircuitRegister[] inputs) {
            Preconditions.checkArgument((operator.getArgumentCount() == inputs.length ? 1 : 0) != 0, (Object)"Logic inputs must match the argument count of the operator");
            this.operator = operator;
            this.output = output;
            this.inputs = inputs;
            this.formattedString = this.output.getDescription();
            this.formattedString.append(" = ");
            this.formattedString.append(this.operator.getDescription());
            for (int i = 0; i < inputs.length; ++i) {
                this.formattedString.append(i != 0 ? ", " : ": ");
                this.formattedString.append((Component)inputs[i].getDescription());
            }
        }

        public LogicCircuitOperator getOperator() {
            return this.operator;
        }

        public LogicCircuitRegister getOutput() {
            return this.output;
        }

        public LogicCircuitRegister[] getInputs() {
            return this.inputs;
        }

        public void apply(ILogicCircuitHandler handler) {
            boolean[] bInputs = new boolean[this.operator.getArgumentCount()];
            for (int i = 0; i < this.inputs.length; ++i) {
                bInputs[i] = handler.getLogicCircuitRegister(this.inputs[i]);
            }
            handler.setLogicCircuitRegister(this.output, this.operator.apply(bInputs));
        }

        public Component getFormattedString() {
            return this.formattedString;
        }

        public CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("operator", this.operator.name());
            nbt.putString("output", this.output.name());
            ListTag inputList = new ListTag();
            for (LogicCircuitRegister input : this.inputs) {
                inputList.add((Object)StringTag.valueOf((String)input.name()));
            }
            nbt.put("inputs", (Tag)inputList);
            return nbt;
        }

        public static LogicCircuitInstruction deserialize(CompoundTag nbt) {
            LogicCircuitOperator operator = LogicCircuitOperator.valueOf(nbt.getString("operator"));
            LogicCircuitRegister output = LogicCircuitRegister.valueOf(nbt.getString("output"));
            ListTag inputList = nbt.getList("inputs", 8);
            LogicCircuitRegister[] inputs = new LogicCircuitRegister[inputList.size()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = LogicCircuitRegister.valueOf(inputList.getString(i));
            }
            return new LogicCircuitInstruction(operator, output, inputs);
        }
    }

    public static enum LogicCircuitRegister {
        WHITE,
        ORANGE,
        MAGENTA,
        LIGHT_BLUE,
        YELLOW,
        LIME,
        PINK,
        GRAY,
        LIGHT_GRAY,
        CYAN,
        PURPLE,
        BLUE,
        BROWN,
        GREEN,
        RED,
        BLACK,
        R0,
        R1,
        R2,
        R3,
        R4,
        R5,
        R6,
        R7;

        public static final DualCodec<ByteBuf, LogicCircuitRegister> CODECS;

        public MutableComponent getDescription() {
            if (this.ordinal() < 16) {
                return Component.translatable((String)("color.minecraft." + DyeColor.byId((int)this.ordinal()).getName()));
            }
            return Component.translatable((String)"desc.immersiveengineering.info.register", (Object[])new Object[]{this.ordinal() - 16});
        }

        static {
            CODECS = IEDualCodecs.forEnum((Enum[])LogicCircuitRegister.values());
        }
    }

    public static enum LogicCircuitOperator {
        SET(1, args -> args[0], 0),
        NOT(1, args -> !args[0], 1),
        OR(2, args -> args[0] | args[1], 3),
        AND(2, args -> args[0] & args[1], 2),
        XOR(2, args -> args[0] ^ args[1], 4),
        NOR(2, args -> !(args[0] | args[1]), 4),
        NAND(2, args -> !(args[0] & args[1]), 1),
        XNOR(2, args -> args[0] == args[1], 5),
        IMPLY(2, args -> !args[0] | args[1], 2),
        NIMPLY(2, args -> args[0] & !args[1], 3);

        public static final DualCodec<ByteBuf, LogicCircuitOperator> CODECS;
        private final int argumentCount;
        private final Predicate<boolean[]> operator;
        private final int complexity;
        public static final int TOTAL_MAX_INPUTS;

        private LogicCircuitOperator(int argumentCount, Predicate<boolean[]> operator, int complexity) {
            this.argumentCount = argumentCount;
            this.operator = operator;
            this.complexity = complexity;
        }

        public int getArgumentCount() {
            return this.argumentCount;
        }

        public int getComplexity() {
            return this.complexity;
        }

        public boolean apply(boolean[] args) {
            return this.operator.test(args);
        }

        @Nullable
        public static LogicCircuitOperator getByString(String name) {
            if (name == null) {
                return null;
            }
            return LogicCircuitOperator.valueOf(name);
        }

        public Component getDescription() {
            return Component.translatable((String)("desc.immersiveengineering.info.operator." + this.name().toLowerCase(Locale.ENGLISH)));
        }

        static {
            CODECS = IEDualCodecs.forEnum((Enum[])LogicCircuitOperator.values());
            TOTAL_MAX_INPUTS = Arrays.stream(LogicCircuitOperator.values()).mapToInt(LogicCircuitOperator::getArgumentCount).max().orElse(1);
        }
    }
}

