/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;

public class BlueprintCraftingRecipe
extends MultiblockRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<BlueprintCraftingRecipe>> SERIALIZER;
    public static final SetRestrictedField<MultiblockRecipe.RecipeMultiplier> MULTIPLIERS;
    public static final CachedRecipeList<BlueprintCraftingRecipe> RECIPES;
    private static int reloadCountForCategories;
    private static Map<String, List<RecipeHolder<BlueprintCraftingRecipe>>> recipesByCategory;
    public static SetRestrictedField<ItemLike> blueprintItem;
    public final String blueprintCategory;
    public final TagOutput output;
    public final List<IngredientWithSize> inputs;

    public BlueprintCraftingRecipe(String blueprintCategory, TagOutput output, List<IngredientWithSize> inputs) {
        super(output, IERecipeTypes.BLUEPRINT, 180, 23040, MULTIPLIERS);
        this.blueprintCategory = blueprintCategory;
        this.output = output;
        this.inputs = inputs;
        this.setInputListWithSizes(Lists.newArrayList(this.inputs));
        this.outputList = new TagOutputList(output);
    }

    protected IERecipeSerializer<BlueprintCraftingRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public static ItemStack getTypedBlueprint(String type) {
        ItemStack stack = new ItemStack(blueprintItem.get());
        stack.set(IEApiDataComponents.BLUEPRINT_TYPE, (Object)type);
        return stack;
    }

    public boolean matchesRecipe(NonNullList<ItemStack> query) {
        return this.getMaxCrafted(query) > 0;
    }

    public int getMaxCrafted(NonNullList<ItemStack> query) {
        HashMap<ItemStack, Integer> queryAmount = new HashMap<ItemStack, Integer>();
        for (ItemStack q : query) {
            if (q.isEmpty()) continue;
            boolean inc = false;
            for (ItemStack key : queryAmount.keySet()) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)q, (ItemStack)key)) continue;
                queryAmount.put(key, (Integer)queryAmount.get(key) + q.getCount());
                inc = true;
            }
            if (inc) continue;
            queryAmount.put(q, q.getCount());
        }
        OptionalInt maxCrafted = OptionalInt.empty();
        for (IngredientWithSize ingr : this.inputs) {
            int maxCraftedWithIngredient = 0;
            int req = ingr.getCount();
            Iterator queryIt = queryAmount.entrySet().iterator();
            while (queryIt.hasNext()) {
                int taken;
                Map.Entry e = queryIt.next();
                ItemStack compStack = (ItemStack)e.getKey();
                if (!ingr.testIgnoringSize(compStack) || (taken = (Integer)e.getValue() / req) <= 0) continue;
                e.setValue((Integer)e.getValue() - taken * req);
                if ((Integer)e.getValue() <= 0) {
                    queryIt.remove();
                }
                maxCraftedWithIngredient += taken;
            }
            if (maxCraftedWithIngredient <= 0) {
                return 0;
            }
            if (maxCrafted.isPresent()) {
                maxCrafted = OptionalInt.of(Math.min(maxCrafted.getAsInt(), maxCraftedWithIngredient));
                continue;
            }
            maxCrafted = OptionalInt.of(maxCraftedWithIngredient);
        }
        return maxCrafted.orElse(0);
    }

    public NonNullList<ItemStack> consumeInputs(NonNullList<ItemStack> query, int crafted) {
        NonNullList consumed = NonNullList.create();
        block0: for (IngredientWithSize ingr : this.inputs) {
            int inputSize = ingr.getCount() * crafted;
            for (int i = 0; i < query.size(); ++i) {
                ItemStack queryStack = (ItemStack)query.get(i);
                if (queryStack.isEmpty() || !ingr.testIgnoringSize(queryStack)) continue;
                int taken = Math.min(queryStack.getCount(), inputSize);
                consumed.add((Object)queryStack.copyWithCount(taken));
                if (taken >= queryStack.getCount() && queryStack.getItem().hasCraftingRemainingItem(queryStack)) {
                    query.set(i, (Object)queryStack.getItem().getCraftingRemainingItem(queryStack));
                } else {
                    queryStack.shrink(taken);
                }
                if ((inputSize -= taken) <= 0) continue block0;
            }
        }
        return consumed;
    }

    public static List<RecipeHolder<BlueprintCraftingRecipe>> findRecipes(Level level, String blueprintCategory) {
        BlueprintCraftingRecipe.updateRecipeCategories(level);
        return recipesByCategory.getOrDefault(blueprintCategory, (List<RecipeHolder<BlueprintCraftingRecipe>>)ImmutableList.of()).stream().toList();
    }

    public static void updateRecipeCategories(Level level) {
        if (reloadCountForCategories == CachedRecipeList.getReloadCount()) {
            return;
        }
        recipesByCategory = RECIPES.getRecipes(level).stream().collect(Collectors.groupingBy(r -> ((BlueprintCraftingRecipe)r.value()).blueprintCategory));
        for (Map.Entry<String, List<RecipeHolder<BlueprintCraftingRecipe>>> e : recipesByCategory.entrySet()) {
            e.getValue().sort(Comparator.comparing(RecipeHolder::id));
        }
        reloadCountForCategories = CachedRecipeList.getReloadCount();
    }

    public static Set<String> getCategoriesWithRecipes(Level level) {
        BlueprintCraftingRecipe.updateRecipeCategories(level);
        return recipesByCategory.keySet();
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        MULTIPLIERS = SetRestrictedField.common();
        RECIPES = new CachedRecipeList<BlueprintCraftingRecipe>(IERecipeTypes.BLUEPRINT);
        reloadCountForCategories = -1;
        recipesByCategory = Collections.emptyMap();
        blueprintItem = SetRestrictedField.common();
    }
}

