/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.promoter.screen;

import dev.ftb.mods.promoter.api.InfoFetcher;
import dev.ftb.mods.promoter.api.PromoData;
import dev.ftb.mods.promoter.integrations.Integrations;
import dev.ftb.mods.promoter.screen.RemoteTexture;
import dev.ftb.mods.promoter.screen.ScreenInitEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class AdScreen
extends Screen {
    private final List<PromoDataHolder> promos = new ArrayList<PromoDataHolder>();
    private Screen parent;

    public AdScreen(Screen parent) {
        super((Component)Component.empty());
        this.parent = parent;
        for (PromoData promo : InfoFetcher.get().getPromotions()) {
            this.promos.add(new PromoDataHolder(promo));
        }
    }

    protected void init() {
        super.init();
        int middle = this.width / 2;
        int sectionOneLeft = middle - 154 - 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"X"), b -> this.onClose()).pos(sectionOneLeft + 308 - 18, 3).size(14, 14).build());
        int buttonWidth = 148;
        int horizontalShift = this.promos.size() == 1 ? middle - 77 : sectionOneLeft;
        for (PromoDataHolder promotion : this.promos) {
            Button.Builder button = Button.builder((Component)Component.literal((String)promotion.getData().buttonText()), b -> {
                boolean result = Integrations.clickAction(promotion.getData(), this);
                String url = promotion.getData().url();
                if (!result && url != null && !url.isEmpty()) {
                    Button.OnPress press = ConfirmLinkScreen.confirmLink((Screen)this, (URI)URI.create(url));
                    press.onPress(b);
                }
            }).pos(horizontalShift + 3, this.height - 30).width(buttonWidth);
            String buttonTooltip = promotion.data.buttonTooltip();
            if (buttonTooltip != null && !buttonTooltip.isEmpty()) {
                button.tooltip(Tooltip.create((Component)Component.literal((String)buttonTooltip)));
            }
            this.addRenderableWidget((GuiEventListener)button.build());
            horizontalShift += 156;
        }
    }

    public void onClose() {
        if (this.parent != null) {
            Minecraft.getInstance().setScreen(this.parent);
            return;
        }
        super.onClose();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        int availableWidth = AdScreen.getAvailableWidth(this.promos);
        int middle = this.width / 2;
        int horizontalShift = middle - 2 - availableWidth * this.promos.size() / 2;
        for (PromoDataHolder promotion : this.promos) {
            this.renderSectionBackground(promotion, guiGraphics, horizontalShift, availableWidth);
            horizontalShift += availableWidth + 2;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int availableWidth = AdScreen.getAvailableWidth(this.promos);
        int middle = this.width / 2 - 2;
        int horizontalShift = middle - availableWidth * this.promos.size() / 2;
        for (PromoDataHolder promotion : this.promos) {
            this.renderSection(promotion, guiGraphics, horizontalShift, availableWidth, mouseX, mouseY);
            horizontalShift += availableWidth + 2;
        }
    }

    private static int getAvailableWidth(List<PromoDataHolder> promos) {
        return promos.size() > 1 ? 154 : 308;
    }

    private void renderSection(PromoDataHolder holder, GuiGraphics guiGraphics, int x, int width, int mouseX, int mouseY) {
        PromoData data = holder.getData();
        guiGraphics.blit(holder.getLogo().getTextureLocation(), x + width / 2 - 15, 10, 0.0f, 0.0f, 30, 30, 30, 30);
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, data.name(), x + width / 2, 50, 0xFFFFFF);
        MultiLineLabel description = holder.getDescription();
        description.renderLeftAligned(guiGraphics, x + 8, 70, 10, 0xFFFFFF);
        String announcement = data.announcement();
        if (announcement != null && !announcement.isEmpty()) {
            ScreenInitEvent.renderAnnouncement(guiGraphics, x, this.height - 30, width, announcement, null, mouseX, mouseY);
        }
    }

    private void renderSectionBackground(PromoDataHolder holder, GuiGraphics guiGraphics, int x, int width) {
        guiGraphics.fill(x, 0, x + width, this.height, 0x9FFFFFF);
        guiGraphics.fill(x + 2, 0, x + width - 2, this.height, Integer.MIN_VALUE);
    }

    private static class PromoDataHolder {
        private final PromoData data;
        private final RemoteTexture logo;
        private final MultiLineLabel description;

        public PromoDataHolder(PromoData data) {
            this.data = data;
            this.logo = new RemoteTexture(URI.create(data.logo()), data.uuid().toString() + data.logoVersion(), Minecraft.getInstance().getTextureManager());
            this.description = MultiLineLabel.create((Font)Minecraft.getInstance().font, (Component)Component.literal((String)data.description()), (int)140);
        }

        public PromoData getData() {
            return this.data;
        }

        public RemoteTexture getLogo() {
            return this.logo;
        }

        public MultiLineLabel getDescription() {
            return this.description;
        }
    }
}

