/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.flopper.RegistryEntries;
import org.cyclops.flopper.block.BlockFlopper;
import org.cyclops.flopper.blockentity.BlockEntityFlopper;

public class GameTestsCommon {
    public static final String TEMPLATE_EMPTY = "flopper:empty10";
    public static final BlockPos POS = BlockPos.ZERO;

    @GameTest(template="flopper:empty10")
    public void testPlacementDirection(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_FLOPPER.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS, Direction.SOUTH);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_FLOPPER.value(), POS.south());
            helper.assertBlockProperty(POS.south(), (Property)BlockFlopper.FACING, (Comparable)Direction.NORTH);
        });
    }

    @GameTest(template="flopper:empty10")
    public void testPlacementDirectionDown(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_FLOPPER.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS, Direction.UP);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_FLOPPER.value(), POS.above());
            helper.assertBlockProperty(POS.above(), (Property)BlockFlopper.FACING, (Comparable)Direction.DOWN);
        });
    }

    @GameTest(template="flopper:empty10")
    public void testFillFromBucket(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_FLOPPER.value()).defaultBlockState().setValue((Property)BlockFlopper.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 1), Blocks.STONE.defaultBlockState());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)Items.WATER_BUCKET);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.useBlock(POS.offset(2, 2, 2), player);
        helper.succeedWhen(() -> {
            this.assertFlopperHasBucket(helper, POS.offset(2, 2, 2));
            this.assertItemIs(player.getItemInHand(InteractionHand.MAIN_HAND), new ItemStack((ItemLike)Items.BUCKET));
        });
    }

    @GameTest(template="flopper:empty10")
    public void testEmptyToBucket(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_FLOPPER.value()).defaultBlockState().setValue((Property)BlockFlopper.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 1), Blocks.STONE.defaultBlockState());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStackFill = new ItemStack((ItemLike)Items.WATER_BUCKET);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStackFill);
        helper.useBlock(POS.offset(2, 2, 2), player);
        ItemStack itemStackDrain = new ItemStack((ItemLike)Items.BUCKET);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStackDrain);
        player.setPose(Pose.CROUCHING);
        helper.useBlock(POS.offset(2, 2, 2), player);
        helper.succeedWhen(() -> {
            this.assertFlopperIsEmpty(helper, POS.offset(2, 2, 2));
            this.assertItemIs(player.getItemInHand(InteractionHand.MAIN_HAND), new ItemStack((ItemLike)Items.WATER_BUCKET));
        });
    }

    @GameTest(template="flopper:empty10")
    public void testFillFromWorld(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_FLOPPER.value()).defaultBlockState().setValue((Property)BlockFlopper.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 1), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(2, 3, 2), Blocks.WATER.defaultBlockState());
        helper.succeedWhen(() -> {
            this.assertFlopperHasBucket(helper, POS.offset(2, 2, 2));
            helper.assertBlockNotPresent(Blocks.WATER, POS.offset(2, 3, 2));
        });
    }

    @GameTest(template="flopper:empty10")
    public void testFillFromWorldLava(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_FLOPPER.value()).defaultBlockState().setValue((Property)BlockFlopper.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 1), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(2, 3, 2), Blocks.LAVA.defaultBlockState());
        helper.succeedWhen(() -> {
            this.assertFlopperHasBucket(helper, POS.offset(2, 2, 2));
            helper.assertBlockNotPresent(Blocks.LAVA, POS.offset(2, 3, 2));
        });
    }

    @GameTest(template="flopper:empty10")
    public void testEmptyToWorld(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_FLOPPER.value()).defaultBlockState().setValue((Property)BlockFlopper.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 3, 2), Blocks.WATER.defaultBlockState());
        helper.succeedWhen(() -> {
            helper.assertBlockPresent(Blocks.WATER, POS.offset(2, 2, 1));
            this.assertFlopperIsEmpty(helper, POS.offset(2, 2, 2));
            helper.assertBlockNotPresent(Blocks.WATER, POS.offset(2, 3, 2));
        });
    }

    @GameTest(template="flopper:empty10", timeoutTicks=1000)
    public void testFillFromFlopper(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_FLOPPER.value()).defaultBlockState().setValue((Property)BlockFlopper.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 3, 2), (BlockState)((Block)RegistryEntries.BLOCK_FLOPPER.value()).defaultBlockState().setValue((Property)BlockFlopper.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 1), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(2, 4, 2), Blocks.WATER.defaultBlockState());
        helper.succeedWhen(() -> {
            this.assertFlopperHasBucket(helper, POS.offset(2, 2, 2));
            helper.assertBlockNotPresent(Blocks.WATER, POS.offset(2, 4, 2));
        });
    }

    @GameTest(template="flopper:empty10", timeoutTicks=1000)
    public void testEmptyToFlopper(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_FLOPPER.value()).defaultBlockState().setValue((Property)BlockFlopper.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 1), (BlockState)((Block)RegistryEntries.BLOCK_FLOPPER.value()).defaultBlockState().setValue((Property)BlockFlopper.FACING, (Comparable)Direction.DOWN));
        helper.setBlock(POS.offset(2, 1, 1), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(2, 3, 2), Blocks.WATER.defaultBlockState());
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent(Blocks.WATER, POS.offset(2, 3, 2));
            this.assertFlopperIsEmpty(helper, POS.offset(2, 2, 2));
            this.assertFlopperHasBucket(helper, POS.offset(2, 2, 1));
        });
    }

    @GameTest(template="flopper:empty10")
    public void testFillFromInfiniteWaterPool(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_FLOPPER.value()).defaultBlockState().setValue((Property)BlockFlopper.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 1), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(2, 2, 1), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(2, 2, 3), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(2, 3, 0), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(2, 3, 1), Blocks.WATER.defaultBlockState());
        helper.setBlock(POS.offset(2, 3, 2), Blocks.WATER.defaultBlockState());
        helper.setBlock(POS.offset(2, 3, 3), Blocks.WATER.defaultBlockState());
        helper.setBlock(POS.offset(2, 3, 4), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(1, 3, 1), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(1, 3, 2), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(1, 3, 3), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(3, 3, 1), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(3, 3, 2), Blocks.STONE.defaultBlockState());
        helper.setBlock(POS.offset(3, 3, 3), Blocks.STONE.defaultBlockState());
        helper.succeedWhen(() -> {
            this.assertFlopperHasBucket(helper, POS.offset(2, 2, 2));
            helper.assertBlockNotPresent(Blocks.WATER, POS.offset(2, 3, 2));
        });
    }

    @GameTest(template="flopper:empty10")
    public void testFillFromWorldWaterLava(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_FLOPPER.value()).defaultBlockState().setValue((Property)BlockFlopper.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 1), Blocks.STONE.defaultBlockState());
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStackFill = new ItemStack((ItemLike)Items.LAVA_BUCKET);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStackFill);
        helper.useBlock(POS.offset(2, 2, 2), player);
        helper.setBlock(POS.offset(2, 3, 2), Blocks.WATER.defaultBlockState());
        helper.succeedWhen(() -> {
            this.assertFlopperHasBucket(helper, POS.offset(2, 2, 2));
            this.assertItemIs(player.getItemInHand(InteractionHand.MAIN_HAND), new ItemStack((ItemLike)Items.BUCKET));
            helper.assertBlockPresent(Blocks.WATER, POS.offset(2, 3, 2));
        });
    }

    protected void assertFlopperHasBucket(GameTestHelper helper, BlockPos pos) {
        helper.assertBlockEntityData(pos, BlockEntityFlopper::hasBucket, () -> "Flopper does not contain a bucket");
    }

    protected void assertFlopperIsEmpty(GameTestHelper helper, BlockPos pos) {
        helper.assertBlockEntityData(pos, blockEntity -> blockEntity.getFluidAmount() == 0, () -> "Flopper is not empty");
    }

    protected void assertItemIs(ItemStack stackExpected, ItemStack stackActual) {
        if (!ItemStack.isSameItemSameComponents((ItemStack)stackExpected, (ItemStack)stackActual)) {
            throw new GameTestAssertException("Expected item is not equal to actual. Expected: " + String.valueOf(stackExpected) + "; Actual: " + String.valueOf(stackActual));
        }
    }
}

