/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.cookingforblockheads.block.entity.IMutableNameable;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BaseKitchenBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty FLIPPED = BooleanProperty.create((String)"flipped");
    public static final BooleanProperty HAS_COLOR = BooleanProperty.create((String)"has_color");
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.create((String)"color", DyeColor.class);
    private static final VoxelShape BOUNDING_BOX_X = Block.box((double)0.5, (double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_Z = Block.box((double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0, (double)15.5);

    protected BaseKitchenBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X) {
            return BOUNDING_BOX_X;
        }
        return BOUNDING_BOX_Z;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        return state.hasProperty((Property)HAS_COLOR) ? (BlockState)state.setValue((Property)HAS_COLOR, (Comparable)Boolean.valueOf(false)) : state;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.cookingforblockheads.multiblock_kitchen").withStyle(ChatFormatting.YELLOW));
        this.appendHoverDescriptionText(itemStack, context, tooltip, flag);
    }

    protected void appendHoverDescriptionText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
    }

    public boolean shouldBePlacedFlipped(BlockPlaceContext context, Direction facing) {
        BlockPos pos = context.getClickedPos();
        Player placer = context.getPlayer();
        if (placer == null) {
            return Math.random() < 0.5;
        }
        double dir = 0.0;
        if (facing.getAxis() == Direction.Axis.Z) {
            dir = (double)((float)pos.getX() + 0.5f) - placer.getX();
            dir *= -1.0;
        } else if (facing.getAxis() == Direction.Axis.X) {
            dir = (double)((float)pos.getZ() + 0.5f) - placer.getZ();
        }
        boolean flipped = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? dir < 0.0 : dir > 0.0;
        return flipped;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BalmContainerProvider) {
            BalmContainerProvider containerProvider = (BalmContainerProvider)blockEntity;
            if (!state.is(newState.getBlock())) {
                containerProvider.dropItems(level, pos);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean tryRecolorBlock(BlockState state, ItemStack heldItem, Level level, BlockPos pos, Player player, BlockHitResult rayTraceResult) {
        if (heldItem.getItem() == Items.BONE_MEAL && this.removeColor(state, (LevelAccessor)level, pos, rayTraceResult.getDirection())) {
            if (!player.getAbilities().instabuild) {
                heldItem.shrink(1);
            }
            return true;
        }
        DyeColor color = Balm.getHooks().getColor(heldItem);
        if (color != null) {
            if (this.recolorBlock(state, (LevelAccessor)level, pos, rayTraceResult.getDirection(), color) && !player.getAbilities().instabuild) {
                heldItem.shrink(1);
            }
            return true;
        }
        return false;
    }

    protected BlockState getDyedStateOf(BlockState state, @Nullable DyeColor color) {
        if (state.hasProperty(COLOR) && state.hasProperty((Property)HAS_COLOR)) {
            if (color != null) {
                return (BlockState)((BlockState)state.setValue(COLOR, (Comparable)color)).setValue((Property)HAS_COLOR, (Comparable)Boolean.valueOf(true));
            }
            return (BlockState)state.setValue((Property)HAS_COLOR, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    private boolean removeColor(BlockState state, LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState removedColorState = this.getDyedStateOf(state, null);
        if (!removedColorState.equals(state)) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            Object transferData = null;
            if (blockEntity instanceof TransferableBlockEntity) {
                TransferableBlockEntity transferableBlockEntity = (TransferableBlockEntity)blockEntity;
                transferData = transferableBlockEntity.snapshotDataForTransfer();
            }
            world.setBlock(pos, removedColorState, 3);
            BlockEntity newBlockEntity = world.getBlockEntity(pos);
            if (transferData != null && newBlockEntity instanceof TransferableBlockEntity) {
                TransferableBlockEntity transferableBlockEntity = (TransferableBlockEntity)newBlockEntity;
                transferableBlockEntity.restoreFromTransferSnapshot(transferData);
            }
            return true;
        }
        return false;
    }

    protected boolean recolorBlock(BlockState state, LevelAccessor world, BlockPos pos, Direction facing, DyeColor color) {
        BlockState recoloredState = this.getDyedStateOf(state, color);
        if (!recoloredState.equals(state)) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            Object transferData = null;
            if (blockEntity instanceof TransferableBlockEntity) {
                TransferableBlockEntity transferableBlockEntity = (TransferableBlockEntity)blockEntity;
                transferData = transferableBlockEntity.snapshotDataForTransfer();
            }
            world.setBlock(pos, recoloredState, 3);
            BlockEntity newBlockEntity = world.getBlockEntity(pos);
            if (transferData != null && newBlockEntity instanceof TransferableBlockEntity) {
                TransferableBlockEntity transferableBlockEntity = (TransferableBlockEntity)newBlockEntity;
                transferableBlockEntity.restoreFromTransferSnapshot(transferData);
            }
            return true;
        }
        return false;
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity != null) {
            return tileEntity.triggerEvent(id, param);
        }
        return false;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.has(DataComponents.CUSTOM_NAME) && (blockEntity = level.getBlockEntity(pos)) instanceof IMutableNameable) {
            ((IMutableNameable)blockEntity).setCustomName(itemStack.getHoverName());
        }
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

