/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmRuntimeLoadContext;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.neoforge.NeoForgeLoadContext;
import net.blay09.mods.balm.neoforge.energy.NeoForgeEnergyStorage;
import net.blay09.mods.balm.neoforge.fluid.NeoForgeFluidTank;
import net.blay09.mods.balm.neoforge.provider.NeoForgeBalmProviders;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.ItemHandlerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProcessor;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.event.OvenItemSmeltedEvent;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.compat.TheOneProbeAddon;
import net.blay09.mods.cookingforblockheads.kitchen.ContainerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.tag.ModBlockTags;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.items.IItemHandler;

@Mod(value="cookingforblockheads")
public class NeoForgeCookingForBlockheads {
    private static final BlockCapability<KitchenItemProvider, Void> KITCHEN_ITEM_PROVIDER = BlockCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)"kitchen_item_provider"), KitchenItemProvider.class);
    private static final BlockCapability<KitchenItemProcessor, Void> KITCHEN_ITEM_PROCESSOR = BlockCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)"kitchen_item_processor"), KitchenItemProcessor.class);

    public NeoForgeCookingForBlockheads(IEventBus eventBus) {
        Balm.getEvents().onEvent(OvenItemSmeltedEvent.class, orig -> {
            PlayerEvent.ItemSmeltedEvent event = new PlayerEvent.ItemSmeltedEvent(orig.getPlayer(), orig.getResultItem());
            NeoForge.EVENT_BUS.post((Event)event);
        });
        NeoForgeLoadContext context = new NeoForgeLoadContext(eventBus);
        Balm.initialize((String)"cookingforblockheads", (BalmRuntimeLoadContext)context, CookingForBlockheads::initialize);
        eventBus.addListener(this::registerCapabilities);
        eventBus.addListener(this::enqueueIMC);
        NeoForgeBalmProviders providers = (NeoForgeBalmProviders)Balm.getProviders();
        providers.registerBlockProvider(KitchenItemProvider.class, KITCHEN_ITEM_PROVIDER);
        providers.registerBlockProvider(KitchenItemProcessor.class, KITCHEN_ITEM_PROCESSOR);
        providers.registerFallbackBlockProvider(KitchenItemProvider.class, (blockEntity, direction) -> {
            if (blockEntity.getBlockState().is(ModBlockTags.KITCHEN_ITEM_PROVIDERS)) {
                IItemHandler itemHandler;
                Level level = blockEntity.getLevel();
                if (blockEntity instanceof Container) {
                    Container container = (Container)blockEntity;
                    return new ContainerKitchenItemProvider(container);
                }
                if (blockEntity instanceof BalmContainerProvider) {
                    BalmContainerProvider containerProvider = (BalmContainerProvider)blockEntity;
                    return new ContainerKitchenItemProvider(containerProvider.getContainer());
                }
                if (level != null && (itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), null)) != null) {
                    return new ItemHandlerKitchenItemProvider(itemHandler);
                }
            }
            return null;
        });
        Balm.initializeIfLoaded((String)"solcarrot", (String)"net.blay09.mods.cookingforblockheads.compat.SpiceOfLifeAddon");
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (Balm.isModLoaded((String)"theoneprobe")) {
            TheOneProbeAddon.register();
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(KITCHEN_ITEM_PROVIDER, (BlockEntityType)ModBlockEntities.milkJar.get(), (blockEntity, context) -> (KitchenItemProvider)blockEntity.getProvider(KitchenItemProvider.class));
        event.registerBlockEntity(KITCHEN_ITEM_PROVIDER, (BlockEntityType)ModBlockEntities.cowJar.get(), (blockEntity, context) -> (KitchenItemProvider)blockEntity.getProvider(KitchenItemProvider.class));
        event.registerBlockEntity(KITCHEN_ITEM_PROVIDER, (BlockEntityType)ModBlockEntities.fridge.get(), (blockEntity, context) -> (KitchenItemProvider)blockEntity.getProvider(KitchenItemProvider.class));
        event.registerBlockEntity(KITCHEN_ITEM_PROVIDER, (BlockEntityType)ModBlockEntities.sink.get(), (blockEntity, context) -> (KitchenItemProvider)blockEntity.getProvider(KitchenItemProvider.class));
        event.registerBlockEntity(KITCHEN_ITEM_PROVIDER, (BlockEntityType)ModBlockEntities.fruitBasket.get(), (blockEntity, context) -> (KitchenItemProvider)blockEntity.getProvider(KitchenItemProvider.class));
        event.registerBlockEntity(KITCHEN_ITEM_PROVIDER, (BlockEntityType)ModBlockEntities.spiceRack.get(), (blockEntity, context) -> (KitchenItemProvider)blockEntity.getProvider(KitchenItemProvider.class));
        event.registerBlockEntity(KITCHEN_ITEM_PROVIDER, (BlockEntityType)ModBlockEntities.cabinet.get(), (blockEntity, context) -> (KitchenItemProvider)blockEntity.getProvider(KitchenItemProvider.class));
        event.registerBlockEntity(KITCHEN_ITEM_PROVIDER, (BlockEntityType)ModBlockEntities.counter.get(), (blockEntity, context) -> (KitchenItemProvider)blockEntity.getProvider(KitchenItemProvider.class));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntities.sink.get(), (blockEntity, context) -> new NeoForgeFluidTank(blockEntity.getFluidTank()));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntities.milkJar.get(), (blockEntity, context) -> new NeoForgeFluidTank(blockEntity.getFluidTank()));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntities.cowJar.get(), (blockEntity, context) -> new NeoForgeFluidTank(blockEntity.getFluidTank()));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntities.oven.get(), (blockEntity, context) -> new NeoForgeEnergyStorage(blockEntity.getEnergyStorage()));
        event.registerBlockEntity(KITCHEN_ITEM_PROVIDER, (BlockEntityType)ModBlockEntities.cuttingBoard.get(), (blockEntity, context) -> (KitchenItemProvider)blockEntity.getProvider(KitchenItemProvider.class));
        event.registerBlockEntity(KITCHEN_ITEM_PROCESSOR, (BlockEntityType)ModBlockEntities.oven.get(), (blockEntity, context) -> (KitchenItemProcessor)blockEntity.getProvider(KitchenItemProcessor.class));
    }
}

