/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.util;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalBlock;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.event.CPAEvent;
import net.kyrptonaught.customportalapi.event.CPASoundEventData;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.SHOULDTP;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class PortalLink {
    public ResourceLocation block;
    public PortalIgnitionSource portalIgnitionSource = PortalIgnitionSource.FIRE;
    private Supplier<CustomPortalBlock> portalBlock = CustomPortalsMod.portalBlock;
    public ResourceLocation dimID;
    public ResourceLocation returnDimID = ResourceLocation.withDefaultNamespace((String)"overworld");
    public boolean onlyIgnitableInReturnDim = false;
    public int colorID;
    public int forcedWidth;
    public int forcedHeight;
    public Integer portalSearchYBottom;
    public Integer portalSearchYTop;
    public Integer returnPortalSearchYBottom;
    public Integer returnPortalSearchYTop;
    public ResourceLocation portalFrameTester = CustomPortalsMod.VANILLAPORTAL_FRAMETESTER;
    private Consumer<Entity> postTPEvent;
    private final CPAEvent<Entity, SHOULDTP> beforeTPEvent = new CPAEvent(SHOULDTP.CONTINUE_TP);
    private final CPAEvent<Player, CPASoundEventData> inPortalAmbienceEvent = new CPAEvent();
    private final CPAEvent<Player, CPASoundEventData> postTpPortalAmbienceEvent = new CPAEvent();

    public PortalLink() {
    }

    public PortalLink(ResourceLocation blockID, ResourceLocation dimID, int colorID) {
        this.block = blockID;
        this.dimID = dimID;
        this.colorID = colorID;
    }

    public CustomPortalBlock getPortalBlock() {
        return this.portalBlock.get();
    }

    public void setPortalBlock(Supplier<CustomPortalBlock> block) {
        this.portalBlock = block;
    }

    public boolean doesIgnitionMatch(PortalIgnitionSource attemptedSource) {
        return this.portalIgnitionSource.sourceType == attemptedSource.sourceType && this.portalIgnitionSource.ignitionSourceID.equals((Object)attemptedSource.ignitionSourceID);
    }

    public boolean canLightInDim(ResourceLocation dim) {
        if (!this.onlyIgnitableInReturnDim) {
            return true;
        }
        return dim.equals((Object)this.returnDimID) || dim.equals((Object)this.dimID);
    }

    public CPAEvent<Entity, SHOULDTP> getBeforeTPEvent() {
        return this.beforeTPEvent;
    }

    public CPAEvent<Player, CPASoundEventData> getInPortalAmbienceEvent() {
        return this.inPortalAmbienceEvent;
    }

    public CPAEvent<Player, CPASoundEventData> getPostTpPortalAmbienceEvent() {
        return this.postTpPortalAmbienceEvent;
    }

    public void setPostTPEvent(Consumer<Entity> event) {
        this.postTPEvent = event;
    }

    public void executePostTPEvent(Entity entity) {
        if (this.postTPEvent != null) {
            this.postTPEvent.accept(entity);
        }
    }

    public PortalFrameTester.PortalFrameTesterFactory getFrameTester() {
        return CustomPortalApiRegistry.getPortalFrameTester(this.portalFrameTester);
    }
}

