/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal.linking;

import java.util.concurrent.ConcurrentHashMap;
import net.kyrptonaught.customportalapi.portal.linking.DimensionalBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class PortalLinkingStorage
extends SavedData {
    private final ConcurrentHashMap<ResourceLocation, ConcurrentHashMap<BlockPos, DimensionalBlockPos>> portalLinks = new ConcurrentHashMap();

    public static SavedData.Factory<PortalLinkingStorage> factory() {
        return new SavedData.Factory(PortalLinkingStorage::new, PortalLinkingStorage::fromNbt, DataFixTypes.LEVEL);
    }

    public static PortalLinkingStorage fromNbt(CompoundTag tag, HolderLookup.Provider provider) {
        PortalLinkingStorage cman = new PortalLinkingStorage();
        ListTag links = (ListTag)tag.get("portalLinks");
        for (int i = 0; i < links.size(); ++i) {
            CompoundTag link = links.getCompound(i);
            DimensionalBlockPos toTag = DimensionalBlockPos.fromTag(link.getCompound("to"));
            cman.addLink(BlockPos.of((long)link.getLong("fromPos")), ResourceLocation.parse((String)link.getString("fromDimID")), toTag.pos, toTag.dimensionType);
        }
        return cman;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag links = new ListTag();
        this.portalLinks.keys().asIterator().forEachRemaining(dimKey -> this.portalLinks.get(dimKey).forEach((blockPos, dimensionalBlockPos) -> {
            CompoundTag link = new CompoundTag();
            link.putString("fromDimID", dimKey.toString());
            link.putLong("fromPos", blockPos.asLong());
            link.put("to", (Tag)dimensionalBlockPos.toTag(new CompoundTag()));
            links.add((Object)link);
        }));
        tag.put("portalLinks", (Tag)links);
        return tag;
    }

    public DimensionalBlockPos getDestination(BlockPos portalFramePos, ResourceKey<Level> dimID) {
        if (this.portalLinks.containsKey(dimID.location())) {
            return this.portalLinks.get(dimID.location()).get(portalFramePos);
        }
        return null;
    }

    public void createLink(BlockPos portalFramePos, ResourceKey<Level> dimID, BlockPos destPortalFramePos, ResourceKey<Level> destDimID) {
        this.addLink(portalFramePos, dimID, destPortalFramePos, destDimID);
        this.addLink(destPortalFramePos, destDimID, portalFramePos, dimID);
    }

    private void addLink(BlockPos portalFramePos, ResourceLocation dimID, BlockPos destPortalFramePos, ResourceLocation destDimID) {
        if (!this.portalLinks.containsKey(dimID)) {
            this.portalLinks.put(dimID, new ConcurrentHashMap());
        }
        this.portalLinks.get(dimID).put(portalFramePos, new DimensionalBlockPos(destDimID, destPortalFramePos));
    }

    private void addLink(BlockPos portalFramePos, ResourceKey<Level> dimID, BlockPos destPortalFramePos, ResourceKey<Level> destDimID) {
        this.addLink(portalFramePos, dimID.location(), destPortalFramePos, destDimID.location());
    }

    public boolean isDirty() {
        return true;
    }
}

