/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal;

import java.util.HashSet;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class PortalIgnitionSource {
    public static final PortalIgnitionSource FIRE = new PortalIgnitionSource(SourceType.BLOCKPLACED, BuiltInRegistries.BLOCK.getKey((Object)Blocks.FIRE));
    public static final PortalIgnitionSource WATER = PortalIgnitionSource.FluidSource((Fluid)Fluids.WATER);
    private static final HashSet<Item> USEITEMS = new HashSet();
    public SourceType sourceType;
    public ResourceLocation ignitionSourceID;
    public Player player;

    private PortalIgnitionSource(SourceType sourceType, ResourceLocation ignitionSourceID) {
        this.sourceType = sourceType;
        this.ignitionSourceID = ignitionSourceID;
    }

    public PortalIgnitionSource withPlayer(Player player) {
        this.player = player;
        return this;
    }

    public static PortalIgnitionSource ItemUseSource(Item item) {
        USEITEMS.add(item);
        return new PortalIgnitionSource(SourceType.USEITEM, BuiltInRegistries.ITEM.getKey((Object)item));
    }

    public static PortalIgnitionSource FluidSource(Fluid fluid) {
        return new PortalIgnitionSource(SourceType.FLUID, BuiltInRegistries.FLUID.getKey((Object)fluid));
    }

    public static PortalIgnitionSource CustomSource(ResourceLocation ignitionSourceID) {
        return new PortalIgnitionSource(SourceType.CUSTOM, ignitionSourceID);
    }

    public static boolean isRegisteredIgnitionSourceWith(Item item) {
        return USEITEMS.contains(item);
    }

    @Deprecated
    public void withCondition(BiFunction<Level, BlockPos, Boolean> condition) {
    }

    public boolean isWater() {
        return Optional.ofNullable((Fluid)BuiltInRegistries.FLUID.get(this.ignitionSourceID)).filter(a -> a.is(FluidTags.WATER)).isPresent();
    }

    public boolean isLava() {
        return Optional.ofNullable((Fluid)BuiltInRegistries.FLUID.get(this.ignitionSourceID)).filter(a -> a.is(FluidTags.LAVA)).isPresent();
    }

    public static enum SourceType {
        USEITEM,
        BLOCKPLACED,
        FLUID,
        CUSTOM;

    }
}

