/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.stickit.common.util.bound;

import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Box {
    public static final Box BLOCK_BOX = new Box(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public final double minX;
    public final double minY;
    public final double minZ;
    public final double maxX;
    public final double maxY;
    public final double maxZ;

    public Box(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public Box(AABB aabb) {
        this(aabb.minX, aabb.minY, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ);
    }

    public AABB toAABB() {
        return new AABB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public VoxelShape toShape() {
        return Shapes.box((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    public Box copy() {
        return new Box(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public Box rotateX90() {
        return new Box(this.minX, 1.0 - this.maxZ, this.minY, this.maxX, 1.0 - this.minZ, this.maxY);
    }

    public Box rotateX180() {
        return new Box(this.minX, 1.0 - this.maxY, 1.0 - this.maxZ, this.maxX, 1.0 - this.minY, 1.0 - this.minZ);
    }

    public Box rotateX270() {
        return new Box(this.minX, this.minZ, 1.0 - this.maxY, this.maxX, this.maxZ, 1.0 - this.minY);
    }

    public Box rotateY90() {
        return new Box(this.minZ, this.minY, 1.0 - this.maxX, this.maxZ, this.maxY, 1.0 - this.minX);
    }

    public Box rotateY180() {
        return new Box(1.0 - this.maxX, this.minY, 1.0 - this.maxZ, 1.0 - this.minX, this.maxY, 1.0 - this.minZ);
    }

    public Box rotateY270() {
        return new Box(1.0 - this.maxZ, this.minY, this.minX, 1.0 - this.minZ, this.maxY, this.maxX);
    }

    public Box rotateZ90() {
        return new Box(1.0 - this.maxY, this.minX, this.minZ, 1.0 - this.minY, this.maxX, this.maxZ);
    }

    public Box rotateZ180() {
        return new Box(1.0 - this.maxX, 1.0 - this.maxY, this.minZ, 1.0 - this.minX, 1.0 - this.minY, this.maxZ);
    }

    public Box rotateZ270() {
        return new Box(this.minY, 1.0 - this.maxX, this.minZ, this.maxY, 1.0 - this.minX, this.maxZ);
    }

    public Box translate(double dx, double dy, double dz) {
        return new Box(this.minX + dx, this.minY + dy, this.minZ + dz, this.maxX + dx, this.maxY + dy, this.maxZ + dz);
    }

    public Box enclosing(Box o) {
        return new Box(Math.min(this.minX, o.minX), Math.min(this.minY, o.minY), Math.min(this.minZ, o.minZ), Math.max(this.maxX, o.maxX), Math.max(this.maxY, o.maxY), Math.max(this.maxZ, o.maxZ));
    }

    public boolean contains(Vec3 vec) {
        return this.contains(vec.x, vec.y, vec.z);
    }

    public boolean contains(double x, double y, double z) {
        return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY && this.minZ <= z && z <= this.minZ;
    }

    public double distanceSq(Vec3 vec) {
        return this.distanceSq(vec.x, vec.y, vec.z);
    }

    public double distanceSq(double x, double y, double z) {
        double dx = Math.max(0.0, Math.max(this.minX - x, x - this.maxX));
        double dy = Math.max(0.0, Math.max(this.minY - y, y - this.maxY));
        double dz = Math.max(0.0, Math.max(this.minZ - z, z - this.maxZ));
        return dx * dx + dy * dy + dz * dz;
    }
}

