/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.stickit.common.util;

import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class MatrixUtils {
    public static Matrix4f difference(Matrix4f a, Matrix4f b) {
        Matrix4f aInv = new Matrix4f((Matrix4fc)a);
        aInv.invert();
        Matrix4f D = new Matrix4f((Matrix4fc)aInv);
        D.mul((Matrix4fc)b);
        return D;
    }

    public static class TransformData {
        public final float tx;
        public final float ty;
        public final float tz;
        public final float sx;
        public final float sy;
        public final float sz;
        public final Matrix3f rot;
        public final double pitch;
        public final double yaw;
        public final double roll;

        public TransformData(Matrix4f mat) {
            mat = new Matrix4f((Matrix4fc)mat);
            this.tx = mat.m30();
            this.ty = mat.m31();
            this.tz = mat.m32();
            this.sx = this.length3f(mat.m00(), mat.m10(), mat.m20());
            this.sy = this.length3f(mat.m01(), mat.m11(), mat.m21());
            this.sz = this.length3f(mat.m02(), mat.m12(), mat.m22());
            this.rot = this.newMat3(mat.m00() / this.sx, mat.m01() / this.sy, mat.m02() / this.sz, mat.m10() / this.sx, mat.m11() / this.sy, mat.m12() / this.sz, mat.m20() / this.sx, mat.m21() / this.sy, mat.m22() / this.sz);
            this.yaw = Math.toDegrees(Math.atan2(this.rot.m02, this.rot.m22));
            this.pitch = Math.toDegrees(-Math.atan2(this.rot.m12, Math.sqrt(Math.pow(this.rot.m10, 2.0) + Math.pow(this.rot.m11, 2.0))));
            this.roll = Math.toDegrees(Math.atan2(this.rot.m10, this.rot.m11));
        }

        private float length3f(float x, float y, float z) {
            return (float)Math.sqrt(x * x + y * y + z * z);
        }

        private Matrix3f newMat3(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            Matrix3f m = new Matrix3f();
            m.m00 = m00;
            m.m01 = m01;
            m.m02 = m02;
            m.m10 = m10;
            m.m11 = m11;
            m.m12 = m12;
            m.m20 = m20;
            m.m21 = m21;
            m.m22 = m22;
            return m;
        }

        public String toString() {
            return String.format("tx=%.3f", Float.valueOf(this.tx)) + String.format(" ty=%.3f", Float.valueOf(this.ty)) + String.format(" tz=%.3f", Float.valueOf(this.tz)) + String.format(" sx=%.3f", Float.valueOf(this.sx)) + String.format(" sy=%.3f", Float.valueOf(this.sy)) + String.format(" sz=%.3f", Float.valueOf(this.sz)) + String.format(" pitch=%.3f", this.pitch) + String.format(" yaw=%.3f", this.yaw) + String.format(" roll=%.3f", this.roll);
        }
    }
}

