/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.stickit.common.util;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class EntityUtils {
    public static void setHeldItemSilent(Player player, InteractionHand hand, ItemStack stack) {
        if (hand == InteractionHand.MAIN_HAND) {
            EntityUtils.setItemStackToSlotSilent(player, EquipmentSlot.MAINHAND, stack);
        } else {
            if (hand != InteractionHand.OFF_HAND) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf(hand));
            }
            EntityUtils.setItemStackToSlotSilent(player, EquipmentSlot.OFFHAND, stack);
        }
    }

    public static void setItemStackToSlotSilent(Player player, EquipmentSlot slotIn, ItemStack stack) {
        stack.getItem().verifyComponentsAfterLoad(stack);
        if (slotIn == EquipmentSlot.MAINHAND) {
            player.getInventory().items.set(player.getInventory().selected, (Object)stack);
        } else if (slotIn == EquipmentSlot.OFFHAND) {
            player.getInventory().offhand.set(0, (Object)stack);
        } else if (slotIn.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
            player.getInventory().armor.set(slotIn.getIndex(), (Object)stack);
        }
    }
}

