/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.recipe.AbstractOneToOneRecipe;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.AbstractHeldRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IRecipeHolder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import it.zerono.mods.zerocore.lib.recipe.ingredient.ItemStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.FluidStackRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResultTarget;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidizerSolidRecipe
extends AbstractOneToOneRecipe<ItemStack, FluidStack, ItemStackRecipeIngredient, FluidStackRecipeResult>
implements IFluidizerRecipe {
    private static long s_maxResultAmount = 0L;

    public FluidizerSolidRecipe(ItemStackRecipeIngredient ingredient, FluidStackRecipeResult result) {
        super((IRecipeIngredient)ingredient, (IRecipeResult)result);
        s_maxResultAmount = Math.max(s_maxResultAmount, result.getAmount());
    }

    public static boolean lookup(ModRecipe recipe, IRecipeIngredientSource<ItemStack> source) {
        return recipe instanceof FluidizerSolidRecipe && ((FluidizerSolidRecipe)recipe).test((ItemStack)source.getIngredient());
    }

    public static long getMaxResultAmount() {
        return s_maxResultAmount;
    }

    @Override
    public IFluidizerRecipe.Type getRecipeType() {
        return IFluidizerRecipe.Type.Solid;
    }

    public boolean match(ItemStack stack) {
        return ((ItemStackRecipeIngredient)this.getIngredient()).test(stack);
    }

    public boolean matchIgnoreAmount(ItemStack stack) {
        return ((ItemStackRecipeIngredient)this.getIngredient()).testIgnoreAmount(stack);
    }

    public static RecipeSerializer<FluidizerSolidRecipe> createSerializer() {
        return AbstractOneToOneRecipe.createSerializer((String)"ingredient", (ModCodecs)ItemStackRecipeIngredient.CODECS, (String)"result", (ModCodecs)FluidStackRecipeResult.CODECS, FluidizerSolidRecipe::new);
    }

    @Override
    public int getEnergyUsageMultiplier() {
        return this.getEnergyUsageMultiplier(((FluidStackRecipeResult)this.getResult()).getResult());
    }

    public RecipeSerializer<FluidizerSolidRecipe> getSerializer() {
        return Content.Recipes.FLUIDIZER_SOLID_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)Content.Recipes.FLUIDIZER_RECIPE_TYPE.get();
    }

    public static class HeldRecipe
    extends AbstractHeldRecipe<FluidizerSolidRecipe>
    implements IFluidizerRecipe.Held<FluidizerSolidRecipe> {
        private final IRecipeIngredientSource<ItemStack> _itemSource;
        private final IRecipeResultTarget<FluidStackRecipeResult> _outputTarget;

        public <Holder extends IRecipeHolder<FluidizerSolidRecipe>> HeldRecipe(FluidizerSolidRecipe recipe, Holder holder, IRecipeIngredientSource<ItemStack> itemSource, IRecipeResultTarget<FluidStackRecipeResult> outputTarget) {
            super((ModRecipe)recipe, holder);
            this._itemSource = itemSource;
            this._outputTarget = outputTarget;
        }

        public void onRecipeProcessed() {
            FluidizerSolidRecipe recipe = (FluidizerSolidRecipe)this.getRecipe();
            ItemStack item = (ItemStack)this._itemSource.getMatchFrom(recipe.getIngredient());
            if (!item.isEmpty()) {
                this._itemSource.consumeIngredient((Object)item);
                this._outputTarget.setResult((IRecipeResult)((FluidStackRecipeResult)recipe.getResult()), OperationMode.Execute);
            }
        }
    }
}

