/*
 * Decompiled with CFR 0.152.
 */
package com.neuvillette.ae2ct.api;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.menu.me.crafting.CraftingPlanSummaryEntry;
import com.neuvillette.ae2ct.api.RecipeHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CraftingTreeHelper {
    private RecipeHelper recipeHelper;
    private List<CraftingPlanSummaryEntry> entries;
    private Map<AEKey, RecipeHelper.Recipe> cache = new HashMap<AEKey, RecipeHelper.Recipe>();
    private Map<AEKey, AmountHelper> amountCache = new HashMap<AEKey, AmountHelper>();
    private Map<Point, Node> nodesMap = new HashMap<Point, Node>();
    private int max_x = 0;
    private int max_y = 0;

    public CraftingTreeHelper(RecipeHelper recipeHelper, List<CraftingPlanSummaryEntry> entries) {
        this.recipeHelper = recipeHelper;
        this.entries = entries;
    }

    public NodeInfo buildNode() {
        if (this.recipeHelper == null) {
            return null;
        }
        this.cache.clear();
        this.nodesMap.clear();
        List<RecipeHelper.Recipe> recipes = this.recipeHelper.recipes;
        for (RecipeHelper.Recipe recipe : recipes) {
            AEKey output = recipe.outputs().getFirst().what();
            if (this.cache.containsKey(output)) continue;
            this.cache.put(output, recipe);
        }
        for (CraftingPlanSummaryEntry entry : this.entries) {
            AEKey key = entry.getWhat();
            if (this.amountCache.containsKey(key)) continue;
            this.amountCache.put(key, new AmountHelper(entry.getMissingAmount(), entry.getStoredAmount(), entry.getCraftAmount()));
        }
        GenericStack output = this.recipeHelper.output;
        long amount = output.amount();
        long outputamount = 0L;
        long times = 0L;
        List<GenericStack> inputs = new ArrayList<GenericStack>();
        for (Map.Entry<AEKey, RecipeHelper.Recipe> entry : this.cache.entrySet()) {
            AEKey k = entry.getKey();
            RecipeHelper.Recipe v = entry.getValue();
            if (!k.equals(output.what())) continue;
            outputamount = v.outputs().getFirst().amount();
            times = amount / outputamount;
            if (amount % outputamount != 0L) {
                ++times;
            }
            inputs = v.inputs();
            break;
        }
        this.max_x = 0;
        this.max_y = 0;
        Node node = this.build(output, amount, new Point(0, -1), inputs, times, 0, outputamount);
        return new NodeInfo(node, this.max_x + 1, this.max_y + 1);
    }

    private Node build(GenericStack stack, Long amount, Point position, List<GenericStack> inputs, long times, int len, long outputamount) {
        if (this.cache == null || this.cache.isEmpty() || this.amountCache == null || this.amountCache.isEmpty()) {
            return null;
        }
        int x = position.x + len;
        int y = position.y + 1;
        if (x > this.max_x) {
            this.max_x = x;
        }
        if (y > this.max_y) {
            this.max_y = y;
        }
        int l = 0;
        ArrayList<Node> nodes = new ArrayList<Node>();
        AmountHelper amoCache = this.amountCache.get(stack.what());
        if (amoCache == null) {
            amoCache = new AmountHelper(0L, Long.MAX_VALUE, Long.MAX_VALUE);
        }
        if (inputs.isEmpty()) {
            long storedAmo = AmountHelper.check(amount - amoCache.missingAmount);
            AmountHelper a = new AmountHelper(AmountHelper.check(amount - storedAmo), storedAmo, 0L);
            this.amountCache.put(stack.what(), new AmountHelper(AmountHelper.check(amoCache.missingAmount - amount), amoCache.storedAmount, amoCache.craftAmount));
            Node n = new Node(stack, amount, new Point(x, y), null, 1, a);
            this.nodesMap.put(n.position(), n);
            return n;
        }
        if (times == 0L) {
            AmountHelper a = new AmountHelper(0L, amount, 0L);
            this.amountCache.put(stack.what(), new AmountHelper(amoCache.missingAmount, AmountHelper.check(amoCache.storedAmount - amount), amoCache.craftAmount));
            Node n = new Node(stack, amount, new Point(x, y), null, 1, a);
            this.nodesMap.put(n.position(), n);
            return n;
        }
        for (GenericStack input : inputs) {
            long amo = input.amount() * times;
            long t = 0L;
            long a = 0L;
            List<GenericStack> ins = new ArrayList<GenericStack>();
            for (Map.Entry<AEKey, RecipeHelper.Recipe> entry : this.cache.entrySet()) {
                AEKey k = entry.getKey();
                RecipeHelper.Recipe v = entry.getValue();
                if (!k.equals(input.what())) continue;
                a = v.outputs().getFirst().amount();
                long needcraft = AmountHelper.check(amo - this.amountCache.get((Object)input.what()).storedAmount);
                t = needcraft / a;
                if (needcraft % a != 0L) {
                    ++t;
                }
                ins = v.inputs();
                break;
            }
            Node n = this.build(input, amo, new Point(x, y), ins, t, l, a);
            l = n.len() + l;
            nodes.add(n);
        }
        Node n = new Node(stack, amount, new Point(x, y), nodes, l, new AmountHelper(0L, AmountHelper.check(amount - times * outputamount), times * outputamount));
        this.nodesMap.put(n.position(), n);
        return n;
    }

    public Map<Point, Node> getNodesMap() {
        return this.nodesMap;
    }

    public static class AmountHelper {
        public long missingAmount;
        public long storedAmount;
        public long craftAmount;

        public AmountHelper(long missingAmount, long storedAmount, long craftAmount) {
            this.missingAmount = missingAmount;
            this.storedAmount = storedAmount;
            this.craftAmount = craftAmount;
        }

        public static long check(long a) {
            if (a < 0L) {
                return 0L;
            }
            return a;
        }
    }

    public record Node(GenericStack stack, Long amount, Point position, List<Node> subNodes, int len, AmountHelper amountHelper) {
    }

    public record NodeInfo(Node node, int max_x, int max_y) {
    }
}

