/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.part;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartStateEmpty;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.part.PartTypeTerminal;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStoragePart;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class PartTypeTerminalStorage
extends PartTypeTerminal<PartTypeTerminalStorage, State> {
    public PartTypeTerminalStorage(String name) {
        super(name);
    }

    public int getConsumptionRate(State state) {
        return GeneralConfig.terminalStorageBaseConsumption;
    }

    protected State constructDefaultState() {
        return new State();
    }

    public Optional<MenuProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)PartTypeTerminalStorage.this.getTranslationKey());
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                State state = (State)((IPartContainer)data.getLeft()).getPartState(((PartTarget)data.getRight()).getCenter().getSide());
                TerminalStorageState terminalStorageState = state.getPlayerStorageState(playerEntity);
                return new ContainerTerminalStoragePart(id, playerInventory, (PartTarget)data.getRight(), (PartTypeTerminalStorage)((Object)data.getMiddle()), Optional.empty(), terminalStorageState);
            }
        });
    }

    public void writeExtraGuiData(RegistryFriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
        PacketCodec.write((RegistryFriendlyByteBuf)packetBuffer, (Object)pos);
        super.writeExtraGuiData(packetBuffer, pos, player);
        packetBuffer.writeBoolean(false);
        State state = (State)PartHelpers.getPartContainerChecked((PartPos)pos).getPartState(pos.getSide());
        TerminalStorageState terminalStorageState = state.getPlayerStorageState((Player)player);
        terminalStorageState.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
    }

    public void addDrops(PartTarget target, State state, List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        for (Map.Entry<String, NonNullList<ItemStack>> entry : state.getNamedInventories().entrySet()) {
            if (entry.getKey().equals(TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString())) {
                entry.getValue().set(0, (Object)ItemStack.EMPTY);
            }
            for (ItemStack itemStack : entry.getValue()) {
                if (itemStack.isEmpty()) continue;
                itemStacks.add(itemStack);
            }
        }
        state.clearNamedInventories();
        super.addDrops(target, (IPartState)state, itemStacks, dropMainElement, saveState);
    }

    public static class State
    extends PartStateEmpty<PartTypeTerminalStorage>
    implements ITerminalStorageTabCommon.IVariableInventory {
        private final Map<String, NonNullList<ItemStack>> namedInventories = Maps.newHashMap();
        private final Map<String, TerminalStorageState> playerStorageStates = Maps.newHashMap();

        public int getUpdateInterval() {
            return 1;
        }

        public void clearNamedInventories() {
            this.namedInventories.clear();
        }

        @Override
        public void setNamedInventory(String name, NonNullList<ItemStack> inventory, HolderLookup.Provider holderLookupProvider) {
            this.namedInventories.put(name, inventory);
            this.onDirty();
        }

        public Map<String, NonNullList<ItemStack>> getNamedInventories() {
            return this.namedInventories;
        }

        @Override
        @Nullable
        public NonNullList<ItemStack> getNamedInventory(String name, HolderLookup.Provider holderLookupProvider) {
            return this.namedInventories.get(name);
        }

        public TerminalStorageState getPlayerStorageState(Player player) {
            TerminalStorageState state = this.playerStorageStates.get(player.getUUID().toString());
            if (state == null) {
                state = TerminalStorageState.getPlayerDefault(player, (IDirtyMarkListener)this);
                this.playerStorageStates.put(player.getUUID().toString(), state);
                this.onDirty();
            }
            return state;
        }

        public void writeToNBT(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) {
            super.writeToNBT(valueDeseralizationContext, tag);
            ListTag namedInventoriesList = new ListTag();
            for (Map.Entry<String, NonNullList<ItemStack>> entry : this.namedInventories.entrySet()) {
                CompoundTag listEntry = new CompoundTag();
                listEntry.putString("tabName", entry.getKey());
                listEntry.putInt("itemCount", entry.getValue().size());
                ContainerHelper.saveAllItems((CompoundTag)listEntry, entry.getValue(), (HolderLookup.Provider)valueDeseralizationContext.holderLookupProvider());
                namedInventoriesList.add((Object)listEntry);
            }
            tag.put("namedInventories", (Tag)namedInventoriesList);
            ListTag playerStorageStatesList = new ListTag();
            for (Map.Entry<String, TerminalStorageState> entry : this.playerStorageStates.entrySet()) {
                CompoundTag stateEntry = new CompoundTag();
                stateEntry.putString("player", entry.getKey());
                stateEntry.put("value", (Tag)entry.getValue().getTag());
                playerStorageStatesList.add((Object)stateEntry);
            }
            tag.put("playerStorageStates", (Tag)playerStorageStatesList);
        }

        public void readFromNBT(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) {
            super.readFromNBT(valueDeseralizationContext, tag);
            for (Tag listEntry : tag.getList("namedInventories", 10)) {
                NonNullList list = NonNullList.withSize((int)((CompoundTag)listEntry).getInt("itemCount"), (Object)ItemStack.EMPTY);
                String tabName = ((CompoundTag)listEntry).getString("tabName");
                ContainerHelper.loadAllItems((CompoundTag)((CompoundTag)listEntry), (NonNullList)list, (HolderLookup.Provider)valueDeseralizationContext.holderLookupProvider());
                this.namedInventories.put(tabName, (NonNullList<ItemStack>)list);
            }
            for (Tag listEntry : tag.getList("playerStorageStates", 10)) {
                String playerName = ((CompoundTag)listEntry).getString("player");
                TerminalStorageState state = new TerminalStorageState(((CompoundTag)listEntry).getCompound("value"), (IDirtyMarkListener)this);
                this.playerStorageStates.put(playerName, state);
            }
        }
    }
}

