/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageItem;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.item.ItemTerminalStoragePortable;

public class TerminalStorageIngredientItemOpenPacket
extends PacketCodec<TerminalStorageIngredientItemOpenPacket> {
    public static final CustomPacketPayload.Type<TerminalStorageIngredientItemOpenPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"terminal_storage_ingredient_item_open"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TerminalStorageIngredientItemOpenPacket> CODEC = TerminalStorageIngredientItemOpenPacket.getCodec(TerminalStorageIngredientItemOpenPacket::new);
    @CodecField
    private ItemLocation itemLocation;
    @CodecField
    private String tabName;
    @CodecField
    private int channel;

    public TerminalStorageIngredientItemOpenPacket() {
        super(ID);
    }

    public TerminalStorageIngredientItemOpenPacket(ItemLocation itemLocation, String tabName, int channel) {
        super(ID);
        this.itemLocation = itemLocation;
        this.tabName = tabName;
        this.channel = channel;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        TerminalStorageIngredientItemOpenPacket.openServer(world, this.itemLocation, player, this.tabName, this.channel);
    }

    public static void openServer(Level world, final ItemLocation itemLocation, ServerPlayer player, String tabName, int channel) {
        final ContainerTerminalStorageBase.InitTabData initData = new ContainerTerminalStorageBase.InitTabData(tabName, channel);
        final TerminalStorageState terminalStorageState = ItemTerminalStoragePortable.getTerminalStorageState(itemLocation.getItemStack((Player)player), (Player)player, itemLocation);
        MenuProvider containerProvider = new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"");
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                return new ContainerTerminalStorageItem(id, playerInventory, itemLocation, Optional.of(initData), terminalStorageState);
            }
        };
        player.openMenu(containerProvider, packetBuffer -> {
            ItemLocation.writeToPacketBuffer((FriendlyByteBuf)packetBuffer, (ItemLocation)itemLocation);
            packetBuffer.writeBoolean(true);
            initData.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
            terminalStorageState.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
        });
    }

    public static void send(ItemLocation itemLocation, String tabName, int channel) {
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemOpenPacket(itemLocation, tabName, channel));
    }
}

