/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.Iceberg;
import com.anthonyhilyard.iceberg.events.client.RegisterTooltipComponentFactoryEvent;
import com.anthonyhilyard.iceberg.events.client.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.util.StringRecomposer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;

public class Tooltips {
    public static final TooltipColors DEFAULT_COLORS = new TooltipColors(TextColor.fromRgb((int)-267386864), TextColor.fromRgb((int)-267386864), TextColor.fromRgb((int)0x505000FF), TextColor.fromRgb((int)1344798847));
    private static final FormattedCharSequence SPACE = FormattedCharSequence.forward((String)" ", (Style)Style.EMPTY);
    private static ItemRenderer itemRenderer = null;
    private static boolean tooltipWidthWarningShown = false;
    public static TooltipColors currentColors = DEFAULT_COLORS;

    public static int calculateTitleLines(List<ClientTooltipComponent> components) {
        if (components == null || components.isEmpty()) {
            return 0;
        }
        int titleLines = 0;
        boolean foundTitleBreak = false;
        for (ClientTooltipComponent component : components) {
            if (component instanceof ClientTextTooltip) {
                ++titleLines;
                continue;
            }
            if (!(component instanceof TitleBreakComponent)) continue;
            foundTitleBreak = true;
            break;
        }
        if (!foundTitleBreak) {
            titleLines = 1;
        }
        return titleLines;
    }

    public static void renderItemTooltip(@NotNull ItemStack stack, TooltipInfo info, Rect2i rect, int screenWidth, int screenHeight, int backgroundColorStart, int backgroundColorEnd, int borderColorStart, int borderColorEnd, GuiGraphics graphics, ClientTooltipPositioner positioner, boolean comparison, boolean constrain, boolean centeredTitle, int index) {
        int componentNumber;
        if (info.getComponents().isEmpty()) {
            return;
        }
        if (itemRenderer == null) {
            itemRenderer = Minecraft.getInstance().getItemRenderer();
        }
        if (centeredTitle) {
            info = new TooltipInfo(Tooltips.centerTitle(info.getComponents(), info.getFont(), info.getMaxLineWidth(), info.getTitleLines()), info.getFont(), info.getTitleLines());
        }
        int rectX = rect.getX() + 4;
        int rectY = rect.getY() + 4;
        RenderTooltipEvents.PreExtResult preResult = RenderTooltipEvents.PREEXT.invoker().onPre(stack, graphics, rectX, rectY, screenWidth, screenHeight, info.getFont(), info.getComponents(), positioner, comparison, index);
        if (preResult.result() != InteractionResult.PASS) {
            return;
        }
        rectX = preResult.x();
        rectY = preResult.y();
        screenWidth = preResult.screenWidth();
        screenHeight = preResult.screenHeight();
        info.setFont(preResult.font());
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        int zLevel = 400;
        RenderTooltipEvents.ColorExtResult colors = RenderTooltipEvents.COLOREXT.invoker().onColor(stack, graphics, rectX, rectY, info.getFont(), backgroundColorStart, backgroundColorEnd, borderColorStart, borderColorEnd, info.getComponents(), comparison, index);
        backgroundColorStart = colors.backgroundStart();
        backgroundColorEnd = colors.backgroundEnd();
        borderColorStart = colors.borderStart();
        borderColorEnd = colors.borderEnd();
        currentColors = new TooltipColors(TextColor.fromRgb((int)backgroundColorStart), TextColor.fromRgb((int)backgroundColorEnd), TextColor.fromRgb((int)borderColorStart), TextColor.fromRgb((int)borderColorEnd));
        int finalRectX = rectX;
        int finalRectY = rectY;
        graphics.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)finalRectX, (int)finalRectY, (int)rect.getWidth(), (int)rect.getHeight(), (int)400));
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        poseStack.translate(0.0f, 0.0f, 400.0f);
        int tooltipTop = rectY;
        int titleLines = info.getTitleLines();
        for (componentNumber = 0; componentNumber < info.getComponents().size(); ++componentNumber) {
            ClientTooltipComponent textComponent = info.getComponents().get(componentNumber);
            textComponent.renderText(preResult.font(), rectX, tooltipTop, poseStack.last().pose(), bufferSource);
            tooltipTop += textComponent.getHeight();
            if (!(textComponent instanceof ClientTextTooltip) && !(textComponent instanceof InlineComponent) || titleLines <= 0 || (titleLines -= textComponent instanceof InlineComponent ? 2 : 1) > 0) continue;
            tooltipTop += 2;
        }
        tooltipTop = rectY;
        for (componentNumber = 0; componentNumber < info.getComponents().size(); ++componentNumber) {
            ClientTooltipComponent imageComponent = info.getComponents().get(componentNumber);
            imageComponent.renderImage(info.getFont(), rectX, tooltipTop, graphics);
            tooltipTop += imageComponent.getHeight() + (componentNumber == 0 ? 2 : 0);
        }
        poseStack.popPose();
        RenderTooltipEvents.POSTEXT.invoker().onPost(stack, graphics, rectX, rectY, info.getFont(), rect.getWidth(), rect.getHeight(), info.getComponents(), comparison, index);
    }

    private static ClientTooltipComponent getClientComponent(TooltipComponent componentData) {
        ClientTooltipComponent result = null;
        try {
            result = ClientTooltipComponent.create((TooltipComponent)componentData);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (result == null) {
            result = ((RegisterTooltipComponentFactoryEvent)RegisterTooltipComponentFactoryEvent.EVENT.invoker()).getComponent(componentData);
        }
        if (result == null) {
            try {
                result = (ClientTooltipComponent)componentData;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Unknown TooltipComponent");
        }
        return result;
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(ItemStack stack, List<? extends FormattedText> textElements, Optional<TooltipComponent> itemComponent, int mouseX, int screenWidth, int screenHeight, Font forcedFont, Font fallbackFont, int maxWidth) {
        return Tooltips.gatherTooltipComponents(stack, textElements, itemComponent, mouseX, screenWidth, screenHeight, forcedFont, fallbackFont, maxWidth, 0);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(ItemStack stack, List<? extends FormattedText> textElements, Optional<TooltipComponent> itemComponent, int mouseX, int screenWidth, int screenHeight, Font forcedFont, Font fallbackFont, int maxWidth, int index) {
        Font font = forcedFont == null ? fallbackFont : forcedFont;
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        RenderTooltipEvents.GatherResult eventResult = RenderTooltipEvents.GATHER.invoker().onGather(stack, screenWidth, screenHeight, elements, maxWidth, index);
        if (eventResult.result() != InteractionResult.PASS) {
            return List.of();
        }
        int tooltipTextWidth = eventResult.tooltipElements().stream().mapToInt(either -> (Integer)either.map(component -> {
            try {
                return font.width(component);
            }
            catch (Exception e) {
                if (!tooltipWidthWarningShown) {
                    Iceberg.LOGGER.error("Error rendering tooltip component: \n" + ExceptionUtils.getStackTrace((Throwable)e));
                    tooltipWidthWarningShown = true;
                }
                return 0;
            }
        }, component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (eventResult.maxWidth() > 0 && tooltipTextWidth > eventResult.maxWidth()) {
            tooltipTextWidth = eventResult.maxWidth();
            needsWrap = true;
        }
        int tooltipTextWidthFinal = tooltipTextWidth;
        if (needsWrap) {
            return eventResult.tooltipElements().stream().flatMap(either -> (Stream)either.map(text -> font.split(text, tooltipTextWidthFinal).stream().map(ClientTooltipComponent::create), component -> Stream.of(Tooltips.getClientComponent(component)))).toList();
        }
        return eventResult.tooltipElements().stream().map(either -> (ClientTooltipComponent)either.map(text -> ClientTooltipComponent.create((FormattedCharSequence)(text instanceof Component ? ((Component)text).getVisualOrderText() : Language.getInstance().getVisualOrder(text))), Tooltips::getClientComponent)).toList();
    }

    @Deprecated
    public static Rect2i calculateRect(ItemStack stack, PoseStack poseStack, List<ClientTooltipComponent> components, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, Font font) {
        return Tooltips.calculateRect(stack, poseStack, components, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font, 0, false);
    }

    @Deprecated
    public static Rect2i calculateRect(ItemStack stack, PoseStack poseStack, List<ClientTooltipComponent> components, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, Font font, int minWidth, boolean centeredTitle) {
        Minecraft minecraft = Minecraft.getInstance();
        GuiGraphics graphics = new GuiGraphics(minecraft, poseStack, minecraft.renderBuffers().bufferSource());
        return Tooltips.calculateRect(stack, graphics, DefaultTooltipPositioner.INSTANCE, components, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font, minWidth, centeredTitle);
    }

    public static Rect2i calculateRect(ItemStack stack, GuiGraphics graphics, ClientTooltipPositioner positioner, List<ClientTooltipComponent> components, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, Font font, int minWidth, boolean centeredTitle) {
        int componentWidth;
        Rect2i rect = new Rect2i(0, 0, 0, 0);
        if (components == null || components.isEmpty() || stack == null) {
            return rect;
        }
        RenderTooltipEvents.PreExtResult preResult = RenderTooltipEvents.PREEXT.invoker().onPre(stack, graphics, mouseX, mouseY, screenWidth, screenHeight, font, components, positioner, false, 0);
        if (preResult.result() != InteractionResult.PASS) {
            return rect;
        }
        mouseX = preResult.x();
        mouseY = preResult.y();
        screenWidth = preResult.screenWidth();
        screenHeight = preResult.screenHeight();
        font = preResult.font();
        int tooltipTextWidth = minWidth;
        int tooltipHeight = components.size() == 1 ? -2 : 0;
        int titleLines = Tooltips.calculateTitleLines(components);
        if (centeredTitle) {
            for (ClientTooltipComponent component : components) {
                componentWidth = component.getWidth(font);
                if (componentWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = componentWidth;
            }
            components = Tooltips.centerTitle(components, font, tooltipTextWidth, titleLines);
        }
        tooltipTextWidth = minWidth;
        for (ClientTooltipComponent component : components) {
            componentWidth = component.getWidth(font);
            if (componentWidth > tooltipTextWidth) {
                tooltipTextWidth = componentWidth;
            }
            tooltipHeight += component.getHeight();
        }
        int tooltipX = mouseX + 12;
        int tooltipY = mouseY - 12;
        if (tooltipX + tooltipTextWidth > screenWidth) {
            tooltipX -= 28 + tooltipTextWidth;
        }
        if (tooltipY + tooltipHeight + 6 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 6;
        }
        rect = new Rect2i(tooltipX - 2, tooltipY - 4, tooltipTextWidth, tooltipHeight);
        return rect;
    }

    public static List<ClientTooltipComponent> centerTitle(List<ClientTooltipComponent> components, Font font, int width) {
        return Tooltips.centerTitle(components, font, width, Tooltips.calculateTitleLines(components));
    }

    public static List<ClientTooltipComponent> centerTitle(List<ClientTooltipComponent> components, Font font, int width, int titleLines) {
        ArrayList<ClientTooltipComponent> result = new ArrayList<ClientTooltipComponent>(components);
        if (components.isEmpty() || titleLines <= 0 || titleLines >= components.size()) {
            return result;
        }
        int titleStart = 0;
        for (ClientTooltipComponent clientTooltipComponent : components) {
            if (clientTooltipComponent instanceof ClientTextTooltip) break;
            ++titleStart;
        }
        if (titleStart >= components.size()) {
            return result;
        }
        for (int i = 0; i < titleLines; ++i) {
            ClientTooltipComponent titleComponent = components.get(titleStart + i);
            if (titleComponent == null) continue;
            List<FormattedText> recomposedLines = StringRecomposer.recompose(List.of(titleComponent));
            if (recomposedLines.isEmpty()) {
                return components;
            }
            FormattedCharSequence title = Language.getInstance().getVisualOrder(recomposedLines.get(0));
            while (ClientTooltipComponent.create((FormattedCharSequence)title).getWidth(font) < width && (title = FormattedCharSequence.fromList(List.of(SPACE, title, SPACE))) != null) {
            }
            result.set(titleStart + i, ClientTooltipComponent.create((FormattedCharSequence)title));
        }
        return result;
    }

    public static class TitleBreakComponent
    implements TooltipComponent,
    ClientTooltipComponent {
        public int getHeight() {
            return 0;
        }

        public int getWidth(Font font) {
            return 0;
        }

        public static void registerFactory() {
            RegisterTooltipComponentFactoryEvent.EVENT.register(TitleBreakComponent.class, data -> {
                if (data instanceof TitleBreakComponent) {
                    TitleBreakComponent titleBreakComponent = (TitleBreakComponent)data;
                    return titleBreakComponent;
                }
                return null;
            });
        }
    }

    public static class TooltipInfo {
        private int tooltipWidth = 0;
        private int titleLines = 1;
        private Font font;
        private List<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>();

        public TooltipInfo(List<ClientTooltipComponent> components, Font font) {
            this(components, font, Tooltips.calculateTitleLines(components));
        }

        public TooltipInfo(List<ClientTooltipComponent> components, Font font, int titleLines) {
            this.components = components;
            this.font = font;
            this.titleLines = titleLines;
            this.tooltipWidth = this.getMaxLineWidth();
        }

        public int getTooltipWidth() {
            return this.tooltipWidth;
        }

        public int getTooltipHeight() {
            return this.components.size() > this.titleLines ? this.components.size() * 10 + 2 : 8;
        }

        public int getTitleLines() {
            return this.titleLines;
        }

        public Font getFont() {
            return this.font;
        }

        public List<ClientTooltipComponent> getComponents() {
            return this.components;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public int getMaxLineWidth() {
            return this.getMaxLineWidth(0);
        }

        public int getMaxLineWidth(int minWidth) {
            int textWidth = minWidth;
            for (ClientTooltipComponent component : this.components) {
                int componentWidth = component.getWidth(this.font);
                if (componentWidth <= textWidth) continue;
                textWidth = componentWidth;
            }
            return textWidth;
        }
    }

    public record TooltipColors(TextColor backgroundColorStart, TextColor backgroundColorEnd, TextColor borderColorStart, TextColor borderColorEnd) {
    }

    public static interface InlineComponent {
    }
}

