/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.mixin;

import com.anthonyhilyard.iceberg.Iceberg;
import com.anthonyhilyard.iceberg.services.Services;
import com.anthonyhilyard.iceberg.util.ITooltipAccess;
import java.lang.reflect.Field;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={GuiGraphics.class})
public class GuiGraphicsMixin
implements ITooltipAccess {
    @Unique
    private static Field tooltipStackField = null;

    @Override
    public void setIcebergTooltipStack(ItemStack stack) {
        if (tooltipStackField == null) {
            try {
                switch (Services.getPlatformHelper().getPlatformName()) {
                    case "Fabric": {
                        tooltipStackField = GuiGraphics.class.getDeclaredField("icebergTooltipStack");
                    }
                }
                tooltipStackField = GuiGraphics.class.getDeclaredField("tooltipStack");
                tooltipStackField.setAccessible(true);
            }
            catch (Exception e) {
                Iceberg.LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        try {
            tooltipStackField.set(this, stack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ItemStack getIcebergTooltipStack() {
        if (tooltipStackField == null) {
            try {
                switch (Services.getPlatformHelper().getPlatformName()) {
                    case "Fabric": {
                        tooltipStackField = GuiGraphics.class.getDeclaredField("icebergTooltipStack");
                    }
                }
                tooltipStackField = GuiGraphics.class.getDeclaredField("tooltipStack");
                tooltipStackField.setAccessible(true);
            }
            catch (Exception e) {
                Iceberg.LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        try {
            return (ItemStack)tooltipStackField.get(this);
        }
        catch (Exception exception) {
            return ItemStack.EMPTY;
        }
    }
}

