/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item.component;

import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.buuz135.functionalstorage.item.component.FunctionalUpgradeBehavior;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public record MoveItemsBehavior(boolean drawerIsSource, int itemsPerOperation) implements FunctionalUpgradeBehavior
{
    public static final MapCodec<MoveItemsBehavior> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)Codec.BOOL.fieldOf("drawer_is_source").forGetter(MoveItemsBehavior::drawerIsSource), (App)Codec.INT.fieldOf("items_per_operation").forGetter(MoveItemsBehavior::itemsPerOperation)).apply((Applicative)in, MoveItemsBehavior::new));

    @Override
    public void work(Level level, BlockPos pos, ControllableDrawerTile<?> dr, ItemStack upgradeStack, int upgradeSlot) {
        if (!(dr instanceof ItemControllableDrawerTile)) {
            return;
        }
        ItemControllableDrawerTile drawer = (ItemControllableDrawerTile)dr;
        Direction direction = UpgradeItem.getDirection(upgradeStack);
        IItemHandler otherHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos.relative(direction), (Object)direction.getOpposite());
        if (otherHandler != null) {
            IItemHandler source = this.drawerIsSource ? drawer.getStorage() : otherHandler;
            IItemHandler destination = this.drawerIsSource ? otherHandler : drawer.getStorage();
            for (int sourceSlot = 0; sourceSlot < source.getSlots(); ++sourceSlot) {
                ItemStack pulledStack = source.extractItem(sourceSlot, this.itemsPerOperation, true);
                if (pulledStack.isEmpty()) continue;
                for (int destinationSlot = 0; destinationSlot < destination.getSlots(); ++destinationSlot) {
                    ItemStack simulated;
                    if (destination.getStackInSlot(destinationSlot).getCount() >= destination.getSlotLimit(destinationSlot) || (simulated = destination.insertItem(destinationSlot, pulledStack, true)).getCount() > pulledStack.getCount()) continue;
                    destination.insertItem(destinationSlot, source.extractItem(sourceSlot, pulledStack.getCount() - simulated.getCount(), false), false);
                    return;
                }
            }
        }
    }

    @Override
    public MapCodec<? extends FunctionalUpgradeBehavior> codec() {
        return CODEC;
    }
}

