/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.Drawer;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.FramedBlock;
import com.buuz135.functionalstorage.block.tile.FluidDrawerTile;
import com.buuz135.functionalstorage.client.item.FluidDrawerISTER;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.util.NumberUtils;
import com.buuz135.functionalstorage.util.Utils;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidDrawerBlock
extends Drawer<FluidDrawerTile> {
    private final FunctionalStorage.DrawerType type;

    public FluidDrawerBlock(FunctionalStorage.DrawerType type, BlockBehaviour.Properties properties) {
        super("fluid_" + type.getSlots(), properties, FluidDrawerTile.class);
        this.type = type;
        this.setItemGroup(FunctionalStorage.TAB);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)RotatableBlock.FACING_HORIZONTAL, (Comparable)Direction.NORTH)).setValue((Property)DrawerBlock.LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    private static List<VoxelShape> getShapes(BlockState state, BlockGetter source, BlockPos pos, FunctionalStorage.DrawerType type) {
        ArrayList<VoxelShape> boxes = new ArrayList<VoxelShape>();
        DrawerBlock.CACHED_SHAPES.get((Object)type).get((Object)((Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL))).forEach(boxes::add);
        VoxelShape total = Shapes.block();
        boxes.add(total);
        return boxes;
    }

    public BlockEntityType.BlockEntitySupplier<FluidDrawerTile> getTileEntityFactory() {
        return (blockPos, state) -> {
            BlockEntityType entityType = (BlockEntityType)FunctionalStorage.FLUID_DRAWER_1.type().get();
            if (this.type == FunctionalStorage.DrawerType.X_2) {
                entityType = (BlockEntityType)FunctionalStorage.FLUID_DRAWER_2.type().get();
            }
            if (this.type == FunctionalStorage.DrawerType.X_4) {
                entityType = (BlockEntityType)FunctionalStorage.FLUID_DRAWER_4.type().get();
            }
            return new FluidDrawerTile((BasicTileBlock<FluidDrawerTile>)this, (BlockEntityType<FluidDrawerTile>)entityType, blockPos, state, this.type);
        };
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return FluidDrawerBlock.getShapes(state, source, pos, this.type);
    }

    @Override
    public Collection<VoxelShape> getHitShapes(BlockState state) {
        return DrawerBlock.CACHED_SHAPES.get((Object)this.type).get((Object)((Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL)));
    }

    public void registerRecipe(RecipeOutput consumer) {
        if (this.type == FunctionalStorage.DrawerType.X_1) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("PPP").pattern("PCP").pattern("PPP").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('C'), (ItemLike)Items.BUCKET).save(consumer);
        }
        if (this.type == FunctionalStorage.DrawerType.X_2) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)2).pattern("PCP").pattern("PPP").pattern("PCP").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('C'), (ItemLike)Items.BUCKET).save(consumer);
        }
        if (this.type == FunctionalStorage.DrawerType.X_4) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)4).pattern("CPC").pattern("PPP").pattern("CPC").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('C'), (ItemLike)Items.BUCKET).save(consumer);
        }
    }

    public FunctionalStorage.DrawerType getType() {
        return this.type;
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (itemStack.has(FSAttachments.TILE)) {
            CompoundTag tileTag = ((CompoundTag)itemStack.get(FSAttachments.TILE)).getCompound("fluidHandler");
            tooltip.add((Component)Component.translatable((String)"drawer.block.contents").withStyle(ChatFormatting.GRAY));
            for (int i = 0; i < this.type.getSlots(); ++i) {
                FluidStack stack = (FluidStack)((Pair)FluidStack.OPTIONAL_CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)Utils.registryAccess()), (Object)tileTag.getCompound("" + i).getCompound("Fluid")).getOrThrow()).getFirst();
                if (stack.isEmpty()) continue;
                tooltip.add((Component)Component.literal((String)(" - " + String.valueOf(ChatFormatting.YELLOW) + NumberUtils.getFormatedFluidBigNumber(stack.getAmount()) + String.valueOf(ChatFormatting.WHITE) + " of ")).append((Component)stack.getHoverName().copy().withStyle(ChatFormatting.GOLD)));
            }
            CompoundTag tile = (CompoundTag)itemStack.get(FSAttachments.TILE);
            tooltip.add((Component)Component.translatable((String)"drawer.block.upgrades").withStyle(ChatFormatting.GRAY));
            boolean anyupgrade = false;
            if (tile.contains("isCreative") && tile.getBoolean("isCreative")) {
                tooltip.add((Component)Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"drawer.block.upgrades.is_creative").withStyle(ChatFormatting.LIGHT_PURPLE)));
                anyupgrade = true;
            }
            if (tile.contains("isVoid") && tile.getBoolean("isVoid")) {
                tooltip.add((Component)Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"drawer.block.upgrades.is_void").withStyle(ChatFormatting.BLUE)));
                anyupgrade = true;
            }
            if (!anyupgrade) {
                tooltip.add((Component)Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"drawer.block.upgrades.none").withStyle(ChatFormatting.GRAY)));
            }
        }
        if (this instanceof FramedBlock) {
            tooltip.add((Component)Component.translatable((String)"frameddrawer.use").withStyle(ChatFormatting.GRAY));
        }
    }

    public static class FluidDrawerItem
    extends BlockItem {
        private final FluidDrawerBlock drawerBlock;

        public FluidDrawerItem(FluidDrawerBlock block, Item.Properties props, TitaniumTab tab) {
            super((Block)block, props);
            this.drawerBlock = block;
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return switch (drawerBlock.getType()) {
                        case FunctionalStorage.DrawerType.X_2 -> FluidDrawerISTER.SLOT_2;
                        case FunctionalStorage.DrawerType.X_4 -> FluidDrawerISTER.SLOT_4;
                        default -> FluidDrawerISTER.SLOT_1;
                    };
                }
            });
        }
    }
}

