/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.FramedBlock;
import com.buuz135.functionalstorage.block.FramedDrawerBlock;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.FramedTile;
import com.buuz135.functionalstorage.block.tile.StorageControllerTile;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.item.component.FunctionalUpgradeBehavior;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Drawer<T extends ControllableDrawerTile<T>>
extends RotatableBlock<T> {
    public Drawer(String name, BlockBehaviour.Properties properties, Class<T> tileClass) {
        super(name, properties, tileClass);
    }

    @javax.annotation.Nullable
    public ControllableDrawerTile<?> getBlockEntityAt(BlockGetter level, BlockPos pos) {
        return TileUtil.getTileEntity((BlockGetter)level, (BlockPos)pos, ControllableDrawerTile.class).orElse(null);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> def) {
        super.createBlockStateDefinition(def);
        def.add(new Property[]{DrawerBlock.LOCKED});
    }

    @NotNull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    @Nonnull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public boolean hasCustomBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return true;
    }

    public boolean hasIndividualRenderVoxelShape() {
        return true;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ControllableDrawerTile<?> entity = this.getBlockEntityAt((BlockGetter)worldIn, pos);
        if (entity != null) {
            InteractionResult result = entity.onSlotActivated(player, hand, ray.getDirection(), ray.getLocation().x, ray.getLocation().y, ray.getLocation().z, this.getHit(state, worldIn, player));
            if (result == InteractionResult.SUCCESS) {
                return ItemInteractionResult.SUCCESS;
            }
            if (result.consumesAction()) {
                return ItemInteractionResult.CONSUME;
            }
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult ray) {
        ControllableDrawerTile<?> entity = this.getBlockEntityAt((BlockGetter)worldIn, pos);
        if (entity != null) {
            return entity.onSlotActivated(player, InteractionHand.MAIN_HAND, ray.getDirection(), ray.getLocation().x, ray.getLocation().y, ray.getLocation().z, this.getHit(state, worldIn, player));
        }
        return InteractionResult.PASS;
    }

    public List<ItemStack> getDrops(BlockState p_60537_, LootParams.Builder builder) {
        NonNullList stacks = NonNullList.create();
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity drawerTile = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (drawerTile instanceof ControllableDrawerTile) {
            ControllableDrawerTile tile = (ControllableDrawerTile)drawerTile;
            this.copyTo(tile, stack);
        }
        stacks.add((Object)stack);
        return stacks;
    }

    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        return blockLootTables.droppingNothing();
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        return NonNullList.create();
    }

    protected void copyTo(T tile, ItemStack stack) {
        FramedTile framedDrawerTile;
        if (!((ControllableDrawerTile)((Object)tile)).isEverythingEmpty()) {
            CompoundTag compound = NBTManager.getInstance().writeTileEntity(tile, new CompoundTag());
            compound.put("storageUpgrades", (Tag)((ControllableDrawerTile)((Object)tile)).getStorageUpgrades().serializeNBT((HolderLookup.Provider)tile.getLevel().registryAccess()));
            stack.set(FSAttachments.TILE, (Object)compound);
        }
        if (((ControllableDrawerTile)((Object)tile)).isLocked()) {
            stack.set(FSAttachments.LOCKED, (Object)((ControllableDrawerTile)((Object)tile)).isLocked());
        }
        if (tile instanceof FramedTile && (framedDrawerTile = (FramedTile)tile).getFramedDrawerModelData() != null) {
            stack.set(FSAttachments.STYLE, (Object)framedDrawerTile.getFramedDrawerModelData().serializeNBT((HolderLookup.Provider)tile.getLevel().registryAccess()));
        }
    }

    protected void copyFrom(ItemStack stack, T tile) {
        ((ControllableDrawerTile)((Object)tile)).setLocked((Boolean)stack.getOrDefault(FSAttachments.LOCKED, (Object)false));
        if (stack.has(FSAttachments.TILE)) {
            ((ControllableDrawerTile)((Object)tile)).loadAdditional((CompoundTag)stack.get(FSAttachments.TILE), (HolderLookup.Provider)tile.getLevel().registryAccess());
            tile.markForUpdate();
        }
        if (stack.has(FSAttachments.STYLE) && tile instanceof FramedTile) {
            FramedTile framed = (FramedTile)tile;
            framed.setFramedDrawerModelData(FramedDrawerBlock.getDrawerModelData(stack));
        }
    }

    protected void configure(LivingEntity player, T tile) {
        ItemStack offhand = player.getOffhandItem();
        if (offhand.is((Item)FunctionalStorage.CONFIGURATION_TOOL.get())) {
            ConfigurationToolItem.ConfigurationAction action = ConfigurationToolItem.getAction(offhand);
            if (action == ConfigurationToolItem.ConfigurationAction.LOCKING) {
                ((ControllableDrawerTile)((Object)tile)).setLocked(true);
            } else if (action.getMax() == 1) {
                ((ControllableDrawerTile)((Object)tile)).getDrawerOptions().setActive(action, false);
            } else {
                ((ControllableDrawerTile)((Object)tile)).getDrawerOptions().setAdvancedValue(action, 1);
            }
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState p_49849_, @Nullable LivingEntity player, ItemStack stack) {
        super.setPlacedBy(level, pos, p_49849_, player, stack);
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof ControllableDrawerTile) {
            ControllableDrawerTile tile = (ControllableDrawerTile)entity;
            this.copyFrom(stack, tile);
            if (player != null) {
                this.configure(player, tile);
            }
        }
    }

    public boolean isSignalSource(BlockState p_60571_) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        ControllableDrawerTile tile = TileUtil.getTileEntity((BlockGetter)level, (BlockPos)pos, ControllableDrawerTile.class).orElse(null);
        if (tile != null) {
            for (int i = 0; i < tile.getUtilityUpgrades().getSlots(); ++i) {
                ItemStack stack = tile.getUtilityUpgrades().getStackInSlot(i);
                FunctionalUpgradeBehavior comp = (FunctionalUpgradeBehavior)stack.get(FSAttachments.FUNCTIONAL_BEHAVIOR);
                if (comp == null || !comp.canConnectRedstone(tile.getLevel(), pos, state, tile, direction, stack, i)) continue;
                return true;
            }
        }
        return false;
    }

    public int getSignal(BlockState state, BlockGetter blockGetter, BlockPos blockPos, Direction dir) {
        ControllableDrawerTile tile = TileUtil.getTileEntity((BlockGetter)blockGetter, (BlockPos)blockPos, ControllableDrawerTile.class).orElse(null);
        if (tile != null) {
            for (int i = 0; i < tile.getUtilityUpgrades().getSlots(); ++i) {
                int signal;
                ItemStack stack = tile.getUtilityUpgrades().getStackInSlot(i);
                FunctionalUpgradeBehavior comp = (FunctionalUpgradeBehavior)stack.get(FSAttachments.FUNCTIONAL_BEHAVIOR);
                if (comp == null || (signal = comp.getRedstoneSignal(tile.getLevel(), blockPos, state, tile, dir, stack, i)) < 0) continue;
                return signal;
            }
        }
        return 0;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (stack.has(FSAttachments.TILE)) {
            MutableComponent text = Component.translatable((String)"drawer.block.contents");
            tooltipComponents.add((Component)text.withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.literal((String)""));
            CompoundTag tile = (CompoundTag)stack.get(FSAttachments.TILE);
            tooltipComponents.add((Component)Component.translatable((String)"drawer.block.upgrades").withStyle(ChatFormatting.GRAY));
            boolean anyupgrade = false;
            if (tile.contains("isCreative") && tile.getBoolean("isCreative")) {
                tooltipComponents.add((Component)Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"drawer.block.upgrades.is_creative").withStyle(ChatFormatting.LIGHT_PURPLE)));
                anyupgrade = true;
            }
            if (tile.contains("isVoid") && tile.getBoolean("isVoid")) {
                tooltipComponents.add((Component)Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"drawer.block.upgrades.is_void").withStyle(ChatFormatting.BLUE)));
                anyupgrade = true;
            }
            if (!anyupgrade) {
                tooltipComponents.add((Component)Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"drawer.block.upgrades.none").withStyle(ChatFormatting.GRAY)));
            }
        }
        if (this instanceof FramedBlock) {
            tooltipComponents.add((Component)Component.translatable((String)"frameddrawer.use").withStyle(ChatFormatting.GRAY));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        FramedTile framedDrawerTile;
        BlockEntity entity = level.getBlockEntity(pos);
        ItemStack stack = new ItemStack((ItemLike)this);
        if (entity instanceof FramedTile && (framedDrawerTile = (FramedTile)entity).getFramedDrawerModelData() != null && !framedDrawerTile.getFramedDrawerModelData().getDesign().isEmpty()) {
            stack.set(FSAttachments.STYLE, (Object)framedDrawerTile.getFramedDrawerModelData().serializeNBT((HolderLookup.Provider)level.registryAccess()));
            return stack;
        }
        if (entity instanceof ControllableDrawerTile) {
            ControllableDrawerTile tile = (ControllableDrawerTile)entity;
            this.copyTo(tile, stack);
        }
        return stack;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, ControllableDrawerTile.class).ifPresent(tile -> {
                if (tile.getControllerPos() != null) {
                    TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)tile.getControllerPos(), StorageControllerTile.class).ifPresent(drawerControllerTile -> drawerControllerTile.addConnectedDrawers(LinkingToolItem.ActionMode.REMOVE, pos));
                }
            });
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public abstract Collection<VoxelShape> getHitShapes(BlockState var1);

    public int getHit(BlockState state, Level worldIn, Player player) {
        VoxelShape hit;
        HitResult result = RayTraceUtils.rayTraceSimple((Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f);
        if (result instanceof BlockHitResult && (hit = RayTraceUtils.rayTraceVoxelShape((BlockHitResult)((BlockHitResult)result), (Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f)) != null) {
            if (hit.equals(Shapes.block())) {
                return -1;
            }
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>(this.getHitShapes(state));
            for (int i = 0; i < shapes.size(); ++i) {
                if (!Shapes.joinIsNotEmpty((VoxelShape)((VoxelShape)shapes.get(i)), (VoxelShape)hit, (BooleanOp)BooleanOp.AND)) continue;
                return i;
            }
        }
        return -1;
    }
}

