/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage;

import com.buuz135.functionalstorage.block.ArmoryCabinetBlock;
import com.buuz135.functionalstorage.block.CompactingDrawerBlock;
import com.buuz135.functionalstorage.block.CompactingFramedDrawerBlock;
import com.buuz135.functionalstorage.block.ControllerExtensionBlock;
import com.buuz135.functionalstorage.block.Drawer;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.DrawerControllerBlock;
import com.buuz135.functionalstorage.block.EnderDrawerBlock;
import com.buuz135.functionalstorage.block.FluidDrawerBlock;
import com.buuz135.functionalstorage.block.FramedBlock;
import com.buuz135.functionalstorage.block.FramedControllerExtensionBlock;
import com.buuz135.functionalstorage.block.FramedDrawerBlock;
import com.buuz135.functionalstorage.block.FramedDrawerControllerBlock;
import com.buuz135.functionalstorage.block.FramedFluidDrawerBlock;
import com.buuz135.functionalstorage.block.FramedSimpleCompactingDrawerBlock;
import com.buuz135.functionalstorage.block.SimpleCompactingDrawerBlock;
import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.CompactingFramedDrawerTile;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.FluidDrawerTile;
import com.buuz135.functionalstorage.block.tile.FramedDrawerTile;
import com.buuz135.functionalstorage.block.tile.FramedFluidDrawerTile;
import com.buuz135.functionalstorage.block.tile.FramedSimpleCompactingDrawerTile;
import com.buuz135.functionalstorage.block.tile.SimpleCompactingDrawerTile;
import com.buuz135.functionalstorage.client.ClientSetup;
import com.buuz135.functionalstorage.client.CompactingDrawerRenderer;
import com.buuz135.functionalstorage.client.ControllerRenderer;
import com.buuz135.functionalstorage.client.DrawerRenderer;
import com.buuz135.functionalstorage.client.EnderDrawerRenderer;
import com.buuz135.functionalstorage.client.FluidDrawerRenderer;
import com.buuz135.functionalstorage.client.SimpleCompactingDrawerRenderer;
import com.buuz135.functionalstorage.client.loader.FramedModel;
import com.buuz135.functionalstorage.data.FunctionalStorageBlockTagsProvider;
import com.buuz135.functionalstorage.data.FunctionalStorageBlockstateProvider;
import com.buuz135.functionalstorage.data.FunctionalStorageItemTagsProvider;
import com.buuz135.functionalstorage.data.FunctionalStorageLangProvider;
import com.buuz135.functionalstorage.data.FunctionalStorageRecipesProvider;
import com.buuz135.functionalstorage.inventory.BigInventoryHandler;
import com.buuz135.functionalstorage.inventory.item.CompactingStackItemHandler;
import com.buuz135.functionalstorage.inventory.item.DrawerStackItemHandler;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.item.FSItem;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.buuz135.functionalstorage.item.component.AndBehavior;
import com.buuz135.functionalstorage.item.component.CollectFluidsBehavior;
import com.buuz135.functionalstorage.item.component.CollectItemEntitiesBehavior;
import com.buuz135.functionalstorage.item.component.DelegateToItemBehavior;
import com.buuz135.functionalstorage.item.component.EmitRedstoneBehavior;
import com.buuz135.functionalstorage.item.component.ExecuteEveryBehavior;
import com.buuz135.functionalstorage.item.component.FunctionalUpgradeBehavior;
import com.buuz135.functionalstorage.item.component.GenerateFluidBehavior;
import com.buuz135.functionalstorage.item.component.GenerateItemBehavior;
import com.buuz135.functionalstorage.item.component.MoveFluidsBehavior;
import com.buuz135.functionalstorage.item.component.MoveItemsBehavior;
import com.buuz135.functionalstorage.network.EnderDrawerSyncMessage;
import com.buuz135.functionalstorage.recipe.CopyComponentsRecipe;
import com.buuz135.functionalstorage.recipe.CustomCompactingRecipe;
import com.buuz135.functionalstorage.recipe.DrawerlessWoodIngredient;
import com.buuz135.functionalstorage.recipe.FramedDrawerRecipe;
import com.buuz135.functionalstorage.util.DrawerWoodType;
import com.buuz135.functionalstorage.util.IWoodType;
import com.buuz135.functionalstorage.util.NumberUtils;
import com.buuz135.functionalstorage.util.TooltipUtil;
import com.buuz135.functionalstorage.util.Utils;
import com.hrznstudio.titanium.datagenerator.loot.TitaniumLootTableProvider;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.BlockWithTile;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.recipe.serializer.GenericSerializer;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Mod(value="functionalstorage")
public class FunctionalStorage
extends ModuleController {
    public static final String MOD_ID = "functionalstorage";
    public static NetworkHandler NETWORK = new NetworkHandler("functionalstorage");
    private static final Logger LOGGER;
    public static ConcurrentLinkedQueue<IWoodType> WOOD_TYPES;
    public static HashMap<DrawerType, List<BlockWithTile>> DRAWER_TYPES;
    public static List<Block> FRAMED_BLOCKS;
    public static BlockWithTile COMPACTING_DRAWER;
    public static BlockWithTile DRAWER_CONTROLLER;
    public static BlockWithTile ARMORY_CABINET;
    public static BlockWithTile ENDER_DRAWER;
    public static BlockWithTile FRAMED_COMPACTING_DRAWER;
    public static BlockWithTile FLUID_DRAWER_1;
    public static BlockWithTile FLUID_DRAWER_2;
    public static BlockWithTile FLUID_DRAWER_4;
    public static BlockWithTile CONTROLLER_EXTENSION;
    public static BlockWithTile SIMPLE_COMPACTING_DRAWER;
    public static BlockWithTile FRAMED_DRAWER_CONTROLLER;
    public static BlockWithTile FRAMED_CONTROLLER_EXTENSION;
    public static BlockWithTile FRAMED_SIMPLE_COMPACTING_DRAWER;
    public static BlockWithTile FRAMED_FLUID_DRAWER_1;
    public static BlockWithTile FRAMED_FLUID_DRAWER_2;
    public static BlockWithTile FRAMED_FLUID_DRAWER_4;
    public static DeferredHolder<Item, Item> LINKING_TOOL;
    public static HashMap<StorageUpgradeItem.StorageTier, DeferredHolder<Item, Item>> STORAGE_UPGRADES;
    public static DeferredHolder<Item, Item> COLLECTOR_UPGRADE;
    public static DeferredHolder<Item, Item> PULLING_UPGRADE;
    public static DeferredHolder<Item, Item> PUSHING_UPGRADE;
    public static DeferredHolder<Item, Item> VOID_UPGRADE;
    public static DeferredHolder<Item, Item> CONFIGURATION_TOOL;
    public static DeferredHolder<Item, Item> REDSTONE_UPGRADE;
    public static DeferredHolder<Item, Item> CREATIVE_UPGRADE;
    public static DeferredHolder<Item, Item> OBSIDIAN_UPGRADE;
    public static DeferredHolder<Item, Item> DRIPPING_UPGRADE;
    public static DeferredHolder<Item, Item> WATER_GENERATOR_UPGRADE;
    public static TitaniumTab TAB;
    public static Holder<RecipeSerializer<?>> CUSTOM_COMPACTING_RECIPE_SERIALIZER;
    public static Holder<RecipeType<?>> CUSTOM_COMPACTING_RECIPE_TYPE;
    public static Holder<RecipeSerializer<?>> FRAMED_RECIPE_SERIALIZER;
    public static Holder<RecipeSerializer<?>> COPY_COMPONENTS_SERIALIZER;
    public static Holder<RecipeType<?>> FRAMED_RECIPE_TYPE;

    public FunctionalStorage(Dist dist, IEventBus modBus, ModContainer container) {
        super(container);
        NeoForgeMod.enableMilkFluid();
        FSAttachments.DR.register(modBus);
        if (dist.isClient()) {
            Runnable runnable = this::onClient;
            runnable.run();
        }
        NBTManager.getInstance().scanTileClassForAnnotations(FramedFluidDrawerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(FramedDrawerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(CompactingFramedDrawerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(FluidDrawerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(SimpleCompactingDrawerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(FramedSimpleCompactingDrawerTile.class);
        EventManager.forge(PlayerInteractEvent.LeftClickBlock.class).process(event -> {
            ControllableDrawerTile<?> be;
            Drawer drawer;
            int hit;
            BlockState state = event.getLevel().getBlockState(event.getPos());
            Block patt0$temp = event.getLevel().getBlockState(event.getPos()).getBlock();
            if (patt0$temp instanceof Drawer && (hit = (drawer = (Drawer)patt0$temp).getHit(state, event.getLevel(), event.getEntity())) != -1 && (be = drawer.getBlockEntityAt((BlockGetter)event.getLevel(), event.getPos())) != null) {
                be.onClicked(event.getEntity(), hit);
                event.setCanceled(true);
            }
        }).subscribe();
        modBus.addListener(event -> {
            event.registerItem(Capabilities.ItemHandler.ITEM, (object, context) -> {
                Item patt0$temp = object.getItem();
                if (patt0$temp instanceof DrawerBlock.DrawerItem) {
                    DrawerBlock.DrawerItem di = (DrawerBlock.DrawerItem)patt0$temp;
                    return di.initCapabilities((ItemStack)object);
                }
                return null;
            }, (ItemLike[])DRAWER_TYPES.values().stream().flatMap(Collection::stream).map(bl -> (ItemLike)bl.block().get()).toArray(ItemLike[]::new));
            event.registerItem(Capabilities.ItemHandler.ITEM, (object, context) -> {
                Item patt0$temp = object.getItem();
                if (patt0$temp instanceof CompactingDrawerBlock.CompactingDrawerItem) {
                    CompactingDrawerBlock.CompactingDrawerItem di = (CompactingDrawerBlock.CompactingDrawerItem)patt0$temp;
                    return di.initCapabilities((ItemStack)object);
                }
                return null;
            }, new ItemLike[]{COMPACTING_DRAWER.asItem(), SIMPLE_COMPACTING_DRAWER.asItem(), FRAMED_COMPACTING_DRAWER.asItem(), FRAMED_SIMPLE_COMPACTING_DRAWER.asItem()});
        });
        modBus.addListener(event -> event.register(FunctionalUpgradeBehavior.REGISTRY));
    }

    protected void initModules() {
        WOOD_TYPES.addAll(List.of(DrawerWoodType.values()));
        for (DrawerType drawerType2 : DrawerType.values()) {
            for (IWoodType woodType : WOOD_TYPES) {
                String name = woodType.getName() + "_" + drawerType2.getSlots();
                LOGGER.debug("Registering drawer {}", (Object)name);
                if (woodType == DrawerWoodType.FRAMED) {
                    BlockWithTile pair = this.getRegistries().registerBlockWithTileItem(name, () -> new FramedDrawerBlock(drawerType2), blockRegistryObject -> () -> new DrawerBlock.DrawerItem((DrawerBlock)((Object)((Object)((Object)((Object)blockRegistryObject.get())))), new Item.Properties(), TAB), TAB);
                    DRAWER_TYPES.computeIfAbsent(drawerType2, drawerType -> new ArrayList()).add(pair);
                    continue;
                }
                DRAWER_TYPES.computeIfAbsent(drawerType2, drawerType -> new ArrayList()).add(this.getRegistries().registerBlockWithTileItem(name, () -> new DrawerBlock(woodType, drawerType2, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)woodType.getPlanks())), blockRegistryObject -> () -> new DrawerBlock.DrawerItem((DrawerBlock)((Object)((Object)((Object)((Object)blockRegistryObject.get())))), new Item.Properties(), TAB), TAB));
            }
        }
        FLUID_DRAWER_1 = this.getRegistries().registerBlockWithTileItem("fluid_1", () -> new FluidDrawerBlock(DrawerType.X_1, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)), blockRegistryObject -> () -> new FluidDrawerBlock.FluidDrawerItem((FluidDrawerBlock)((Object)((Object)((Object)((Object)blockRegistryObject.get())))), new Item.Properties(), TAB), TAB);
        FLUID_DRAWER_2 = this.getRegistries().registerBlockWithTileItem("fluid_2", () -> new FluidDrawerBlock(DrawerType.X_2, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)), blockRegistryObject -> () -> new FluidDrawerBlock.FluidDrawerItem((FluidDrawerBlock)((Object)((Object)((Object)((Object)blockRegistryObject.get())))), new Item.Properties(), TAB), TAB);
        FLUID_DRAWER_4 = this.getRegistries().registerBlockWithTileItem("fluid_4", () -> new FluidDrawerBlock(DrawerType.X_4, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)), blockRegistryObject -> () -> new FluidDrawerBlock.FluidDrawerItem((FluidDrawerBlock)((Object)((Object)((Object)((Object)blockRegistryObject.get())))), new Item.Properties(), TAB), TAB);
        FRAMED_FLUID_DRAWER_1 = this.getRegistries().registerBlockWithTileItem("framed_fluid_1", () -> new FramedFluidDrawerBlock(DrawerType.X_1, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)), blockRegistryObject -> () -> new FluidDrawerBlock.FluidDrawerItem((FluidDrawerBlock)((Object)((Object)((Object)((Object)blockRegistryObject.get())))), new Item.Properties(), TAB), TAB);
        FRAMED_FLUID_DRAWER_2 = this.getRegistries().registerBlockWithTileItem("framed_fluid_2", () -> new FramedFluidDrawerBlock(DrawerType.X_2, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)), blockRegistryObject -> () -> new FluidDrawerBlock.FluidDrawerItem((FluidDrawerBlock)((Object)((Object)((Object)((Object)blockRegistryObject.get())))), new Item.Properties(), TAB), TAB);
        FRAMED_FLUID_DRAWER_4 = this.getRegistries().registerBlockWithTileItem("framed_fluid_4", () -> new FramedFluidDrawerBlock(DrawerType.X_4, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)), blockRegistryObject -> () -> new FluidDrawerBlock.FluidDrawerItem((FluidDrawerBlock)((Object)((Object)((Object)((Object)blockRegistryObject.get())))), new Item.Properties(), TAB), TAB);
        COMPACTING_DRAWER = this.getRegistries().registerBlockWithTileItem("compacting_drawer", () -> new CompactingDrawerBlock("compacting_drawer", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)), blockRegistryObject -> () -> new CompactingDrawerBlock.CompactingDrawerItem((Block)blockRegistryObject.get(), new Item.Properties(), 3), TAB);
        FRAMED_COMPACTING_DRAWER = this.getRegistries().registerBlockWithTileItem("compacting_framed_drawer", () -> new CompactingFramedDrawerBlock("compacting_framed_drawer"), blockRegistryObject -> () -> new CompactingDrawerBlock.CompactingDrawerItem((Block)blockRegistryObject.get(), new Item.Properties(), 3), TAB);
        DRAWER_CONTROLLER = this.getRegistries().registerBlockWithTile("storage_controller", DrawerControllerBlock::new, TAB);
        FRAMED_DRAWER_CONTROLLER = this.getRegistries().registerBlockWithTile("framed_storage_controller", FramedDrawerControllerBlock::new, TAB);
        CONTROLLER_EXTENSION = this.getRegistries().registerBlockWithTile("controller_extension", ControllerExtensionBlock::new, TAB);
        FRAMED_CONTROLLER_EXTENSION = this.getRegistries().registerBlockWithTile("framed_controller_extension", FramedControllerExtensionBlock::new, TAB);
        LINKING_TOOL = this.getRegistries().registerGeneric(Registries.ITEM, "linking_tool", LinkingToolItem::new);
        CONFIGURATION_TOOL = this.getRegistries().registerGeneric(Registries.ITEM, "configuration_tool", ConfigurationToolItem::new);
        for (Enum enum_ : StorageUpgradeItem.StorageTier.values()) {
            STORAGE_UPGRADES.put((StorageUpgradeItem.StorageTier)enum_, (DeferredHolder<Item, Item>)this.getRegistries().registerGeneric(Registries.ITEM, enum_.name().toLowerCase(Locale.ROOT) + (enum_ == StorageUpgradeItem.StorageTier.IRON ? "_downgrade" : "_upgrade"), () -> FunctionalStorage.lambda$initModules$39((StorageUpgradeItem.StorageTier)enum_)));
        }
        SIMPLE_COMPACTING_DRAWER = this.getRegistries().registerBlockWithTileItem("simple_compacting_drawer", () -> new SimpleCompactingDrawerBlock("simple_compacting_drawer", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)), blockRegistryObject -> () -> new CompactingDrawerBlock.CompactingDrawerItem((Block)blockRegistryObject.get(), new Item.Properties(), 2), TAB);
        FRAMED_SIMPLE_COMPACTING_DRAWER = this.getRegistries().registerBlockWithTileItem("framed_simple_compacting_drawer", () -> new FramedSimpleCompactingDrawerBlock("framed_simple_compacting_drawer"), blockRegistryObject -> () -> new CompactingDrawerBlock.CompactingDrawerItem((Block)blockRegistryObject.get(), new Item.Properties(), 2), TAB);
        COLLECTOR_UPGRADE = this.getRegistries().registerGeneric(Registries.ITEM, "collector_upgrade", () -> new UpgradeItem(new AndBehavior(List.of(new ExecuteEveryBehavior(FunctionalStorageConfig.UPGRADE_TICK, CollectItemEntitiesBehavior.INSTANCE), new ExecuteEveryBehavior(FunctionalStorageConfig.UPGRADE_TICK * 3, CollectFluidsBehavior.INSTANCE)))));
        PULLING_UPGRADE = this.getRegistries().registerGeneric(Registries.ITEM, "puller_upgrade", () -> new UpgradeItem(new ExecuteEveryBehavior(FunctionalStorageConfig.UPGRADE_TICK, new AndBehavior(List.of(new MoveItemsBehavior(false, FunctionalStorageConfig.UPGRADE_PULL_ITEMS), new MoveFluidsBehavior(false, FunctionalStorageConfig.UPGRADE_PULL_FLUID))))));
        PUSHING_UPGRADE = this.getRegistries().registerGeneric(Registries.ITEM, "pusher_upgrade", () -> new UpgradeItem(new ExecuteEveryBehavior(FunctionalStorageConfig.UPGRADE_TICK, new AndBehavior(List.of(new MoveItemsBehavior(true, FunctionalStorageConfig.UPGRADE_PUSH_ITEMS), new MoveFluidsBehavior(true, FunctionalStorageConfig.UPGRADE_PUSH_FLUID))))));
        VOID_UPGRADE = this.getRegistries().registerGeneric(Registries.ITEM, "void_upgrade", () -> new UpgradeItem(new Item.Properties(), UpgradeItem.Type.UTILITY));
        ARMORY_CABINET = this.getRegistries().registerBlockWithTile("armory_cabinet", ArmoryCabinetBlock::new, TAB);
        ENDER_DRAWER = this.getRegistries().registerBlockWithTile("ender_drawer", EnderDrawerBlock::new, TAB);
        REDSTONE_UPGRADE = this.getRegistries().registerGeneric(Registries.ITEM, "redstone_upgrade", () -> new UpgradeItem(EmitRedstoneBehavior.INSTANCE));
        CREATIVE_UPGRADE = this.getRegistries().registerGeneric(Registries.ITEM, "creative_vending_upgrade", () -> new UpgradeItem(this, new Item.Properties(), UpgradeItem.Type.STORAGE){

            public boolean isFoil(ItemStack p_41453_) {
                return true;
            }
        });
        DrawerlessWoodIngredient.TYPE = this.getRegistries().registerGeneric(NeoForgeRegistries.Keys.INGREDIENT_TYPES, DrawerlessWoodIngredient.NAME.getPath(), () -> new IngredientType(DrawerlessWoodIngredient.CODEC));
        this.addCreativeTab("main", () -> new ItemStack((ItemLike)DRAWER_CONTROLLER), MOD_ID, TAB);
        CUSTOM_COMPACTING_RECIPE_TYPE = this.getRegistries().registerGeneric(Registries.RECIPE_TYPE, "custom_compacting", () -> RecipeType.simple((ResourceLocation)Utils.resourceLocation(MOD_ID, "custom_compacting")));
        CUSTOM_COMPACTING_RECIPE_SERIALIZER = this.getRegistries().registerGeneric(Registries.RECIPE_SERIALIZER, "custom_compacting", () -> new GenericSerializer(CustomCompactingRecipe.class, () -> CUSTOM_COMPACTING_RECIPE_TYPE.value(), CustomCompactingRecipe.CODEC));
        FRAMED_RECIPE_TYPE = this.getRegistries().registerGeneric(Registries.RECIPE_TYPE, "framed_recipe", () -> RecipeType.simple((ResourceLocation)Utils.resourceLocation(MOD_ID, "framed_recipe")));
        FRAMED_RECIPE_SERIALIZER = this.getRegistries().registerGeneric(Registries.RECIPE_SERIALIZER, "framed_recipe", () -> new SimpleCraftingRecipeSerializer(c -> new FramedDrawerRecipe()));
        COPY_COMPONENTS_SERIALIZER = this.getRegistries().registerGeneric(Registries.RECIPE_SERIALIZER, "copy_components", () -> new RecipeSerializer<CopyComponentsRecipe>(this){

            public MapCodec<CopyComponentsRecipe> codec() {
                return CopyComponentsRecipe.CODEC;
            }

            public StreamCodec<RegistryFriendlyByteBuf, CopyComponentsRecipe> streamCodec() {
                return CopyComponentsRecipe.STREAM_CODEC;
            }
        });
        this.getRegistries().registerGeneric(FunctionalUpgradeBehavior.REGISTRY_KEY, "delegate_to_item", () -> DelegateToItemBehavior.CODEC);
        this.getRegistries().registerGeneric(FunctionalUpgradeBehavior.REGISTRY_KEY, "execute_every", () -> ExecuteEveryBehavior.CODEC);
        this.getRegistries().registerGeneric(FunctionalUpgradeBehavior.REGISTRY_KEY, "generate_item", () -> GenerateItemBehavior.CODEC);
        this.getRegistries().registerGeneric(FunctionalUpgradeBehavior.REGISTRY_KEY, "generate_fluid", () -> GenerateFluidBehavior.CODEC);
        this.getRegistries().registerGeneric(FunctionalUpgradeBehavior.REGISTRY_KEY, "move_items", () -> MoveItemsBehavior.CODEC);
        this.getRegistries().registerGeneric(FunctionalUpgradeBehavior.REGISTRY_KEY, "move_fluids", () -> MoveFluidsBehavior.CODEC);
        this.getRegistries().registerGeneric(FunctionalUpgradeBehavior.REGISTRY_KEY, "collect_item_entities", () -> CollectItemEntitiesBehavior.CODEC);
        this.getRegistries().registerGeneric(FunctionalUpgradeBehavior.REGISTRY_KEY, "collect_fluids", () -> CollectFluidsBehavior.CODEC);
        this.getRegistries().registerGeneric(FunctionalUpgradeBehavior.REGISTRY_KEY, "emit_redstone", () -> EmitRedstoneBehavior.CODEC);
        this.getRegistries().registerGeneric(FunctionalUpgradeBehavior.REGISTRY_KEY, "and", () -> AndBehavior.CODEC);
        DRIPPING_UPGRADE = this.getRegistries().registerGeneric(Registries.ITEM, "dripping_upgrade", () -> new FSItem(new Item.Properties().component(FSAttachments.FUNCTIONAL_BEHAVIOR, (Object)new ExecuteEveryBehavior(20, new GenerateFluidBehavior(new FluidStack((Fluid)Fluids.LAVA, 20))))));
        WATER_GENERATOR_UPGRADE = this.getRegistries().registerGeneric(Registries.ITEM, "water_generator_upgrade", () -> new FSItem(new Item.Properties().component(FSAttachments.FUNCTIONAL_BEHAVIOR, (Object)new ExecuteEveryBehavior(1, new GenerateFluidBehavior(new FluidStack((Fluid)Fluids.WATER, 2000))))));
        OBSIDIAN_UPGRADE = this.getRegistries().registerGeneric(Registries.ITEM, "obsidian_upgrade", () -> new FSItem(new Item.Properties().component(FSAttachments.FUNCTIONAL_BEHAVIOR, (Object)new ExecuteEveryBehavior(300, new GenerateItemBehavior(new ItemStack((ItemLike)Items.OBSIDIAN))))));
        IEventBus eventBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        eventBus.addListener(event -> event.modify((ItemLike)VOID_UPGRADE.get(), b -> b.set(FSAttachments.INCOMPATIBLE_UPGRADES.get(), (Object)HolderSet.direct((Holder[])new Holder[]{((Item)VOID_UPGRADE.get()).builtInRegistryHolder()}))));
        eventBus.addListener(EventPriority.LOWEST, regEvent -> {
            if (regEvent.getRegistryKey() == Registries.BLOCK) {
                FRAMED_BLOCKS = this.getRegistries().getRegistry(Registries.BLOCK).getEntries().stream().filter(bl -> bl.value() instanceof FramedBlock).map(Holder::value).toList();
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClient() {
        EventManager.mod(EntityRenderersEvent.RegisterRenderers.class).process(registerRenderers -> {
            for (DrawerType value : DrawerType.values()) {
                DRAWER_TYPES.get((Object)value).forEach(blockRegistryObject -> registerRenderers.registerBlockEntityRenderer((BlockEntityType)blockRegistryObject.type().get(), p_173571_ -> new DrawerRenderer()));
            }
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)COMPACTING_DRAWER.type().get(), p_173571_ -> new CompactingDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)FRAMED_COMPACTING_DRAWER.type().get(), p_173571_ -> new CompactingDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)DRAWER_CONTROLLER.type().get(), p -> new ControllerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)ENDER_DRAWER.type().get(), p_173571_ -> new EnderDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)FLUID_DRAWER_1.type().get(), p_173571_ -> new FluidDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)FLUID_DRAWER_2.type().get(), p_173571_ -> new FluidDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)FLUID_DRAWER_4.type().get(), p_173571_ -> new FluidDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)FRAMED_FLUID_DRAWER_1.type().get(), p_173571_ -> new FluidDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)FRAMED_FLUID_DRAWER_2.type().get(), p_173571_ -> new FluidDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)FRAMED_FLUID_DRAWER_4.type().get(), p_173571_ -> new FluidDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)SIMPLE_COMPACTING_DRAWER.type().get(), p_173571_ -> new SimpleCompactingDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)FRAMED_DRAWER_CONTROLLER.type().get(), p -> new ControllerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)FRAMED_SIMPLE_COMPACTING_DRAWER.type().get(), p_173571_ -> new SimpleCompactingDrawerRenderer());
        }).subscribe();
        EventManager.mod(RegisterColorHandlersEvent.Item.class).process(item -> {
            item.getItemColors().register((stack, tint) -> {
                LinkingToolItem.LinkingMode linkingMode = LinkingToolItem.getLinkingMode(stack);
                LinkingToolItem.ActionMode linkingAction = LinkingToolItem.getActionMode(stack);
                if (tint != 0 && stack.has(FSAttachments.ENDER_FREQUENCY)) {
                    return FastColor.ARGB32.opaque((int)new Color(44, 150, 88).getRGB());
                }
                if (tint == 3 && stack.has(FSAttachments.CONTROLLER)) {
                    return FastColor.ARGB32.opaque((int)Color.RED.getRGB());
                }
                if (tint == 1) {
                    return FastColor.ARGB32.opaque((int)linkingMode.getColor().getValue());
                }
                if (tint == 2) {
                    return FastColor.ARGB32.opaque((int)linkingAction.getColor().getValue());
                }
                return -1;
            }, new ItemLike[]{(ItemLike)LINKING_TOOL.get()});
            item.getItemColors().register((stack, tint) -> {
                ConfigurationToolItem.ConfigurationAction action = ConfigurationToolItem.getAction(stack);
                if (tint == 1) {
                    return FastColor.ARGB32.opaque((int)action.getColor().getValue());
                }
                return -1;
            }, new ItemLike[]{(ItemLike)CONFIGURATION_TOOL.get()});
        }).subscribe();
        EventManager.mod(FMLClientSetupEvent.class).process(event -> {
            for (DrawerType value : DrawerType.values()) {
                DRAWER_TYPES.get((Object)value).stream().map(BlockWithTile::getBlock).forEach(bl -> ItemBlockRenderTypes.setRenderLayer((Block)bl, (RenderType)RenderType.cutout()));
            }
            ItemBlockRenderTypes.setRenderLayer((Block)COMPACTING_DRAWER.getBlock(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)FRAMED_COMPACTING_DRAWER.getBlock(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ENDER_DRAWER.getBlock(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)FLUID_DRAWER_1.getBlock(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)FLUID_DRAWER_2.getBlock(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)FLUID_DRAWER_4.getBlock(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)SIMPLE_COMPACTING_DRAWER.getBlock(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)FRAMED_DRAWER_CONTROLLER.getBlock(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)FRAMED_CONTROLLER_EXTENSION.getBlock(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)FRAMED_SIMPLE_COMPACTING_DRAWER.getBlock(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)FRAMED_FLUID_DRAWER_1.getBlock(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)FRAMED_FLUID_DRAWER_2.getBlock(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)FRAMED_FLUID_DRAWER_4.getBlock(), (RenderType)RenderType.cutout());
        }).subscribe();
        EventManager.forge(RenderTooltipEvent.Pre.class).process(itemTooltipEvent -> {
            IItemHandler iItemHandler;
            if (itemTooltipEvent.getItemStack().getItem().equals(ENDER_DRAWER.getBlock().asItem()) && itemTooltipEvent.getItemStack().has(FSAttachments.TILE)) {
                TooltipUtil.renderItems(itemTooltipEvent.getGraphics(), EnderDrawerBlock.getFrequencyDisplay(((CompoundTag)itemTooltipEvent.getItemStack().get(FSAttachments.TILE)).getString("frequency")), itemTooltipEvent.getX() + 14, itemTooltipEvent.getY() + 11);
            }
            if (itemTooltipEvent.getItemStack().is((Item)LINKING_TOOL.get()) && itemTooltipEvent.getItemStack().has(FSAttachments.ENDER_FREQUENCY)) {
                TooltipUtil.renderItems(itemTooltipEvent.getGraphics(), EnderDrawerBlock.getFrequencyDisplay((String)itemTooltipEvent.getItemStack().get(FSAttachments.ENDER_FREQUENCY)), itemTooltipEvent.getX() + 14, itemTooltipEvent.getY() + 11);
            }
            if ((iItemHandler = (IItemHandler)itemTooltipEvent.getItemStack().getCapability(Capabilities.ItemHandler.ITEM)) != null) {
                if (iItemHandler instanceof DrawerStackItemHandler) {
                    DrawerStackItemHandler drawerStackItemHandler = (DrawerStackItemHandler)iItemHandler;
                    int i = 0;
                    for (BigInventoryHandler.BigStack storedStack : ((DrawerStackItemHandler)iItemHandler).getStoredStacks()) {
                        if (storedStack.getStack().getItem() == Items.AIR) continue;
                        TooltipUtil.renderItemAdvanced(itemTooltipEvent.getGraphics(), storedStack.getStack(), itemTooltipEvent.getX() + 20 + 32 * i, itemTooltipEvent.getY() + 11, 512, NumberUtils.getFormatedBigNumber(drawerStackItemHandler.isCreative() ? Integer.MAX_VALUE : storedStack.getAmount()));
                        ++i;
                    }
                }
                if (iItemHandler instanceof CompactingStackItemHandler) {
                    CompactingStackItemHandler compactingStackItemHandler = (CompactingStackItemHandler)iItemHandler;
                    int pos = 0;
                    for (int i = compactingStackItemHandler.getSlots(); i >= 0; --i) {
                        ItemStack stack = compactingStackItemHandler.getStackInSlot(i);
                        if (stack.isEmpty()) continue;
                        TooltipUtil.renderItemAdvanced(itemTooltipEvent.getGraphics(), stack, itemTooltipEvent.getX() + 20 + 32 * pos, itemTooltipEvent.getY() + 11, 512, NumberUtils.getFormatedBigNumber(stack.getCount()) + "/" + NumberUtils.getFormatedBigNumber(iItemHandler.getSlotLimit(i)));
                        ++pos;
                    }
                }
            }
        }).subscribe();
        EventManager.mod(ModelEvent.RegisterGeometryLoaders.class).process(modelRegistryEvent -> modelRegistryEvent.register(Utils.resourceLocation(MOD_ID, "framedblock"), (IGeometryLoader)FramedModel.Loader.INSTANCE)).subscribe();
        ClientSetup.init();
    }

    public void addDataProvider(GatherDataEvent event) {
        final Lazy blocksToProcess = Lazy.of(() -> BuiltInRegistries.BLOCK.stream().filter(basicBlock -> Optional.of(BuiltInRegistries.BLOCK.getKey(basicBlock)).map(ResourceLocation::getNamespace).filter(MOD_ID::equalsIgnoreCase).isPresent()).collect(Collectors.toList()));
        event.getGenerator().addProvider(true, (DataProvider)new FunctionalStorageBlockstateProvider(event.getGenerator(), event.getExistingFileHelper(), (Lazy<List<Block>>)blocksToProcess));
        event.getGenerator().addProvider(true, (DataProvider)new TitaniumLootTableProvider(event.getGenerator(), (Supplier)blocksToProcess, event.getLookupProvider()));
        FunctionalStorageBlockTagsProvider blockTags = new FunctionalStorageBlockTagsProvider(event.getGenerator(), event.getLookupProvider(), MOD_ID, event.getExistingFileHelper());
        event.getGenerator().addProvider(true, (DataProvider)blockTags);
        event.getGenerator().addProvider(true, (DataProvider)new FunctionalStorageItemTagsProvider(event.getGenerator().getPackOutput(), event.getLookupProvider(), blockTags.contentsGetter(), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().addProvider(true, (DataProvider)new FunctionalStorageLangProvider(event.getGenerator(), MOD_ID, "en_us"));
        event.getGenerator().addProvider(true, (DataProvider)new ItemModelProvider(this, event.getGenerator().getPackOutput(), MOD_ID, event.getExistingFileHelper()){

            protected void registerModels() {
                ((List)blocksToProcess.get()).forEach(block -> {
                    if (block instanceof DrawerBlock || block instanceof CompactingDrawerBlock || block instanceof SimpleCompactingDrawerBlock || block instanceof FluidDrawerBlock) {
                        this.withUnchecked(BuiltInRegistries.BLOCK.getKey(block).getPath(), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"builtin/entity"));
                    } else {
                        this.withUnchecked(BuiltInRegistries.BLOCK.getKey(block).getPath(), ResourceLocation.fromNamespaceAndPath((String)FunctionalStorage.MOD_ID, (String)("block/" + BuiltInRegistries.BLOCK.getKey(block).getPath())));
                    }
                });
                for (StorageUpgradeItem.StorageTier storageTier : STORAGE_UPGRADES.keySet()) {
                    this.item((Item)STORAGE_UPGRADES.get((Object)storageTier).get());
                }
                this.item((Item)COLLECTOR_UPGRADE.get());
                this.item((Item)PULLING_UPGRADE.get());
                this.item((Item)PUSHING_UPGRADE.get());
                this.item((Item)VOID_UPGRADE.get());
                this.item((Item)REDSTONE_UPGRADE.get());
                this.item((Item)CREATIVE_UPGRADE.get());
                this.item((Item)DRIPPING_UPGRADE.get());
                this.item((Item)WATER_GENERATOR_UPGRADE.get());
                this.item((Item)OBSIDIAN_UPGRADE.get());
            }

            private void item(Item item) {
                this.withUnchecked(BuiltInRegistries.ITEM.getKey((Object)item).getPath(), Utils.resourceLocation("minecraft:item/generated")).texture("layer0", Utils.resourceLocation(FunctionalStorage.MOD_ID, "item/" + BuiltInRegistries.ITEM.getKey((Object)item).getPath()));
            }

            private ItemModelBuilder withUnchecked(String name, ResourceLocation parent) {
                return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(parent));
            }
        });
        event.getGenerator().addProvider(true, (DataProvider)new FunctionalStorageRecipesProvider(event.getGenerator(), (Lazy<List<Block>>)blocksToProcess, event.getLookupProvider()));
    }

    private static /* synthetic */ Item lambda$initModules$39(StorageUpgradeItem.StorageTier value) {
        return new StorageUpgradeItem(value);
    }

    static {
        NETWORK.registerMessage("ender_drawer_sync", EnderDrawerSyncMessage.class);
        LOGGER = LogUtils.getLogger();
        WOOD_TYPES = new ConcurrentLinkedQueue();
        DRAWER_TYPES = new HashMap();
        STORAGE_UPGRADES = new HashMap();
        TAB = new TitaniumTab(Utils.resourceLocation(MOD_ID, "main"));
    }

    public static enum DrawerType {
        X_1(1, 32, "1x1", integer -> Pair.of((Object)16, (Object)16)),
        X_2(2, 16, "1x2", integer -> {
            if (integer == 0) {
                return Pair.of((Object)16, (Object)28);
            }
            return Pair.of((Object)16, (Object)4);
        }),
        X_4(4, 8, "2x2", integer -> {
            if (integer == 0) {
                return Pair.of((Object)28, (Object)28);
            }
            if (integer == 1) {
                return Pair.of((Object)4, (Object)28);
            }
            if (integer == 2) {
                return Pair.of((Object)28, (Object)4);
            }
            return Pair.of((Object)4, (Object)4);
        });

        private final int slots;
        private final int slotAmount;
        private final String displayName;
        private final TagKey<Item> tag;
        private final Function<Integer, Pair<Integer, Integer>> slotPosition;

        private DrawerType(int slots, int slotAmount, String displayName, Function<Integer, Pair<Integer, Integer>> slotPosition) {
            this.slots = slots;
            this.slotAmount = slotAmount;
            this.displayName = displayName;
            this.slotPosition = slotPosition;
            this.tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)FunctionalStorage.MOD_ID, (String)("drawer_" + displayName)));
        }

        public int getSlots() {
            return this.slots;
        }

        public int getSlotAmount() {
            return this.slotAmount;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Function<Integer, Pair<Integer, Integer>> getSlotPosition() {
            return this.slotPosition;
        }

        public TagKey<Item> getTag() {
            return this.tag;
        }
    }
}

