/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network.messages;

import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OpenGuiMessage(OpenGuiOp op, MFLocator locator) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenGuiMessage> TYPE = new CustomPacketPayload.Type(MiscUtil.RL("open_gui"));
    public static final StreamCodec<FriendlyByteBuf, OpenGuiMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(OpenGuiOp.class), OpenGuiMessage::op, MFLocator.STREAM_CODEC, OpenGuiMessage::locator, OpenGuiMessage::new);

    public static OpenGuiMessage openRouter(MFLocator locator) {
        return new OpenGuiMessage(OpenGuiOp.ROUTER, locator);
    }

    public static OpenGuiMessage openModuleInHand(MFLocator locator) {
        return new OpenGuiMessage(OpenGuiOp.MODULE_HELD, locator);
    }

    public static OpenGuiMessage openModuleInRouter(MFLocator locator) {
        return new OpenGuiMessage(OpenGuiOp.MODULE_INSTALLED, locator);
    }

    public static OpenGuiMessage openFilterInHeldModule(MFLocator locator) {
        return new OpenGuiMessage(OpenGuiOp.FILTER_HELD, locator);
    }

    public static OpenGuiMessage openFilterInInstalledModule(MFLocator locator) {
        return new OpenGuiMessage(OpenGuiOp.FILTER_INSTALLED, locator);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleData(OpenGuiMessage message, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        MFLocator locator = message.locator();
        switch (message.op().ordinal()) {
            case 0: {
                locator.getRouter(player.getCommandSenderWorld()).ifPresent(router -> player.openMenu((MenuProvider)router, locator.routerPos()));
                break;
            }
            case 1: {
                player.openMenu((MenuProvider)new ModuleItem.ModuleMenuProvider((Player)player, locator), locator::toNetwork);
                break;
            }
            case 2: {
                locator.getRouter(player.getCommandSenderWorld()).ifPresent(router -> player.openMenu((MenuProvider)new ModuleItem.ModuleMenuProvider((Player)player, locator), locator::toNetwork));
                break;
            }
            case 3: {
                player.openMenu((MenuProvider)new SmartFilterItem.FilterMenuProvider((Player)player, locator), locator::toNetwork);
                break;
            }
            case 4: {
                locator.getRouter(player.getCommandSenderWorld()).ifPresent(router -> player.openMenu((MenuProvider)new SmartFilterItem.FilterMenuProvider((Player)player, locator), locator::toNetwork));
            }
        }
    }

    public static enum OpenGuiOp {
        ROUTER,
        MODULE_HELD,
        MODULE_INSTALLED,
        FILTER_HELD,
        FILTER_INSTALLED;

    }
}

