/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.augment;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.desht.modularrouters.container.handler.AugmentHandler;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.MRBaseItem;
import me.desht.modularrouters.item.module.ModuleItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.Validate;

public abstract class AugmentItem
extends MRBaseItem {
    public static final int SLOTS = 4;

    public AugmentItem() {
        super(ModItems.defaultProps());
    }

    @Override
    protected void addExtraInformation(ItemStack stack, List<Component> list) {
    }

    public abstract int getMaxAugments(ModuleItem var1);

    public Component getExtraInfo(int c, ItemStack moduleStack) {
        return Component.empty();
    }

    public static class AugmentCounter {
        private final Map<AugmentItem, Integer> counts = new HashMap<AugmentItem, Integer>();

        public AugmentCounter(ItemStack moduleStack) {
            this.refresh(moduleStack);
        }

        public void refresh(ItemStack moduleStack) {
            Validate.isTrue((boolean)(moduleStack.getItem() instanceof ModuleItem), (String)("item is not a ModuleItem: " + String.valueOf(moduleStack)), (Object[])new Object[0]);
            AugmentHandler h = new AugmentHandler(moduleStack, null);
            this.counts.clear();
            for (int i = 0; i < h.getSlots(); ++i) {
                ItemStack augmentStack = h.getStackInSlot(i);
                Item item = augmentStack.getItem();
                if (!(item instanceof AugmentItem)) continue;
                AugmentItem augment = (AugmentItem)item;
                this.counts.merge(augment, augmentStack.getCount(), Integer::sum);
            }
        }

        public Collection<AugmentItem> getAugments() {
            return this.counts.keySet().stream().toList();
        }

        public int getAugmentCount(Supplier<Item> type) {
            return this.getAugmentCount(type.get());
        }

        public int getAugmentCount(Item type) {
            return type instanceof AugmentItem ? this.counts.getOrDefault(type, 0) : 0;
        }
    }
}

