/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import java.util.ArrayList;
import me.desht.modularrouters.client.gui.module.ModuleScreen;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.logic.compiled.CompiledFluidModule;
import me.desht.modularrouters.logic.settings.TransferDirection;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.Range;

public class FluidModuleScreen
extends ModuleScreen {
    private static final ItemStack bucketStack = new ItemStack((ItemLike)Items.BUCKET);
    private static final ItemStack routerStack = new ItemStack((ItemLike)ModBlocks.MODULAR_ROUTER.get());
    private static final ItemStack waterStack = new ItemStack((ItemLike)Items.WATER_BUCKET);
    private ForceEmptyButton forceEmptyButton;
    private RegulateAbsoluteButton regulationTypeButton;
    private FluidDirectionButton fluidDirButton;
    private IntegerTextField maxTransferField;

    public FluidModuleScreen(ModuleMenu container, Inventory inv, Component displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void init() {
        super.init();
        CompiledFluidModule cfm = new CompiledFluidModule(null, this.moduleItemStack);
        int max = (Integer)ConfigHolder.common.router.baseTickRate.get() * (Integer)ConfigHolder.common.router.fluidMaxTransferRate.get();
        this.maxTransferField = new IntegerTextField(this.font, this.leftPos + 152, this.topPos + 23, 34, 12, (Range<Integer>)Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(max)));
        this.maxTransferField.setValue(cfm.getMaxTransfer());
        this.maxTransferField.setResponder(str -> this.sendModuleSettingsDelayed(5));
        this.maxTransferField.setIncr(100, 10, 10);
        this.maxTransferField.useGuiTextBackground();
        this.addRenderableWidget((GuiEventListener)this.maxTransferField);
        this.addRenderableWidget((GuiEventListener)new TooltipButton(this, this.leftPos + 130, this.topPos + 19, 16, 16, bucketStack));
        this.fluidDirButton = new FluidDirectionButton(this, this.leftPos + 148, this.topPos + 44, cfm.getFluidDirection());
        this.addRenderableWidget((GuiEventListener)this.fluidDirButton);
        this.forceEmptyButton = new ForceEmptyButton(this, this.leftPos + 168, this.topPos + 69, cfm.isForceEmpty());
        this.addRenderableWidget((GuiEventListener)this.forceEmptyButton);
        this.regulationTypeButton = new RegulateAbsoluteButton(this.regulatorTextField.getX() + this.regulatorTextField.getWidth() + 2, this.regulatorTextField.getY() - 1, 18, 14, b -> this.toggleRegulationType(), cfm.isRegulateAbsolute());
        this.addRenderableWidget((GuiEventListener)this.regulationTypeButton);
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 128, this.topPos + 17, this.leftPos + 183, this.topPos + 35, "modularrouters.guiText.popup.fluid.maxTransfer");
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 126, this.topPos + 42, this.leftPos + 185, this.topPos + 61, "modularrouters.guiText.popup.fluid.direction");
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 128, this.topPos + 67, this.leftPos + 185, this.topPos + 86, "modularrouters.guiText.popup.fluid.forceEmpty");
    }

    @Override
    protected IntegerTextField buildRegulationTextField() {
        IntegerTextField tf = new IntegerTextField(this.font, this.leftPos + 128, this.topPos + 90, 40, 12, (Range<Integer>)Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        tf.setValue(this.getRegulatorAmount());
        tf.setResponder(str -> {
            this.setRegulatorAmount(str.isEmpty() ? 0 : Integer.parseInt(str));
            this.sendModuleSettingsDelayed(5);
        });
        return tf;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        graphics.blit(GUI_TEXTURE, this.leftPos + 146, this.topPos + 20, LARGE_TEXTFIELD_XY.x(), LARGE_TEXTFIELD_XY.y(), 35, 14);
        graphics.renderItem(routerStack, this.leftPos + 128, this.topPos + 44);
        graphics.renderItem(waterStack, this.leftPos + 168, this.topPos + 44);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        if (this.forceEmptyButton.visible) {
            MutableComponent c = ClientUtil.xlate("modularrouters.guiText.label.fluidForceEmpty", new Object[0]);
            graphics.drawString(this.font, (Component)c, 165 - this.font.width((FormattedText)c), 73, 0x202040, false);
        }
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.regulationTypeButton.visible = this.regulatorTextField.visible;
        this.regulationTypeButton.setText();
        this.regulatorTextField.setRange((Range<Integer>)Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.regulationTypeButton.regulateAbsolute ? Integer.MAX_VALUE : 100)));
        this.forceEmptyButton.visible = this.fluidDirButton.getState() == TransferDirection.FROM_ROUTER;
    }

    @Override
    protected ItemStack buildModifiedItemStack() {
        return (ItemStack)Util.make((Object)super.buildModifiedItemStack(), stack -> stack.set(ModDataComponents.FLUID_SETTINGS, (Object)new CompiledFluidModule.FluidModuleSettings(this.maxTransferField.getIntValue(), (TransferDirection)this.fluidDirButton.getState(), this.forceEmptyButton.isToggled(), this.regulationTypeButton.regulateAbsolute)));
    }

    private void toggleRegulationType() {
        this.regulationTypeButton.toggle();
        this.regulatorTextField.setRange((Range<Integer>)(this.regulationTypeButton.regulateAbsolute ? Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)) : Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100))));
        this.sendToServer();
    }

    private class TooltipButton
    extends ItemStackButton {
        TooltipButton(FluidModuleScreen fluidModuleScreen, int x, int y, int width, int height, ItemStack renderStack) {
            super(x, y, width, height, renderStack, true, p -> {});
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.fluidTransferTooltip", new Object[0]));
            tooltip.add((Component)Component.empty());
            fluidModuleScreen.getItemRouter().ifPresent(router -> {
                int ftRate = router.getFluidTransferRate();
                int tickRate = router.getTickRate();
                tooltip.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.maxFluidPerOp", ftRate * tickRate, tickRate, ftRate));
                tooltip.add((Component)Component.empty().plainCopy());
            });
            tooltip.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.numberFieldTooltip", new Object[0]));
            ClientUtil.setMultilineTooltip((AbstractWidget)this, tooltip);
        }

        public void playDownSound(SoundManager soundHandlerIn) {
        }
    }

    private class FluidDirectionButton
    extends TexturedCyclerButton<TransferDirection> {
        FluidDirectionButton(FluidModuleScreen fluidModuleScreen, int x, int y, TransferDirection initialVal) {
            super(x, y, 16, 16, initialVal, fluidModuleScreen);
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(160 + ((TransferDirection)this.getState()).ordinal() * 16, 16);
        }
    }

    private class ForceEmptyButton
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(112, 16);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(192, 16);

        ForceEmptyButton(FluidModuleScreen fluidModuleScreen, int x, int y, boolean initialVal) {
            super(x, y, 16, 16, initialVal, fluidModuleScreen);
            this.setTooltips(Tooltip.create((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.fluidForceEmpty.false", new Object[0])), Tooltip.create((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.fluidForceEmpty.true", new Object[0])));
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }
    }

    private static class RegulateAbsoluteButton
    extends ExtendedButton {
        private boolean regulateAbsolute;

        public RegulateAbsoluteButton(int xPos, int yPos, int width, int height, Button.OnPress pressable, boolean regulateAbsolute) {
            super(xPos, yPos, width, height, (Component)Component.empty(), pressable);
            this.regulateAbsolute = regulateAbsolute;
        }

        private void toggle() {
            this.regulateAbsolute = !this.regulateAbsolute;
        }

        void setText() {
            this.setMessage((Component)Component.literal((String)(this.regulateAbsolute ? "mB" : "%")));
        }
    }
}

