/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import me.desht.modularrouters.client.gui.filter.AbstractFilterContainerScreen;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.container.AbstractSmartFilterMenu;
import me.desht.modularrouters.item.smartfilter.ModFilter;
import me.desht.modularrouters.network.messages.FilterUpdateMessage;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class ModFilterScreen
extends AbstractFilterContainerScreen {
    private static final ResourceLocation TEXTURE_LOCATION = MiscUtil.RL("textures/gui/modfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 252;
    private final List<String> mods = Lists.newArrayList();
    private final List<Buttons.DeleteButton> deleteButtons = Lists.newArrayList();
    private ItemStack prevInSlot = ItemStack.EMPTY;
    private String modId = "";
    private String modName = "";

    public ModFilterScreen(AbstractSmartFilterMenu container, Inventory inv, Component displayName) {
        super(container, inv, displayName);
        this.imageWidth = 176;
        this.imageHeight = 252;
        this.mods.addAll(ModFilter.getModList(this.filterStack));
    }

    public void init() {
        super.init();
        if (((AbstractSmartFilterMenu)this.menu).getLocator().filterSlot() >= 0) {
            this.addRenderableWidget((GuiEventListener)new BackButton(this.leftPos - 12, this.topPos, p -> this.closeGUI()));
        }
        this.addRenderableWidget((GuiEventListener)new Buttons.AddButton(this.leftPos + 154, this.topPos + 19, p -> {
            if (!this.modId.isEmpty()) {
                LinkedHashSet<String> updatedMods = new LinkedHashSet<String>(this.mods);
                updatedMods.add(this.modId);
                this.sendModsToServer(updatedMods);
                ((Slot)((AbstractSmartFilterMenu)this.getMenu()).slots.getFirst()).set(ItemStack.EMPTY);
            }
        }));
        this.deleteButtons.clear();
        for (int i = 0; i < 6; ++i) {
            Buttons.DeleteButton b = new Buttons.DeleteButton(this.leftPos + 8, this.topPos + 44 + i * 19, i, button -> this.sendModsToServer(button.removeFromList(new ArrayList<String>(this.mods))));
            this.addRenderableWidget((GuiEventListener)b);
            this.deleteButtons.add(b);
        }
        this.updateDeleteButtonVisibility();
    }

    private void sendModsToServer(Collection<String> newMods) {
        ItemStack newStack = (ItemStack)Util.make((Object)this.filterStack.copy(), s -> ModFilter.setModList(s, List.copyOf(newMods)));
        PacketDistributor.sendToServer((CustomPacketPayload)new FilterUpdateMessage(((AbstractSmartFilterMenu)this.menu).getLocator(), newStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void updateDeleteButtonVisibility() {
        for (int i = 0; i < this.deleteButtons.size(); ++i) {
            this.deleteButtons.get((int)i).visible = i < this.mods.size();
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        MutableComponent txt = this.filterStack.getHoverName().copy().append(" ").append((Component)(((AbstractSmartFilterMenu)this.menu).getRouter() != null ? ClientUtil.xlate("modularrouters.guiText.label.installed", new Object[0]) : Component.empty()));
        graphics.drawString(this.font, (Component)txt, this.imageWidth / 2 - this.font.width((FormattedText)txt) / 2, 8, 0x404040, false);
        if (!this.modName.isEmpty()) {
            graphics.drawString(this.font, this.modName, 29, 23, 0x404040, false);
        }
        for (int i = 0; i < this.mods.size(); ++i) {
            String mod = ModNameCache.getModName(this.mods.get(i));
            graphics.drawString(this.font, mod, 28, 47 + i * 19, 0x404080, false);
        }
    }

    public void containerTick() {
        super.containerTick();
        ItemStack inSlot = (ItemStack)((AbstractSmartFilterMenu)this.getMenu()).getItems().getFirst();
        if (inSlot.isEmpty() && !this.prevInSlot.isEmpty()) {
            this.modName = "";
            this.modId = "";
        } else if (!(inSlot.isEmpty() || !this.prevInSlot.isEmpty() && MiscUtil.sameItemStackIgnoreDurability(inSlot, this.prevInSlot))) {
            this.modId = BuiltInRegistries.ITEM.getKey((Object)inSlot.getItem()).getNamespace();
            this.modName = ModNameCache.getModName(this.modId);
        }
        this.prevInSlot = inSlot;
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(TEXTURE_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    public void resync(ItemStack filterStack) {
        this.mods.clear();
        this.mods.addAll(ModFilter.getModList(filterStack));
        this.updateDeleteButtonVisibility();
    }
}

