/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import me.desht.modularrouters.client.gui.IResyncableGui;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.network.messages.OpenGuiMessage;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class AbstractFilterScreen
extends Screen
implements IResyncableGui {
    protected final Component title;
    protected final ItemStack filterStack;
    final MFLocator locator;

    AbstractFilterScreen(ItemStack filterStack, MFLocator locator) {
        super(filterStack.getHoverName());
        this.filterStack = filterStack;
        this.locator = locator;
        this.title = filterStack.getHoverName();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 256 || ClientUtil.isInvKey(keyCode)) && this.closeGUI()) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    boolean closeGUI() {
        ItemStack stack;
        if (this.locator.routerPos() != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)OpenGuiMessage.openModuleInRouter(this.locator), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        if (this.locator.hand() != null && (stack = this.getMinecraft().player.getItemInHand(this.locator.hand())).getItem() instanceof ModuleItem) {
            PacketDistributor.sendToServer((CustomPacketPayload)OpenGuiMessage.openModuleInHand(this.locator), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return false;
    }
}

