/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.util;

import com.direwolf20.justdirethings.util.UsefulFakePlayer;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class FakePlayerUtil {
    protected static void addAttributes(UsefulFakePlayer player, ItemStack itemStack, EquipmentSlot equipmentSlot) {
        AttributeMap attributemap = player.getAttributes();
        if (!itemStack.isEmpty()) {
            itemStack.forEachModifier(equipmentSlot, (p_332602_, p_332603_) -> {
                AttributeInstance attributeinstance = attributemap.getInstance(p_332602_);
                if (attributeinstance != null) {
                    attributeinstance.removeModifier(p_332603_.id());
                    attributeinstance.addTransientModifier(p_332603_);
                }
            });
        }
    }

    protected static void removeAttributes(UsefulFakePlayer player, ItemStack itemStack, EquipmentSlot equipmentSlot) {
        AttributeMap attributemap = player.getAttributes();
        if (!itemStack.isEmpty()) {
            itemStack.forEachModifier(equipmentSlot, (p_330002_, p_330003_) -> {
                AttributeInstance attributeinstance = attributemap.getInstance(p_330002_);
                if (attributeinstance != null) {
                    attributeinstance.removeModifier(p_330003_);
                }
            });
        }
    }

    public static void setupFakePlayerForUse(UsefulFakePlayer player, Vec3 pos, Direction direction, ItemStack toHold, boolean sneaking) {
        double y;
        double x;
        player.getInventory().items.set(player.getInventory().selected, (Object)toHold);
        float xRot = direction == Direction.DOWN ? 90.0f : (direction == Direction.UP ? -90.0f : 0.0f);
        player.setXRot(xRot);
        player.setYRot(direction.toYRot());
        player.setYHeadRot(direction.toYRot());
        Direction.Axis a = direction.getAxis();
        Direction.AxisDirection ad = direction.getAxisDirection();
        double d = a == Direction.Axis.X ? (ad == Direction.AxisDirection.NEGATIVE ? 0.95 : 0.05) : (x = 0.5);
        double d2 = a == Direction.Axis.Y ? (ad == Direction.AxisDirection.NEGATIVE ? 0.95 : 0.05) : (y = 0.5);
        double z = a == Direction.Axis.Z ? (ad == Direction.AxisDirection.NEGATIVE ? 0.95 : 0.05) : 0.5;
        player.setPos(pos.x() + x, pos.y() + y - (double)player.getEyeHeight(), pos.z() + z);
        if (!toHold.isEmpty()) {
            FakePlayerUtil.addAttributes(player, toHold, EquipmentSlot.MAINHAND);
        }
        player.setShiftKeyDown(sneaking);
    }

    public static void setupFakePlayerForUse(UsefulFakePlayer player, BlockPos pos, Direction direction, ItemStack toHold, boolean sneaking) {
        double y;
        double x;
        player.getInventory().items.set(player.getInventory().selected, (Object)toHold);
        float xRot = direction == Direction.DOWN ? 90.0f : (direction == Direction.UP ? -90.0f : 0.0f);
        player.absRotateTo(direction.toYRot(), xRot);
        player.setYHeadRot(direction.toYRot());
        player.yHeadRotO = direction.toYRot();
        Direction.Axis a = direction.getAxis();
        Direction.AxisDirection ad = direction.getAxisDirection();
        double d = a == Direction.Axis.X ? (ad == Direction.AxisDirection.NEGATIVE ? 0.95 : 0.05) : (x = 0.5);
        double d2 = a == Direction.Axis.Y ? (ad == Direction.AxisDirection.NEGATIVE ? 0.95 : 0.05) : (y = 0.5);
        double z = a == Direction.Axis.Z ? (ad == Direction.AxisDirection.NEGATIVE ? 0.95 : 0.05) : 0.5;
        player.absMoveTo((double)pos.getX() + x, (double)pos.getY() + y - (double)player.getEyeHeight(), (double)pos.getZ() + z);
        if (!toHold.isEmpty()) {
            FakePlayerUtil.addAttributes(player, toHold, EquipmentSlot.MAINHAND);
        }
        player.setShiftKeyDown(sneaking);
    }

    public static void setupFakePlayerForUse(UsefulFakePlayer player, BlockPos pos, Direction direction, Vec3 entityPosition, ItemStack toHold, boolean sneaking) {
        double y;
        double x;
        player.getInventory().items.set(player.getInventory().selected, (Object)toHold);
        float xRot = direction == Direction.DOWN ? 90.0f : (direction == Direction.UP ? -90.0f : 0.0f);
        player.setXRot(xRot);
        player.setYRot(direction.toYRot());
        player.setYHeadRot(direction.toYRot());
        Direction.Axis a = direction.getAxis();
        Direction.AxisDirection ad = direction.getAxisDirection();
        double d = a == Direction.Axis.X ? (ad == Direction.AxisDirection.NEGATIVE ? 0.95 : 0.05) : (x = 0.5);
        double d2 = a == Direction.Axis.Y ? (ad == Direction.AxisDirection.NEGATIVE ? 0.95 : 0.05) : (y = 0.5);
        double z = a == Direction.Axis.Z ? (ad == Direction.AxisDirection.NEGATIVE ? 0.95 : 0.05) : 0.5;
        player.setPos((double)pos.getX() + x, (double)pos.getY() + y - (double)player.getEyeHeight(), (double)pos.getZ() + z);
        if (!toHold.isEmpty()) {
            FakePlayerUtil.addAttributes(player, toHold, EquipmentSlot.MAINHAND);
        }
        player.setShiftKeyDown(sneaking);
        Vec3 playerEyePos = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
        Vec3 toEntity = entityPosition.subtract(playerEyePos).normalize();
        float yaw = (float)Math.toDegrees(Math.atan2(toEntity.z, toEntity.x)) - 90.0f;
        float pitch = (float)Math.toDegrees(-Math.atan2(toEntity.y, Math.sqrt(toEntity.x * toEntity.x + toEntity.z * toEntity.z)));
        player.setYRot(yaw);
        player.setYHeadRot(yaw);
        player.setXRot(pitch);
    }

    public static void cleanupFakePlayerFromUse(UsefulFakePlayer player, ItemStack oldStack) {
        if (!oldStack.isEmpty()) {
            FakePlayerUtil.removeAttributes(player, oldStack, EquipmentSlot.MAINHAND);
        }
        player.getInventory().items.set(player.getInventory().selected, (Object)ItemStack.EMPTY);
        if (!player.getInventory().isEmpty()) {
            player.getInventory().dropAll();
        }
        player.setShiftKeyDown(false);
        player.setReach(player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE));
    }

    public static FakePlayerResult clickEntityInDirection(UsefulFakePlayer player, Level world, LivingEntity entity, int clickType, int maxHold) {
        HitResult toUse = FakePlayerUtil.rayTraceEntity(player, world, player.getReach());
        if (toUse == null) {
            return new FakePlayerResult(InteractionResult.FAIL, player.getMainHandItem());
        }
        if (clickType == 2) {
            ItemStack itemstack = player.getMainHandItem();
            if (itemstack.isEmpty()) {
                player.stopUsingItem();
                return new FakePlayerResult(InteractionResult.FAIL, player.getMainHandItem());
            }
            if (!player.isUsingItem()) {
                player.startUsingItem(InteractionHand.MAIN_HAND);
            }
            player.fakeupdateUsingItem(itemstack);
            int holdingFor = player.getTicksUsingItem();
            if (holdingFor >= maxHold) {
                player.releaseUsingItem();
                return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
            }
            return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
        }
        if (clickType == 0) {
            if (FakePlayerUtil.processUseEntity(player, world, (Entity)entity, toUse, InteractionType.INTERACT_AT)) {
                return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
            }
            if (FakePlayerUtil.processUseEntity(player, world, (Entity)entity, null, InteractionType.INTERACT)) {
                return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
            }
        } else if (FakePlayerUtil.processUseEntity(player, world, ((EntityHitResult)toUse).getEntity(), null, InteractionType.ATTACK)) {
            return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
        }
        return new FakePlayerResult(InteractionResult.FAIL, player.getMainHandItem());
    }

    public static FakePlayerResult clickBlockInDirection(UsefulFakePlayer player, Level world, int clickType, int maxHold) {
        InteractionResult type;
        BlockPos blockpos;
        BlockState state;
        HitResult toUse = FakePlayerUtil.rayTraceBlock(player, world, player.getReach());
        if (toUse == null) {
            return new FakePlayerResult(InteractionResult.FAIL, player.getMainHandItem());
        }
        ItemStack itemstack = player.getMainHandItem();
        if (clickType == 2) {
            if (itemstack.isEmpty()) {
                player.stopUsingItem();
                return new FakePlayerResult(InteractionResult.FAIL, player.getMainHandItem());
            }
            if (!player.isUsingItem()) {
                player.startUsingItem(InteractionHand.MAIN_HAND);
            }
            player.fakeupdateUsingItem(itemstack);
            int holdingFor = player.getTicksUsingItem();
            if (holdingFor >= maxHold) {
                player.releaseUsingItem();
                return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
            }
            return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
        }
        if (toUse.getType() == HitResult.Type.BLOCK && !(state = world.getBlockState(blockpos = ((BlockHitResult)toUse).getBlockPos())).isAir()) {
            if (clickType == 0) {
                InteractionResult type2 = player.gameMode.useItemOn((ServerPlayer)player, world, itemstack, InteractionHand.MAIN_HAND, (BlockHitResult)toUse);
                if (type2 == InteractionResult.SUCCESS || type2 == InteractionResult.CONSUME) {
                    return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
                }
            } else {
                player.gameMode.handleBlockBreakAction(blockpos, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, ((BlockHitResult)toUse).getDirection(), player.level().getMaxBuildHeight(), 0);
                return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
            }
        }
        if (toUse.getType() == HitResult.Type.MISS && clickType == 0 && ((type = player.gameMode.useItemOn((ServerPlayer)player, world, itemstack, InteractionHand.MAIN_HAND, (BlockHitResult)toUse)) == InteractionResult.SUCCESS || type == InteractionResult.CONSUME)) {
            return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
        }
        if (!(itemstack.isEmpty() || (type = player.gameMode.useItem((ServerPlayer)player, world, itemstack, InteractionHand.MAIN_HAND)) != InteractionResult.SUCCESS && type != InteractionResult.CONSUME)) {
            return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
        }
        return new FakePlayerResult(InteractionResult.FAIL, player.getMainHandItem());
    }

    public static FakePlayerResult rightClickAirInDirection(UsefulFakePlayer player, Level world, int clickType, int maxHold) {
        InteractionResult type;
        InteractionResult type2;
        BlockPos blockpos;
        BlockState state;
        HitResult toUse = FakePlayerUtil.rayTraceBlock(player, world, player.getReach());
        if (toUse == null) {
            new FakePlayerResult(InteractionResult.FAIL, player.getMainHandItem());
        }
        ItemStack itemstack = player.getMainHandItem();
        if (clickType == 2) {
            if (itemstack.isEmpty()) {
                player.stopUsingItem();
                return new FakePlayerResult(InteractionResult.FAIL, player.getMainHandItem());
            }
            if (!player.isUsingItem()) {
                player.startUsingItem(InteractionHand.MAIN_HAND);
            }
            player.fakeupdateUsingItem(itemstack);
            int holdingFor = player.getTicksUsingItem();
            if (holdingFor >= maxHold) {
                player.releaseUsingItem();
                return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
            }
            return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
        }
        if (!(toUse.getType() != HitResult.Type.BLOCK || (state = world.getBlockState(blockpos = ((BlockHitResult)toUse).getBlockPos())).isAir() || (type2 = player.gameMode.useItemOn((ServerPlayer)player, world, itemstack, InteractionHand.MAIN_HAND, (BlockHitResult)toUse)) != InteractionResult.SUCCESS && type2 != InteractionResult.CONSUME)) {
            return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
        }
        if (toUse.getType() == HitResult.Type.MISS) {
            // empty if block
        }
        if (!(itemstack.isEmpty() || (type = player.gameMode.useItem((ServerPlayer)player, world, itemstack, InteractionHand.MAIN_HAND)) != InteractionResult.SUCCESS && type != InteractionResult.CONSUME)) {
            return new FakePlayerResult(InteractionResult.SUCCESS, player.getMainHandItem());
        }
        return new FakePlayerResult(InteractionResult.FAIL, player.getMainHandItem());
    }

    public static ItemStack leftClickInDirection(UsefulFakePlayer player, Level world, BlockPos pos, Direction side, BlockState sourceState) {
        BlockPos blockpos;
        BlockState state;
        HitResult toUse = FakePlayerUtil.rayTrace(player, world, player.getReach());
        if (toUse == null) {
            return player.getMainHandItem();
        }
        if (toUse.getType() == HitResult.Type.ENTITY) {
            if (FakePlayerUtil.processUseEntity(player, world, ((EntityHitResult)toUse).getEntity(), null, InteractionType.ATTACK)) {
                return player.getMainHandItem();
            }
        } else if (toUse.getType() == HitResult.Type.BLOCK && (state = world.getBlockState(blockpos = ((BlockHitResult)toUse).getBlockPos())) != sourceState && !state.isAir()) {
            player.gameMode.handleBlockBreakAction(blockpos, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, ((BlockHitResult)toUse).getDirection(), player.level().getMaxBuildHeight(), 0);
            return player.getMainHandItem();
        }
        if (toUse == null || toUse.getType() == HitResult.Type.MISS) {
            for (int i = 1; i <= 5; ++i) {
                state = world.getBlockState(pos.relative(side, i));
                if (state == sourceState || state.isAir()) continue;
                player.gameMode.handleBlockBreakAction(pos.relative(side, i), ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, side.getOpposite(), player.level().getMaxBuildHeight(), 0);
                return player.getMainHandItem();
            }
        }
        return player.getMainHandItem();
    }

    public static HitResult traceEntities(UsefulFakePlayer player, Vec3 base, Vec3 target, Level world) {
        Entity pointedEntity = null;
        EntityHitResult result = null;
        Vec3 vec3d3 = null;
        AABB search = new AABB(base.x, base.y, base.z, target.x, target.y, target.z).inflate(0.5, 0.5, 0.5);
        List list = world.getEntities((Entity)player, search, entity -> EntitySelector.NO_SPECTATORS.test(entity) && entity != null && entity.isPickable());
        double d2 = 5.0;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AABB aabb = entity1.getBoundingBox().inflate((double)entity1.getPickRadius());
            Optional optVec = aabb.clip(base, target);
            if (aabb.contains(base)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                vec3d3 = optVec.orElse(base);
                d2 = 0.0;
                continue;
            }
            if (!optVec.isPresent() || !((d3 = base.distanceTo((Vec3)optVec.get())) < d2) && d2 != 0.0) continue;
            if (entity1.getRootVehicle() == player.getRootVehicle() && !entity1.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                vec3d3 = (Vec3)optVec.get();
                continue;
            }
            pointedEntity = entity1;
            vec3d3 = (Vec3)optVec.get();
            d2 = d3;
        }
        if (pointedEntity != null && base.distanceTo(vec3d3) > 5.0) {
            pointedEntity = null;
            result = BlockHitResult.miss(vec3d3, null, (BlockPos)BlockPos.containing(vec3d3));
        }
        if (pointedEntity != null) {
            result = new EntityHitResult(pointedEntity, vec3d3);
        }
        return result;
    }

    public static boolean processUseEntity(UsefulFakePlayer player, Level world, Entity entity, @Nullable HitResult result, InteractionType action) {
        if (entity != null && player.distanceToSqr(entity) < 36.0) {
            if (action == InteractionType.INTERACT) {
                return player.interactOn(entity, InteractionHand.MAIN_HAND) == InteractionResult.SUCCESS;
            }
            if (action == InteractionType.INTERACT_AT) {
                if (CommonHooks.onInteractEntityAt((Player)player, (Entity)entity, (Vec3)result.getLocation(), (InteractionHand)InteractionHand.MAIN_HAND) != null) {
                    return false;
                }
                return entity.interactAt((Player)player, result.getLocation(), InteractionHand.MAIN_HAND) == InteractionResult.SUCCESS;
            }
            if (action == InteractionType.ATTACK) {
                if (entity instanceof ItemEntity || entity instanceof ExperienceOrb || entity instanceof Arrow || entity == player) {
                    return false;
                }
                player.attack(entity);
                return true;
            }
        }
        return false;
    }

    public static HitResult rayTrace(UsefulFakePlayer player, Level level, double reachDist) {
        HitResult toUse;
        Vec3 base = new Vec3(player.getX(), player.getEyeY(), player.getZ());
        Vec3 look = player.getLookAngle();
        Vec3 target = base.add(look.x * reachDist, look.y * reachDist, look.z * reachDist);
        BlockHitResult trace = level.clip(new ClipContext(base, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.SOURCE_ONLY, (Entity)player));
        HitResult traceEntity = FakePlayerUtil.traceEntities(player, base, target, level);
        Object object = toUse = trace == null ? traceEntity : trace;
        if (trace != null && traceEntity != null) {
            double d1 = trace.getLocation().distanceTo(base);
            double d2 = traceEntity.getLocation().distanceTo(base);
            toUse = traceEntity.getType() == HitResult.Type.ENTITY && d1 > d2 ? traceEntity : trace;
        }
        return toUse;
    }

    public static HitResult rayTraceBlock(UsefulFakePlayer player, Level level, double reachDist) {
        Vec3 base = new Vec3(player.getX(), player.getEyeY(), player.getZ());
        Vec3 look = player.getLookAngle();
        Vec3 target = base.add(look.x * reachDist, look.y * reachDist, look.z * reachDist);
        BlockHitResult trace = level.clip(new ClipContext(base, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.SOURCE_ONLY, (Entity)player));
        return trace;
    }

    public static HitResult rayTraceEntity(UsefulFakePlayer player, Level level, double reachDist) {
        Vec3 base = new Vec3(player.getX(), player.getEyeY(), player.getZ());
        Vec3 look = player.getLookAngle();
        Vec3 target = base.add(look.x * reachDist, look.y * reachDist, look.z * reachDist);
        HitResult traceEntity = FakePlayerUtil.traceEntities(player, base, target, level);
        return traceEntity;
    }

    public record FakePlayerResult(InteractionResult interactionResult, ItemStack returnStack) {
    }

    public static enum InteractionType {
        INTERACT,
        INTERACT_AT,
        ATTACK;

    }
}

