/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.common.blockentities.GooSoilBE;
import com.direwolf20.justdirethings.common.blocks.soil.GooSoilBase;
import com.direwolf20.justdirethings.common.containers.ToolSettingContainer;
import com.direwolf20.justdirethings.common.events.BlockEvents;
import com.direwolf20.justdirethings.common.items.armors.basearmors.BaseBoots;
import com.direwolf20.justdirethings.common.items.armors.basearmors.BaseChestplate;
import com.direwolf20.justdirethings.common.items.armors.basearmors.BaseHelmet;
import com.direwolf20.justdirethings.common.items.armors.basearmors.BaseLeggings;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityMethods;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.common.items.interfaces.Helpers;
import com.direwolf20.justdirethings.common.items.interfaces.LeftClickableTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableItem;
import com.direwolf20.justdirethings.common.items.interfaces.ToolRecords;
import com.direwolf20.justdirethings.common.items.tools.utils.GooTier;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.util.MiningCollect;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.NBTHelpers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ToggleableTool
extends ToggleableItem {
    public EnumSet<Ability> getAllAbilities();

    public EnumSet<Ability> getAbilities();

    public Map<Ability, AbilityParams> getAbilityParamsMap();

    default public AbilityParams getAbilityParams(Ability toolAbility) {
        return this.getAbilityParamsMap().getOrDefault((Object)toolAbility, new AbilityParams(-1, -1, -1));
    }

    default public void registerAbility(Ability ability) {
        this.getAllAbilities().add(ability);
    }

    default public void registerAbility(Ability ability, AbilityParams abilityParams) {
        this.getAllAbilities().add(ability);
        this.getAbilityParamsMap().put(ability, abilityParams);
    }

    default public boolean hasAbility(Ability ability) {
        return this.getAbilities().contains((Object)ability);
    }

    default public List<Ability> getUseOnAbilities(ItemStack itemStack) {
        ArrayList<Ability> abilityList = new ArrayList<Ability>();
        for (Ability ability : this.getAbilities()) {
            if (ability.useType != Ability.UseType.USE_ON || !this.canUseAbility(itemStack, ability)) continue;
            abilityList.add(ability);
        }
        return abilityList;
    }

    default public List<Ability> getActiveAbilities(ItemStack itemStack) {
        ArrayList<Ability> abilityList = new ArrayList<Ability>();
        for (Ability ability : this.getAbilities()) {
            if (ability.useType != Ability.UseType.USE && ability.useType != Ability.UseType.USE_COOLDOWN || !this.canUseAbility(itemStack, ability)) continue;
            abilityList.add(ability);
        }
        return abilityList;
    }

    default public List<Ability> getPassiveTickAbilities(ItemStack itemStack) {
        ArrayList<Ability> abilityList = new ArrayList<Ability>();
        for (Ability ability : this.getAbilities()) {
            if (ability.useType != Ability.UseType.PASSIVE_TICK && ability.useType != Ability.UseType.PASSIVE_TICK_COOLDOWN || !this.canUseAbility(itemStack, ability)) continue;
            abilityList.add(ability);
        }
        return abilityList;
    }

    default public List<Ability> getCooldownAbilities() {
        ArrayList<Ability> abilityList = new ArrayList<Ability>();
        for (Ability ability : this.getAbilities()) {
            if (ability.useType != Ability.UseType.USE_COOLDOWN && ability.useType != Ability.UseType.PASSIVE_COOLDOWN && ability.useType != Ability.UseType.PASSIVE_TICK_COOLDOWN) continue;
            abilityList.add(ability);
        }
        return abilityList;
    }

    default public List<Ability> getAllPassiveAbilities() {
        ArrayList<Ability> abilityList = new ArrayList<Ability>();
        for (Ability ability : this.getAbilities()) {
            if (ability.useType != Ability.UseType.PASSIVE && ability.useType != Ability.UseType.PASSIVE_TICK && ability.useType != Ability.UseType.PASSIVE_COOLDOWN && ability.useType != Ability.UseType.PASSIVE_TICK_COOLDOWN) continue;
            abilityList.add(ability);
        }
        return abilityList;
    }

    default public boolean canUseAbility(ItemStack itemStack, Ability toolAbility) {
        return this.hasAbility(toolAbility) && ToggleableTool.hasUpgrade(itemStack, toolAbility) && this.getEnabled(itemStack) && ToggleableTool.getSetting(itemStack, toolAbility.getName());
    }

    default public boolean canUseAbilityAndDurability(ItemStack itemStack, Ability toolAbility) {
        return this.canUseAbility(itemStack, toolAbility) && Helpers.testUseTool(itemStack, toolAbility) >= 0;
    }

    default public boolean canUseAbilityAndDurability(ItemStack itemStack, Ability toolAbility, int multiplier) {
        return this.canUseAbility(itemStack, toolAbility) && Helpers.testUseTool(itemStack, toolAbility, multiplier) >= 0;
    }

    default public void openSettings(Player player) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new ToolSettingContainer(windowId, playerInventory, player), (Component)Component.translatable((String)"")));
    }

    default public boolean hurtEnemyAbility(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        Helpers.damageTool(pStack, pAttacker);
        return true;
    }

    default public Set<BlockPos> getBreakBlockPositions(ItemStack pStack, Level pLevel, BlockPos pPos, LivingEntity pEntityLiving, BlockState pState) {
        HashSet<BlockPos> breakBlockPositions = new HashSet<BlockPos>();
        int maxBreak = (Integer)Config.TOOL_MAX_BREAK_FERRICORE.get();
        Item item = pStack.getItem();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            if (tieredItem.getTier().equals((Object)GooTier.BLAZEGOLD)) {
                maxBreak = (Integer)Config.TOOL_MAX_BREAK_BLAZEGOLD.get();
            } else if (tieredItem.getTier().equals((Object)GooTier.CELESTIGEM)) {
                maxBreak = (Integer)Config.TOOL_MAX_BREAK_CELESTIGEM.get();
            } else if (tieredItem.getTier().equals((Object)GooTier.ECLIPSEALLOY)) {
                maxBreak = (Integer)Config.TOOL_MAX_BREAK_ECLIPSEALLOY.get();
            }
        }
        if (this.canUseAbility(pStack, Ability.OREMINER) && Helpers.oreCondition.test(pState) && pStack.isCorrectToolForDrops(pState)) {
            breakBlockPositions.addAll(Helpers.findLikeBlocks(pLevel, pState, pPos, maxBreak, 2));
        }
        if (this.canUseAbility(pStack, Ability.TREEFELLER) && Helpers.logCondition.test(pState) && pStack.isCorrectToolForDrops(pState)) {
            breakBlockPositions.addAll(Helpers.findLikeBlocks(pLevel, pState, pPos, maxBreak, 2));
        }
        if (this.canUseAbility(pStack, Ability.HAMMER)) {
            breakBlockPositions.addAll(MiningCollect.collect(pEntityLiving, pPos, ToggleableTool.getTargetLookDirection(pEntityLiving), pLevel, ToggleableTool.getToolValue(pStack, Ability.HAMMER.getName()), MiningCollect.SizeMode.AUTO, pStack));
        }
        breakBlockPositions.add(pPos);
        if (this.canUseAbility(pStack, Ability.SKYSWEEPER) && pStack.isCorrectToolForDrops(pState)) {
            HashSet<BlockPos> newPos = new HashSet<BlockPos>();
            for (BlockPos blockPos : breakBlockPositions) {
                BlockState blockState = pLevel.getBlockState(blockPos.above());
                if (!Helpers.fallingBlockCondition.test(blockState)) continue;
                newPos.addAll(Helpers.findBlocksSkyfall(pLevel, blockPos.above(), maxBreak, Direction.UP, maxBreak));
            }
            breakBlockPositions.addAll(newPos);
        }
        return breakBlockPositions;
    }

    default public boolean canInstaBreak(ItemStack pStack, Level pLevel, Set<BlockPos> breakBlockPositions) {
        boolean instaBreak = false;
        if (this.canUseAbility(pStack, Ability.INSTABREAK)) {
            float cumulativeDestroy = 0.0f;
            for (BlockPos pos : breakBlockPositions) {
                BlockState blockState = pLevel.getBlockState(pos);
                float destroySpeedTarget = blockState.getDestroySpeed((BlockGetter)pLevel, pos);
                cumulativeDestroy += destroySpeedTarget;
            }
            int rfCostInstaBreak = ToggleableTool.getInstantRFCost(cumulativeDestroy, pLevel, pStack);
            if (Helpers.testUseTool(pStack, rfCostInstaBreak) > 0) {
                instaBreak = true;
            }
        }
        return instaBreak;
    }

    default public void mineBlocksAbility(ItemStack pStack, Level pLevel, BlockPos pPos, LivingEntity pEntityLiving) {
        BlockState pState = pLevel.getBlockState(pPos);
        Set<BlockPos> breakBlockPositions = this.getBreakBlockPositions(pStack, pLevel, pPos, pEntityLiving, pState);
        boolean instaBreak = this.canInstaBreak(pStack, pLevel, breakBlockPositions);
        BlockEvents.spawnDropsAtPos = pPos;
        for (BlockPos breakPos : breakBlockPositions) {
            if (Helpers.testUseTool(pStack) < 0) break;
            Helpers.breakBlocksNew(pLevel, breakPos, pEntityLiving, pStack, true, instaBreak);
        }
        BlockEvents.spawnDropsAtPos = BlockPos.ZERO;
    }

    public static int getInstantRFCost(float cumulativeDestroy, Level level, ItemStack stack) {
        Holder holder;
        int efficiency;
        int rfCost = Math.max(Ability.INSTABREAK.getFeCost(), Ability.INSTABREAK.getFeCost() * (int)cumulativeDestroy);
        if (level.holder(Enchantments.EFFICIENCY).isPresent() && (efficiency = stack.getEnchantmentLevel(holder = (Holder)level.holder(Enchantments.EFFICIENCY).get())) > 0) {
            float discount = 0.1f * (float)efficiency;
            rfCost -= (int)((float)rfCost * discount);
        }
        return rfCost;
    }

    public static void smelterParticles(ServerLevel level, Set<BlockPos> oreBlocksList) {
        Random random = new Random();
        int iterations = oreBlocksList.size() > 10 ? 1 : 5;
        for (int i = 0; i < iterations; ++i) {
            for (BlockPos pos : oreBlocksList) {
                double d0 = (double)pos.getX() + random.nextDouble();
                double d1 = (double)pos.getY() + random.nextDouble();
                double d2 = (double)pos.getZ() + random.nextDouble();
                level.sendParticles((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void smokerParticles(ServerLevel level, BlockPos itemPos, int stackSize) {
        Random random = new Random();
        int iterations = stackSize < 10 ? 1 : 5;
        for (int i = 0; i < iterations; ++i) {
            double d0 = (double)itemPos.getX() + random.nextDouble();
            double d1 = (double)itemPos.getY() + random.nextDouble();
            double d2 = (double)itemPos.getZ() + random.nextDouble();
            level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void teleportParticles(ServerLevel level, Vec3 pos) {
        Random random = new Random();
        for (int i = 0; i < 5; ++i) {
            double d0 = pos.x() + random.nextDouble();
            double d1 = pos.y() - 0.5 + random.nextDouble();
            double d2 = pos.z() + random.nextDouble();
            level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void teleportParticles(ServerLevel level, BlockPos pos, int iterations) {
        Random random = new Random();
        for (int i = 0; i < iterations; ++i) {
            double d0 = (double)pos.getX() + random.nextDouble();
            double d1 = (double)pos.getY() - 0.5 + random.nextDouble();
            double d2 = (double)pos.getZ() + random.nextDouble();
            level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void teleportParticles(ServerLevel level, Set<BlockPos> oreBlocksList) {
        int iterations = oreBlocksList.size() > 10 ? 1 : 5;
        for (BlockPos pos : oreBlocksList) {
            ToggleableTool.teleportParticles(level, pos, iterations);
        }
    }

    public static int getAnyCooldown(ItemStack itemStack, Ability ability) {
        if (!itemStack.has(JustDireDataComponents.ABILITY_COOLDOWNS)) {
            return -1;
        }
        List abilityCooldowns = (List)itemStack.get(JustDireDataComponents.ABILITY_COOLDOWNS);
        for (ToolRecords.AbilityCooldown abilityCooldown : abilityCooldowns) {
            if (!abilityCooldown.abilityName().equals(ability.getName())) continue;
            return abilityCooldown.cooldownTicks();
        }
        return -1;
    }

    public static int getCooldown(ItemStack itemStack, Ability ability, boolean active) {
        if (!itemStack.has(JustDireDataComponents.ABILITY_COOLDOWNS)) {
            return -1;
        }
        List abilityCooldowns = (List)itemStack.get(JustDireDataComponents.ABILITY_COOLDOWNS);
        for (ToolRecords.AbilityCooldown abilityCooldown : abilityCooldowns) {
            if (!abilityCooldown.abilityName().equals(ability.getName()) || abilityCooldown.isactive() != active) continue;
            return abilityCooldown.cooldownTicks();
        }
        return -1;
    }

    public static void tickCooldowns(Level level, ItemStack itemStack, Player player) {
        if (level.isClientSide || !itemStack.has(JustDireDataComponents.ABILITY_COOLDOWNS)) {
            return;
        }
        HashSet<ToolRecords.AbilityCooldown> cooldownsToRemove = new HashSet<ToolRecords.AbilityCooldown>();
        ArrayList<ToolRecords.AbilityCooldown> abilityCooldowns = new ArrayList<ToolRecords.AbilityCooldown>((Collection)itemStack.getOrDefault(JustDireDataComponents.ABILITY_COOLDOWNS, new ArrayList()));
        for (int i = 0; i < abilityCooldowns.size(); ++i) {
            ToolRecords.AbilityCooldown abilityCooldown = (ToolRecords.AbilityCooldown)abilityCooldowns.get(i);
            int cooldown = abilityCooldown.cooldownTicks();
            boolean active = abilityCooldown.isactive();
            if (--cooldown == 0) {
                if (!active) {
                    cooldownsToRemove.add(abilityCooldown);
                    continue;
                }
                Ability ability = Ability.valueOf(abilityCooldown.abilityName().toUpperCase(Locale.ROOT));
                Item item = itemStack.getItem();
                if (!(item instanceof ToggleableTool)) continue;
                ToggleableTool toggleableTool = (ToggleableTool)item;
                AbilityParams abilityParams = toggleableTool.getAbilityParams(ability);
                ToolRecords.AbilityCooldown updatedCooldown = new ToolRecords.AbilityCooldown(abilityCooldown.abilityName(), abilityParams.cooldown, false);
                abilityCooldowns.set(i, updatedCooldown);
                player.playNotifySound(SoundEvents.CONDUIT_DEACTIVATE, SoundSource.PLAYERS, 1.0f, 1.0f);
                ToggleableTool.cooldownDataClear(itemStack, ability);
                continue;
            }
            ToolRecords.AbilityCooldown updatedCooldown = new ToolRecords.AbilityCooldown(abilityCooldown.abilityName(), cooldown, abilityCooldown.isactive());
            abilityCooldowns.set(i, updatedCooldown);
        }
        for (ToolRecords.AbilityCooldown cooldown : cooldownsToRemove) {
            abilityCooldowns.remove(cooldown);
            player.playNotifySound(SoundEvents.ENDER_EYE_DEATH, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (abilityCooldowns.isEmpty()) {
            itemStack.remove(JustDireDataComponents.ABILITY_COOLDOWNS);
        } else {
            itemStack.set(JustDireDataComponents.ABILITY_COOLDOWNS, abilityCooldowns);
        }
    }

    public static void cooldownDataClear(ItemStack itemStack, Ability ability) {
        if (ability == Ability.STUPEFY) {
            AbilityMethods.clearStupefyTargets(itemStack);
        }
    }

    public static void addCooldown(ItemStack itemStack, Ability ability, int cooldown, boolean active) {
        List abilityCooldowns = itemStack.has(JustDireDataComponents.ABILITY_COOLDOWNS) ? (List)itemStack.get(JustDireDataComponents.ABILITY_COOLDOWNS) : new ArrayList();
        ToolRecords.AbilityCooldown cooldownRecord = new ToolRecords.AbilityCooldown(ability.getName(), cooldown, active);
        abilityCooldowns.add(cooldownRecord);
        itemStack.set(JustDireDataComponents.ABILITY_COOLDOWNS, abilityCooldowns);
    }

    public static boolean isItemEquipped(ItemStack itemStack, Player player) {
        if (itemStack.getItem() instanceof BaseBoots) {
            return ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)player.getItemBySlot(EquipmentSlot.FEET));
        }
        if (itemStack.getItem() instanceof BaseLeggings) {
            return ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)player.getItemBySlot(EquipmentSlot.LEGS));
        }
        if (itemStack.getItem() instanceof BaseChestplate) {
            return ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)player.getItemBySlot(EquipmentSlot.CHEST));
        }
        if (itemStack.getItem() instanceof BaseHelmet) {
            return ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)player.getItemBySlot(EquipmentSlot.HEAD));
        }
        return ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)player.getItemInHand(InteractionHand.MAIN_HAND)) || ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)player.getItemInHand(InteractionHand.OFF_HAND));
    }

    default public boolean useAbility(Level level, Player player, ItemStack itemStack, int keyCode, boolean isMouse) {
        boolean anyRan = false;
        HashSet<Ability> customBindAbilities = new HashSet<Ability>();
        if (itemStack.getItem() instanceof LeftClickableTool) {
            customBindAbilities.addAll(LeftClickableTool.getCustomBindingListFor(itemStack, keyCode, isMouse, player));
        }
        for (Ability ability : this.getActiveAbilities(itemStack)) {
            if (!customBindAbilities.contains((Object)ability) || ability.action == null) continue;
            ability.action.execute(level, player, itemStack);
        }
        if (!level.isClientSide) {
            for (Ability ability : this.getAllPassiveAbilities()) {
                if (!customBindAbilities.contains((Object)ability)) continue;
                if (ability.settingType == Ability.SettingType.CYCLE) {
                    String abilityName = ability.getName();
                    ToggleableTool.cycleSetting(itemStack, abilityName);
                    boolean is_enabled = ToggleableTool.getSetting(itemStack, abilityName);
                    if (is_enabled) {
                        int currentValue = ToggleableTool.getToolValue(itemStack, abilityName);
                        player.displayClientMessage((Component)Component.translatable((String)"justdirethings.ability", (Object[])new Object[]{Component.translatable((String)(ability.getLocalization() + "_" + currentValue)), Component.translatable((String)"justdirethings.enabled")}), true);
                        continue;
                    }
                    player.displayClientMessage((Component)Component.translatable((String)"justdirethings.ability", (Object[])new Object[]{Component.translatable((String)ability.getLocalization()), Component.translatable((String)"justdirethings.disabled")}), true);
                    continue;
                }
                ToggleableTool.toggleSetting(itemStack, ability.getName());
                player.displayClientMessage((Component)Component.translatable((String)"justdirethings.ability", (Object[])new Object[]{Component.translatable((String)ability.getLocalization()), ToggleableTool.getSetting(itemStack, ability.getName()) ? Component.translatable((String)"justdirethings.enabled") : Component.translatable((String)"justdirethings.disabled")}), true);
            }
        }
        return anyRan;
    }

    default public boolean useAbility(Level level, Player player, InteractionHand hand, boolean rightClick) {
        if (player.isShiftKeyDown()) {
            return false;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        boolean anyRan = false;
        HashSet<Ability> leftClickAbilities = new HashSet<Ability>();
        if (itemStack.getItem() instanceof LeftClickableTool) {
            leftClickAbilities.addAll(LeftClickableTool.getLeftClickList(itemStack));
        }
        for (Ability ability : this.getActiveAbilities(itemStack)) {
            if ((!rightClick || LeftClickableTool.getBindingMode(itemStack, ability) != 0) && (rightClick || !leftClickAbilities.contains((Object)ability)) || ability.action == null) continue;
            ability.action.execute(level, player, itemStack);
        }
        return anyRan;
    }

    default public boolean armorTick(Level level, Player player, ItemStack itemStack) {
        boolean anyRan = false;
        for (Ability ability : this.getPassiveTickAbilities(itemStack)) {
            if (!ability.action.execute(level, player, itemStack)) continue;
            anyRan = true;
        }
        ToggleableTool.tickCooldowns(level, itemStack, player);
        return anyRan;
    }

    default public boolean useOnAbility(UseOnContext pContext, ItemStack itemStack, int keyCode, boolean isMouse) {
        if (pContext.getPlayer().isShiftKeyDown()) {
            return false;
        }
        boolean anyRan = false;
        HashSet<Ability> customBindAbilities = new HashSet<Ability>();
        if (itemStack.getItem() instanceof LeftClickableTool) {
            customBindAbilities.addAll(LeftClickableTool.getCustomBindingListFor(itemStack, keyCode, isMouse, pContext.getPlayer()));
        }
        for (Ability ability : this.getUseOnAbilities(itemStack)) {
            if (!customBindAbilities.contains((Object)ability) || ability.useOnAction == null || !ability.useOnAction.execute(pContext)) continue;
            anyRan = true;
        }
        return anyRan;
    }

    default public boolean useOnAbility(UseOnContext pContext, boolean rightClick) {
        if (pContext.getPlayer().isShiftKeyDown()) {
            return false;
        }
        ItemStack itemStack = pContext.getItemInHand();
        boolean anyRan = false;
        HashSet<Ability> leftClickAbilities = new HashSet<Ability>();
        if (itemStack.getItem() instanceof LeftClickableTool) {
            leftClickAbilities.addAll(LeftClickableTool.getLeftClickList(itemStack));
        }
        for (Ability ability : this.getUseOnAbilities(itemStack)) {
            if ((!rightClick || leftClickAbilities.contains((Object)ability)) && (rightClick || !leftClickAbilities.contains((Object)ability)) || ability.useOnAction == null || !ability.useOnAction.execute(pContext)) continue;
            anyRan = true;
        }
        return anyRan;
    }

    default public boolean useAbility(Level level, Player player, InteractionHand hand) {
        return this.useAbility(level, player, hand, true);
    }

    default public boolean useOnAbility(UseOnContext pContext) {
        return this.useOnAbility(pContext, true);
    }

    default public boolean bindDrops(UseOnContext pContext) {
        BlockPos pPos;
        Player player = pContext.getPlayer();
        if (player == null) {
            return false;
        }
        if (!player.isShiftKeyDown()) {
            return false;
        }
        ItemStack pStack = pContext.getItemInHand();
        Item item = pStack.getItem();
        if (!(item instanceof ToggleableTool)) {
            return false;
        }
        ToggleableTool toggleableTool = (ToggleableTool)item;
        if (!toggleableTool.canUseAbility(pStack, Ability.DROPTELEPORT)) {
            return false;
        }
        Level pLevel = pContext.getLevel();
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos = pContext.getClickedPos());
        if (blockEntity == null) {
            return false;
        }
        IItemHandler handler = (IItemHandler)pLevel.getCapability(Capabilities.ItemHandler.BLOCK, pPos, (Object)pContext.getClickedFace());
        if (handler == null) {
            return false;
        }
        if (pContext.getLevel().isClientSide) {
            return true;
        }
        NBTHelpers.BoundInventory boundInventory = ToggleableTool.getBoundInventory(pStack);
        NBTHelpers.BoundInventory newBind = new NBTHelpers.BoundInventory(GlobalPos.of((ResourceKey)pLevel.dimension(), (BlockPos)pPos), pContext.getClickedFace());
        if (boundInventory != null && boundInventory.equals(newBind)) {
            ToggleableTool.removeBoundInventory(pStack);
            pContext.getPlayer().displayClientMessage((Component)Component.translatable((String)"justdirethings.bindremoved"), true);
            player.playNotifySound(SoundEvents.ENDER_EYE_DEATH, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            ToggleableTool.setBoundInventory(pStack, newBind);
            pContext.getPlayer().displayClientMessage((Component)Component.translatable((String)"justdirethings.boundto", (Object[])new Object[]{Component.translatable((String)pLevel.dimension().location().getPath()), "[" + pPos.toShortString() + "]"}), true);
            player.playNotifySound(SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return true;
    }

    default public boolean bindSoil(UseOnContext pContext) {
        boolean bindingSuccess = false;
        if (!pContext.getPlayer().level().isClientSide) {
            ToggleableTool toggleableTool;
            Item item;
            Level pLevel = pContext.getLevel();
            Player player = pContext.getPlayer();
            ItemStack heldItem = pContext.getItemInHand();
            BlockPos clickedPos = pContext.getClickedPos();
            BlockState blockState = pLevel.getBlockState(clickedPos);
            if (blockState.getBlock() instanceof GooSoilBase && (item = heldItem.getItem()) instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbility(heldItem, Ability.DROPTELEPORT)) {
                BlockEntity blockEntity;
                NBTHelpers.BoundInventory boundInventory;
                if (Helpers.testUseTool(heldItem, Ability.DROPTELEPORT) > 0 && (boundInventory = ToggleableTool.getBoundInventory(heldItem)) != null && (blockEntity = pLevel.getBlockEntity(clickedPos)) instanceof GooSoilBE) {
                    GooSoilBE gooSoilBE = (GooSoilBE)blockEntity;
                    gooSoilBE.bindInventory(boundInventory);
                    pContext.getPlayer().displayClientMessage((Component)Component.translatable((String)"justdirethings.boundto", (Object[])new Object[]{Component.translatable((String)boundInventory.globalPos().dimension().location().getPath()), "[" + boundInventory.globalPos().pos().toShortString() + "]"}), true);
                    player.playNotifySound(SoundEvents.ENDER_EYE_DEATH, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Helpers.damageTool(heldItem, (LivingEntity)player, Ability.DROPTELEPORT);
                    bindingSuccess = true;
                }
                if (!bindingSuccess) {
                    pContext.getPlayer().displayClientMessage((Component)Component.translatable((String)"justdirethings.bindfailed").withStyle(ChatFormatting.RED), true);
                    player.playNotifySound(SoundEvents.ANVIL_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        return bindingSuccess;
    }

    @NotNull
    public static Direction getTargetLookDirection(LivingEntity livingEntity) {
        double d;
        Vec3 playerLook = new Vec3(livingEntity.getX(), livingEntity.getY() + (double)livingEntity.getEyeHeight(), livingEntity.getZ());
        Vec3 lookVec = livingEntity.getViewVector(1.0f);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            d = player.blockInteractionRange();
        } else {
            d = 1.0;
        }
        double reach = d;
        Vec3 endLook = playerLook.add(lookVec.x * reach, lookVec.y * reach, lookVec.z * reach);
        BlockHitResult hitResult = livingEntity.level().clip(new ClipContext(playerLook, endLook, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity));
        return hitResult.getDirection().getOpposite();
    }

    public static void toggleSetting(ItemStack stack, String setting) {
        Ability toolAbility = Ability.byName(setting);
        stack.update((Supplier)JustDireDataComponents.ABILITY_TOGGLES.get((Object)toolAbility), (Object)true, val -> val == false);
    }

    public static void cycleSetting(ItemStack stack, String setting) {
        Ability toolAbility = Ability.valueOf(setting.toUpperCase(Locale.ROOT));
        AbilityParams abilityParams = ((ToggleableTool)stack.getItem()).getAbilityParams(toolAbility);
        int currentValue = ToggleableTool.getToolValue(stack, setting);
        int nextValue = Math.min(abilityParams.maxSlider, currentValue + abilityParams.increment);
        if (nextValue == currentValue && ToggleableTool.getSetting(stack, setting)) {
            ToggleableTool.setSetting(stack, setting, false);
            nextValue = abilityParams.minSlider;
        } else if (currentValue == abilityParams.minSlider && !ToggleableTool.getSetting(stack, setting)) {
            nextValue = abilityParams.minSlider;
            ToggleableTool.setSetting(stack, setting, true);
        }
        ToggleableTool.setToolValue(stack, setting, nextValue);
    }

    public static void setBoundInventory(ItemStack stack, NBTHelpers.BoundInventory boundInventory) {
        stack.set(JustDireDataComponents.BOUND_INVENTORY, (Object)boundInventory);
    }

    public static void removeBoundInventory(ItemStack stack) {
        stack.remove(JustDireDataComponents.BOUND_INVENTORY);
    }

    @Nullable
    public static NBTHelpers.BoundInventory getBoundInventory(ItemStack stack) {
        return (NBTHelpers.BoundInventory)stack.getOrDefault(JustDireDataComponents.BOUND_INVENTORY, null);
    }

    public static IItemHandler getBoundHandler(ServerLevel serverLevel, ItemStack stack) {
        NBTHelpers.BoundInventory boundInventory = ToggleableTool.getBoundInventory(stack);
        if (boundInventory != null) {
            return MiscHelpers.getAttachedInventory((Level)serverLevel.getServer().getLevel(boundInventory.globalPos().dimension()), boundInventory.globalPos().pos(), boundInventory.direction());
        }
        return null;
    }

    public static void setSetting(ItemStack stack, String setting, boolean value) {
        Ability toolAbility = Ability.byName(setting);
        stack.set((Supplier)JustDireDataComponents.ABILITY_TOGGLES.get((Object)toolAbility), (Object)value);
    }

    public static boolean getSetting(ItemStack stack, String setting) {
        Ability toolAbility = Ability.byName(setting);
        return !stack.has((Supplier)JustDireDataComponents.ABILITY_TOGGLES.get((Object)toolAbility)) || (Boolean)stack.getOrDefault((Supplier)JustDireDataComponents.ABILITY_TOGGLES.get((Object)toolAbility), (Object)true) != false;
    }

    public static boolean hasUpgrade(ItemStack stack, Ability ability) {
        if (!ability.requiresUpgrade()) {
            return true;
        }
        return (Boolean)stack.getOrDefault((Supplier)JustDireDataComponents.ABILITY_UPGRADE_INSTALLS.get((Object)ability), (Object)false);
    }

    public static void setCustomSetting(ItemStack stack, String setting, int value) {
        Ability toolAbility = Ability.byName(setting);
        stack.set((Supplier)JustDireDataComponents.ABILITY_CUSTOM_SETTINGS.get((Object)toolAbility), (Object)value);
    }

    public static int getCustomSetting(ItemStack stack, String setting) {
        Ability toolAbility = Ability.byName(setting);
        return (Integer)stack.getOrDefault((Supplier)JustDireDataComponents.ABILITY_CUSTOM_SETTINGS.get((Object)toolAbility), (Object)0);
    }

    public static void setToolValue(ItemStack stack, String setting, int value) {
        Ability toolAbility = Ability.byName(setting);
        AbilityParams abilityParams = ((ToggleableTool)stack.getItem()).getAbilityParams(toolAbility);
        int min = abilityParams.minSlider;
        int max = abilityParams.maxSlider;
        int setValue = Math.max(min, Math.min(max, value));
        stack.set((Supplier)JustDireDataComponents.ABILITY_VALUES.get((Object)toolAbility), (Object)setValue);
    }

    public static int getToolValue(ItemStack stack, String setting) {
        Ability toolAbility = Ability.byName(setting);
        AbilityParams abilityParams = ((ToggleableTool)stack.getItem()).getAbilityParams(toolAbility);
        int min = abilityParams.minSlider;
        int max = abilityParams.maxSlider;
        if (stack.has((Supplier)JustDireDataComponents.ABILITY_VALUES.get((Object)toolAbility))) {
            return Math.max(min, Math.min(max, (Integer)stack.getOrDefault((Supplier)JustDireDataComponents.ABILITY_VALUES.get((Object)toolAbility), (Object)abilityParams.defaultValue)));
        }
        return abilityParams.defaultValue;
    }
}

