/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.events;

import com.direwolf20.justdirethings.common.items.TotemOfDeathRecall;
import com.direwolf20.justdirethings.common.items.armors.utils.ArmorTiers;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityMethods;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.common.items.interfaces.Helpers;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.NBTHelpers;
import com.direwolf20.justdirethings.util.UsefulFakePlayer;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.ArmorHurtEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.items.IItemHandler;

public class LivingEntityEvents {
    @SubscribeEvent
    public static void blockDamage(EntityInvulnerabilityCheckEvent e) {
        Entity target = e.getEntity();
        if (target instanceof Player) {
            ToggleableTool toggleableTool;
            Player player = (Player)target;
            ItemStack chestplate = player.getItemBySlot(EquipmentSlot.CHEST);
            Item item = chestplate.getItem();
            if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(chestplate, Ability.ELYTRA) && e.getSource().is(DamageTypes.FLY_INTO_WALL)) {
                e.setInvulnerable(true);
                Helpers.damageTool(chestplate, (LivingEntity)player, Ability.ELYTRA);
                return;
            }
            item = chestplate.getItem();
            if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(chestplate, Ability.LAVAIMMUNITY) && (e.getSource().is(DamageTypes.LAVA) || e.getSource().is(DamageTypes.IN_FIRE) || e.getSource().is(DamageTypes.ON_FIRE))) {
                e.setInvulnerable(true);
                Helpers.damageTool(chestplate, (LivingEntity)player, Ability.LAVAIMMUNITY);
                return;
            }
            item = chestplate.getItem();
            if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).hasAbility(Ability.INVULNERABILITY)) {
                int activeCooldown = ToggleableTool.getCooldown(chestplate, Ability.INVULNERABILITY, true);
                if (activeCooldown == -1) {
                    return;
                }
                player.playNotifySound(SoundEvents.SHIELD_BLOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
                e.setInvulnerable(true);
            }
        }
    }

    @SubscribeEvent
    public static void changeTargets(LivingChangeTargetEvent e) {
        Player player;
        ItemStack helmet;
        Item item;
        LivingEntity source = e.getEntity();
        LivingEntity target = e.getOriginalAboutToBeSetTarget();
        if (target instanceof Player && (item = (helmet = (player = (Player)target).getItemBySlot(EquipmentSlot.HEAD)).getItem()) instanceof ToggleableTool) {
            ToggleableTool toggleableTool = (ToggleableTool)item;
            if (toggleableTool.canUseAbilityAndDurability(helmet, Ability.STUPEFY) && ToggleableTool.getCooldown(helmet, Ability.STUPEFY, true) != -1 && AbilityMethods.getStupefyTargets(helmet).contains(source.getStringUUID())) {
                e.setCanceled(true);
            } else if (toggleableTool.canUseAbilityAndDurability(helmet, Ability.MINDFOG)) {
                double distance = source.position().distanceTo(target.position());
                double defaultRange = source.getAttributes().hasAttribute(Attributes.FOLLOW_RANGE) ? source.getAttribute(Attributes.FOLLOW_RANGE).getValue() : 16.0;
                int denominator = 2;
                Item item2 = helmet.getItem();
                if (item2 instanceof ArmorItem) {
                    ArmorItem armorItem = (ArmorItem)item2;
                    if (armorItem.getMaterial().equals(ArmorTiers.BLAZEGOLD)) {
                        denominator = 3;
                    } else if (armorItem.getMaterial().equals(ArmorTiers.CELESTIGEM)) {
                        denominator = 4;
                    } else if (armorItem.getMaterial().equals(ArmorTiers.ECLIPSEALLOY)) {
                        denominator = 5;
                    }
                }
                if (distance > defaultRange / (double)denominator) {
                    e.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent e) {
        ToggleableTool toggleableTool;
        Player player;
        ItemStack boots;
        Item item;
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player && (item = (boots = (player = (Player)livingEntity).getItemBySlot(EquipmentSlot.FEET)).getItem()) instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(boots, Ability.JUMPBOOST)) {
            Ability.JUMPBOOST.action.execute(player.level(), player, boots);
        }
    }

    @SubscribeEvent
    public static void blockJoin(EntityJoinLevelEvent e) {
        if (e.getEntity() instanceof UsefulFakePlayer) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void LivingFallDamage(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ToggleableTool toggleableTool;
            ServerPlayer player = (ServerPlayer)livingEntity;
            ItemStack heldItem = player.getMainHandItem();
            Item item = heldItem.getItem();
            if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).hasAbility(Ability.AIRBURST)) {
                event.setDistance(0.0f);
                return;
            }
            heldItem = player.getOffhandItem();
            item = heldItem.getItem();
            if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).hasAbility(Ability.AIRBURST)) {
                event.setDistance(0.0f);
                return;
            }
            heldItem = player.getItemBySlot(EquipmentSlot.FEET);
            item = heldItem.getItem();
            if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(heldItem, Ability.NEGATEFALLDAMAGE)) {
                int distance = (int)event.getDistance();
                Helpers.damageTool(heldItem, (LivingEntity)player, Ability.NEGATEFALLDAMAGE, distance);
                event.setDistance(0.0f);
                return;
            }
            Item distance = heldItem.getItem();
            if (distance instanceof ToggleableTool && (toggleableTool = (ToggleableTool)distance).canUseAbilityAndDurability(heldItem, Ability.JUMPBOOST)) {
                int jumpBoost = ToggleableTool.getToolValue(heldItem, Ability.JUMPBOOST.getName());
                event.setDistance(event.getDistance() - (float)jumpBoost);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void LivingDropsEvent(LivingDropsEvent event) {
        Player player;
        ItemStack mainHand;
        Item item;
        DamageSource source = event.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof Player && (item = (mainHand = (player = (Player)entity).getMainHandItem()).getItem()) instanceof ToggleableTool) {
            IItemHandler handler;
            ToggleableTool toggleableTool = (ToggleableTool)item;
            if (toggleableTool.canUseAbility(mainHand, Ability.SMOKER)) {
                for (ItemEntity itemEntity : event.getDrops()) {
                    boolean[] dropSmoked = new boolean[1];
                    Helpers.smokeDrop((ServerLevel)player.level(), itemEntity, mainHand, event.getEntity(), dropSmoked);
                    if (!dropSmoked[0]) continue;
                    ToggleableTool.smokerParticles((ServerLevel)player.level(), itemEntity.blockPosition(), itemEntity.getItem().getCount());
                }
            }
            if (toggleableTool.canUseAbility(mainHand, Ability.DROPTELEPORT) && (handler = ToggleableTool.getBoundHandler((ServerLevel)player.level(), mainHand)) != null) {
                Iterator iterator = event.getDrops().iterator();
                while (iterator.hasNext()) {
                    ItemEntity itemEntity = (ItemEntity)iterator.next();
                    ItemStack stack = itemEntity.getItem();
                    ItemStack leftover = Helpers.teleportDrop(stack, handler, mainHand, player);
                    if (leftover.isEmpty()) {
                        iterator.remove();
                        continue;
                    }
                    itemEntity.setItem(leftover);
                }
                if (event.getDrops().isEmpty()) {
                    ToggleableTool.teleportParticles((ServerLevel)player.level(), event.getEntity().getPosition(0.0f));
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onArmorDamage(ArmorHurtEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Map armorEntries = event.getArmorMap();
        for (Map.Entry entry : armorEntries.entrySet()) {
            if (entry.getKey() == EquipmentSlot.MAINHAND || entry.getKey() == EquipmentSlot.OFFHAND) continue;
            ItemStack armorItemStack = ((ArmorHurtEvent.ArmorEntry)entry.getValue()).armorItemStack;
            if (armorItemStack.getItem() instanceof PoweredItem) {
                ((ArmorHurtEvent.ArmorEntry)entry.getValue()).newDamage = ((ArmorHurtEvent.ArmorEntry)entry.getValue()).originalDamage * 100.0f;
                continue;
            }
            Item item = armorItemStack.getItem();
            if (!(item instanceof ToggleableTool)) continue;
            ToggleableTool toggleableTool = (ToggleableTool)item;
            item = event.getEntity();
            if (!(item instanceof Player)) continue;
            Player player = (Player)item;
            float newDmg = (float)armorItemStack.getDamageValue() + ((ArmorHurtEvent.ArmorEntry)entry.getValue()).originalDamage;
            if (!(newDmg >= (float)armorItemStack.getMaxDamage())) continue;
            EnumSet<Ability> abilities = toggleableTool.getAbilities();
            for (Ability ability : abilities) {
                if (!ToggleableTool.hasUpgrade(armorItemStack, ability) || !ability.requiresUpgrade()) continue;
                ItemStack upgradeStack = new ItemStack(ability.getUpgradeItem());
                player.drop(upgradeStack, true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ToggleableTool toggleableTool;
            Item item;
            ServerPlayer player = (ServerPlayer)livingEntity;
            ItemStack chestplate = player.getItemBySlot(EquipmentSlot.CHEST);
            int currentCooldown = ToggleableTool.getAnyCooldown(chestplate, Ability.DEATHPROTECTION);
            if (currentCooldown == -1 && (item = chestplate.getItem()) instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(chestplate, Ability.DEATHPROTECTION)) {
                AbilityParams abilityParams = toggleableTool.getAbilityParams(Ability.DEATHPROTECTION);
                ToggleableTool.addCooldown(chestplate, Ability.DEATHPROTECTION, abilityParams.cooldown, false);
                player.playNotifySound(SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                Helpers.damageTool(chestplate, (LivingEntity)player, Ability.DEATHPROTECTION);
                player.setHealth(10.0f);
                event.setCanceled(true);
                return;
            }
            ItemStack totemStack = LivingEntityEvents.findTotem(player);
            if (!totemStack.isEmpty()) {
                CompoundTag deathData = new CompoundTag();
                deathData.put("direDeathData", (Tag)NBTHelpers.globalVec3ToNBT((ResourceKey<Level>)player.level().dimension(), player.position()));
                player.setData(Registration.DEATH_DATA, (Object)deathData);
                totemStack.shrink(1);
            }
        }
    }

    private static ItemStack findTotem(ServerPlayer player) {
        for (ItemStack itemStack : player.getInventory().items) {
            if (itemStack.getItem() != Registration.TotemOfDeathRecall.get() || TotemOfDeathRecall.getBoundTo(itemStack) != null) continue;
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        ServerPlayer oldPlayer = (ServerPlayer)event.getOriginal();
        if (oldPlayer.level().isClientSide || !event.isWasDeath()) {
            return;
        }
        ServerPlayer newPlayer = (ServerPlayer)event.getEntity();
        CompoundTag deathData = (CompoundTag)oldPlayer.getData(Registration.DEATH_DATA);
        if (deathData.contains("direDeathData")) {
            NBTHelpers.GlobalVec3 boundTo = NBTHelpers.nbtToGlobalVec3(deathData.getCompound("direDeathData"));
            ItemStack totemStack = new ItemStack((ItemLike)Registration.TotemOfDeathRecall.get());
            TotemOfDeathRecall.setBoundTo(totemStack, boundTo);
            newPlayer.getInventory().add(totemStack);
        }
    }
}

