/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities.basebe;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.common.entities.CreatureCatcherEntity;
import com.direwolf20.justdirethings.common.items.CreatureCatcher;
import com.direwolf20.justdirethings.util.ItemStackKey;
import com.direwolf20.justdirethings.util.interfacehelpers.FilterData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface FilterableBE {
    public FilterBasicHandler getFilterHandler();

    public FilterData getFilterData();

    default public void setFilterData(FilterData filterData) {
        FilterData existingData = this.getFilterData();
        existingData = filterData;
    }

    public BlockEntity getBlockEntity();

    default public void saveFilterSettings(CompoundTag tag) {
        tag.putBoolean("allowlist", this.getFilterData().allowlist);
        tag.putBoolean("compareNBT", this.getFilterData().compareNBT);
        tag.putInt("blockitemfilter", this.getFilterData().blockItemFilter);
    }

    default public void loadFilterSettings(CompoundTag tag) {
        this.getFilterData().allowlist = tag.getBoolean("allowlist");
        this.getFilterData().compareNBT = tag.getBoolean("compareNBT");
        int blockItemFilter = tag.getInt("blockitemfilter");
        if (blockItemFilter != -1 && this.getFilterData().blockItemFilter != -1) {
            this.getFilterData().blockItemFilter = blockItemFilter;
        }
    }

    default public void setFilterSettings(FilterData filterData) {
        this.getFilterData().allowlist = filterData.allowlist;
        this.getFilterData().compareNBT = filterData.compareNBT;
        this.getFilterData().blockItemFilter = filterData.blockItemFilter;
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BaseMachineBE) {
            BaseMachineBE baseMachineBE = (BaseMachineBE)blockEntity;
            baseMachineBE.markDirtyClient();
        }
    }

    default public boolean isStackValidFilter(ItemStack testStack) {
        ItemStackKey key = new ItemStackKey(testStack, this.getFilterData().compareNBT);
        if (this.getFilterData().filterCache.containsKey(key)) {
            return this.getFilterData().filterCache.get(key);
        }
        FilterBasicHandler filteredItems = this.getFilterHandler();
        for (int i = 0; i < filteredItems.getSlots(); ++i) {
            ItemStack stack = filteredItems.getStackInSlot(i);
            if (stack.isEmpty() || !key.equals(new ItemStackKey(stack, this.getFilterData().compareNBT))) continue;
            this.getFilterData().filterCache.put(key, this.getFilterData().allowlist);
            return this.getFilterData().allowlist;
        }
        this.getFilterData().filterCache.put(key, !this.getFilterData().allowlist);
        return !this.getFilterData().allowlist;
    }

    default public boolean isEntityValidFilter(Entity entity, Level level) {
        if (this.getFilterData().entityCache.containsKey(entity)) {
            return this.getFilterData().entityCache.get(entity);
        }
        FilterBasicHandler filteredItems = this.getFilterHandler();
        for (int i = 0; i < filteredItems.getSlots(); ++i) {
            Item entityEgg;
            ItemStack stack = filteredItems.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof SpawnEggItem) {
                entityEgg = SpawnEggItem.byId((EntityType)entity.getType());
                if (entityEgg == null || !stack.is(entityEgg)) continue;
                this.getFilterData().entityCache.put(entity, this.getFilterData().allowlist);
                return this.getFilterData().allowlist;
            }
            entityEgg = stack.getItem();
            if (!(entityEgg instanceof CreatureCatcher)) continue;
            CreatureCatcher creatureCatcher = (CreatureCatcher)entityEgg;
            Mob mob = CreatureCatcherEntity.getEntityFromItemStack(stack, level);
            if (mob == null || !entity.getType().equals(mob.getType())) continue;
            if (this.getFilterData().compareNBT) {
                CompoundTag targetTag;
                CompoundTag filterTag = this.getNormalizedTag((Entity)mob);
                if (!filterTag.equals((Object)(targetTag = this.getNormalizedTag(entity)))) continue;
                this.getFilterData().entityCache.put(entity, this.getFilterData().allowlist);
                return this.getFilterData().allowlist;
            }
            this.getFilterData().entityCache.put(entity, this.getFilterData().allowlist);
            return this.getFilterData().allowlist;
        }
        this.getFilterData().entityCache.put(entity, !this.getFilterData().allowlist);
        return !this.getFilterData().allowlist;
    }

    default public CompoundTag getNormalizedTag(Entity entity) {
        CompoundTag tag = new CompoundTag();
        entity.save(tag);
        tag.remove("AbsorptionAmount");
        tag.remove("Age");
        tag.remove("Air");
        tag.remove("ArmorDropChances");
        tag.remove("ArmorItems");
        tag.remove("Brain");
        tag.remove("CanPickUpLoot");
        tag.remove("DeathTime");
        tag.remove("FallDistance");
        tag.remove("FallFlying");
        tag.remove("Fire");
        tag.remove("ForcedAge");
        tag.remove("HandDropChances");
        tag.remove("HandItems");
        tag.remove("HurtByTimestamp");
        tag.remove("HurtTime");
        tag.remove("InLove");
        tag.remove("Invulnerable");
        tag.remove("LeftHanded");
        tag.remove("Motion");
        tag.remove("OnGround");
        tag.remove("PersistenceRequired");
        tag.remove("PortalCooldown");
        tag.remove("Pos");
        tag.remove("Rotation");
        tag.remove("UUID");
        tag.remove("attributes");
        tag.remove("id");
        tag.remove("NoAI");
        tag.remove("Silent");
        tag.remove("Glowing");
        tag.remove("Tags");
        tag.remove("Passengers");
        tag.remove("Leashed");
        tag.remove("Leash");
        tag.remove("CustomName");
        tag.remove("FireTicks");
        tag.remove("Dimension");
        tag.remove("HasVisualFire");
        tag.remove("ActiveEffects");
        tag.remove("FromBucket");
        tag.remove("neoforge:spawn_type");
        return tag;
    }

    default public boolean isStackValidFilter(LiquidBlock liquidBlock) {
        ItemStack testStack = new ItemStack((ItemLike)liquidBlock.fluid.getBucket());
        ItemStackKey key = new ItemStackKey(testStack, this.getFilterData().compareNBT);
        if (this.getFilterData().filterCache.containsKey(key)) {
            return this.getFilterData().filterCache.get(key);
        }
        FilterBasicHandler filteredItems = this.getFilterHandler();
        for (int i = 0; i < filteredItems.getSlots(); ++i) {
            ItemStack stack = filteredItems.getStackInSlot(i);
            if (stack.isEmpty() || !key.equals(new ItemStackKey(stack, this.getFilterData().compareNBT))) continue;
            this.getFilterData().filterCache.put(key, this.getFilterData().allowlist);
            return this.getFilterData().allowlist;
        }
        this.getFilterData().filterCache.put(key, !this.getFilterData().allowlist);
        return !this.getFilterData().allowlist;
    }
}

