/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.config.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.platform.Platform;
import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.config.ConfigExtensions;
import io.github.jamalam360.jamlib.config.ConfigManager;
import io.github.jamalam360.jamlib.config.HiddenInGui;
import io.github.jamalam360.jamlib.config.Slider;
import io.github.jamalam360.jamlib.config.WithinRange;
import io.github.jamalam360.jamlib.config.gui.ButtonWithTextureWidget;
import io.github.jamalam360.jamlib.config.gui.SelectionList;
import io.github.jamalam360.jamlib.config.gui.SelectionListEntry;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ConfigScreen<T>
extends Screen {
    protected final ConfigManager<T> manager;
    private final Screen parent;
    private final List<GuiEntry> entries;
    private final List<GuiEntry> changedFields;
    private Button doneButton;

    public ConfigScreen(ConfigManager<T> manager, Screen parent) {
        super(ConfigScreen.createTitle(manager));
        this.manager = manager;
        this.parent = parent;
        this.entries = new ArrayList<GuiEntry>();
        this.changedFields = new ArrayList<GuiEntry>();
    }

    protected static String createTranslationKey(String modId, String configName, String path) {
        if (modId.equals(configName)) {
            return "config." + modId + "." + path;
        }
        return "config." + modId + "." + configName + "." + path;
    }

    protected static Component createTitle(ConfigManager<?> manager) {
        String translationKey = ConfigScreen.createTranslationKey(manager.getModId(), manager.getConfigName(), "title");
        if (I18n.exists((String)translationKey)) {
            return Component.translatable((String)translationKey);
        }
        return Component.literal((String)Platform.getMod((String)manager.getModId()).getName());
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            this.manager.reloadFromDisk();
            Objects.requireNonNull(this.minecraft).setScreen(this.parent);
        }).pos(this.width / 2 - 154, this.height - 28).size(150, 20).build());
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            if (!this.changedFields.isEmpty()) {
                this.manager.save();
            }
            Objects.requireNonNull(this.minecraft).setScreen(this.parent);
        }).pos(this.width / 2 + 4, this.height - 28).size(150, 20).build());
        this.addRenderableWidget((GuiEventListener)new ButtonWithTextureWidget(7, 7, 20, 20, Component.translatable((String)"config.jamlib.edit_manually"), ResourceLocation.withDefaultNamespace((String)"textures/item/writable_book.png"), 16, 16, button -> {
            if (!this.changedFields.isEmpty()) {
                this.manager.save();
            }
            Util.getPlatform().openFile(Platform.getConfigFolder().resolve(this.manager.getConfigName() + ".json5").toFile());
            Objects.requireNonNull(this.minecraft).setScreen(this.parent);
        }));
        ConfigEntryList list = new ConfigEntryList(this.minecraft, this.width, this.height - 64, 32, 25);
        if (this.entries.isEmpty()) {
            for (Field field : this.manager.getConfigClass().getDeclaredFields()) {
                if (field.isAnnotationPresent(HiddenInGui.class)) continue;
                this.entries.add(new GuiEntry(this.manager.getModId(), this.manager.getConfigName(), field));
            }
        }
        for (GuiEntry entry : this.entries) {
            list.addEntry(entry);
        }
        this.addRenderableWidget((GuiEventListener)list);
        T entry = this.manager.get();
        if (entry instanceof ConfigExtensions) {
            ConfigExtensions ext = (ConfigExtensions)entry;
            List<ConfigExtensions.Link> links = ext.getLinks();
            for (int i = 0; i < links.size(); ++i) {
                ConfigExtensions.Link link = links.get(i);
                this.addRenderableWidget((GuiEventListener)new ButtonWithTextureWidget(this.width - 30 - 28 * i, 5, 20, 20, (MutableComponent)link.getTooltip(), link.getTexture(), 16, 16, button -> {
                    try {
                        Util.getPlatform().openUri(link.getUrl().toURI());
                    }
                    catch (Exception e) {
                        JamLib.LOGGER.error("Failed to open link", (Throwable)e);
                    }
                }));
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(Minecraft.getInstance().font, this.title, this.width / 2, 12, 0xFFFFFF);
    }

    private boolean canExit() {
        return this.entries.stream().allMatch(GuiEntry::isValid);
    }

    public void tick() {
        super.tick();
        boolean canExit = this.canExit();
        if (this.doneButton.active != canExit) {
            this.doneButton.active = canExit;
        }
    }

    private class ConfigEntryList
    extends SelectionList {
        public ConfigEntryList(Minecraft minecraft, int width, int height, int y, int itemHeight) {
            super(minecraft, width, height, y, itemHeight);
        }

        protected void addEntry(GuiEntry entry) {
            this.addEntry((AbstractSelectionList.Entry)new SelectionListEntry(entry.getName(), entry.getTooltip(), entry.createWidget(ConfigScreen.this.manager, this.width)));
        }
    }

    private class GuiEntry {
        private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");
        private final Type type;
        private final String translationKey;
        private final List<FormattedCharSequence> tooltip;
        private final Field field;
        private final Object initialValue;
        private boolean isValid = true;

        protected GuiEntry(String modId, String configName, Field field) {
            this.type = Type.fromField(field);
            this.field = field;
            this.initialValue = this.getFieldValue(ConfigManager.MANAGERS.get(configName));
            this.translationKey = ConfigScreen.createTranslationKey(modId, configName, field.getName());
            String tooltipTranslationKey = this.translationKey + ".tooltip";
            this.tooltip = I18n.exists((String)tooltipTranslationKey) ? Minecraft.getInstance().font.split((FormattedText)Component.translatable((String)tooltipTranslationKey), 200) : null;
        }

        private static Component getBooleanComponent(boolean v) {
            return Component.literal((String)(v ? "Yes" : "No")).withStyle(s -> s.withColor(v ? ChatFormatting.GREEN : ChatFormatting.RED));
        }

        private static Component getEnumComponent(ConfigManager<?> manager, Field field, Enum<?> enumValue) {
            String translationKey = ConfigScreen.createTranslationKey(manager.getModId(), manager.getConfigName(), field.getName() + "." + enumValue.name().toLowerCase());
            if (I18n.exists((String)translationKey)) {
                return Component.translatable((String)translationKey);
            }
            return Component.literal((String)enumValue.name());
        }

        protected List<AbstractWidget> createWidget(ConfigManager<T> manager, int width) {
            ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
            TextureWidget validationIcon = new TextureWidget(width - 212, 0, 20, 20, JamLib.id("textures/gui/validation_warning.png"));
            validationIcon.setTooltip(Tooltip.create((Component)Component.translatable((String)"config.jamlib.requires_restart_tooltip")));
            validationIcon.visible = false;
            widgets.add(validationIcon);
            switch (this.type.ordinal()) {
                case 0: {
                    widgets.add((AbstractWidget)Button.builder((Component)GuiEntry.getBooleanComponent(Boolean.TRUE.equals(this.getFieldValue(manager))), button -> {
                        this.setFieldValue(manager, !Boolean.TRUE.equals(this.getFieldValue(manager)));
                        button.setMessage(this.handleUpdatesOnChange(manager, widgets, ConfigScreen.this.changedFields));
                    }).pos(width - 188, 0).size(150, 20).build());
                    break;
                }
                case 1: {
                    if (this.field.isAnnotationPresent(Slider.class)) {
                        widgets.add(this.createSlider(widgets));
                        break;
                    }
                    widgets.add((AbstractWidget)this.createEditBox(widgets, Pattern.compile("^-?\\d*\\.?\\d*$"), Float::parseFloat));
                    break;
                }
                case 2: {
                    if (this.field.isAnnotationPresent(Slider.class)) {
                        widgets.add(this.createSlider(widgets));
                        break;
                    }
                    widgets.add((AbstractWidget)this.createEditBox(widgets, Pattern.compile("^-?\\d*\\.?\\d*$"), Double::parseDouble));
                    break;
                }
                case 3: {
                    if (this.field.isAnnotationPresent(Slider.class)) {
                        widgets.add(this.createSlider(widgets));
                        break;
                    }
                    widgets.add((AbstractWidget)this.createEditBox(widgets, Pattern.compile("^-?\\d*$"), Integer::parseInt));
                    break;
                }
                case 4: {
                    if (this.field.isAnnotationPresent(Slider.class)) {
                        widgets.add(this.createSlider(widgets));
                        break;
                    }
                    widgets.add((AbstractWidget)this.createEditBox(widgets, Pattern.compile("^-?\\d*$"), Long::parseLong));
                    break;
                }
                case 5: {
                    widgets.add((AbstractWidget)this.createEditBox(widgets, null, Function.identity()));
                    break;
                }
                case 6: {
                    EnumButton button2 = new EnumButton(width - 188, 0, 150, 20, CommonComponents.EMPTY.copy(), this.field.getType(), b -> {
                        this.setFieldValue(manager, b.getValue());
                        b.setMessage(this.handleUpdatesOnChange(manager, widgets, ConfigScreen.this.changedFields));
                    });
                    button2.setValue(Objects.requireNonNull((Enum)this.getFieldValue(manager)));
                    button2.setMessage(GuiEntry.getEnumComponent(manager, this.field, button2.getValue()));
                    widgets.add((AbstractWidget)button2);
                    break;
                }
            }
            widgets.add((AbstractWidget)new ButtonWithTextureWidget(width - 30, 0, 20, 20, Component.translatable((String)"config.jamlib.reset"), JamLib.id("textures/gui/reset.png"), 16, 16, button -> {
                this.setFieldValue(manager, this.initialValue);
                ((AbstractWidget)widgets.get(1)).setMessage(this.handleUpdatesOnChange(manager, widgets, ConfigScreen.this.changedFields));
                Object patt0$temp = widgets.get(1);
                if (patt0$temp instanceof EditBox) {
                    EditBox box = (EditBox)patt0$temp;
                    box.setValue(String.valueOf(this.initialValue));
                } else {
                    Object patt1$temp = widgets.get(1);
                    if (patt1$temp instanceof SliderButton) {
                        SliderButton slider = (SliderButton)((Object)((Object)patt1$temp));
                        slider.setValue(((Number)this.initialValue).doubleValue());
                    }
                }
            }));
            this.validate(manager, widgets);
            return widgets;
        }

        private <V> EditBox createEditBox(List<AbstractWidget> widgets, Pattern filter, Function<String, V> parse) {
            EditBox box = new EditBox(Minecraft.getInstance().font, ConfigScreen.this.width - 188, 0, 150, 20, CommonComponents.EMPTY);
            V value = this.getFieldValue(ConfigScreen.this.manager);
            if (value instanceof Number) {
                Number number = (Number)value;
                box.setValue(DECIMAL_FORMAT.format(number.doubleValue()));
            } else if (value instanceof String) {
                String string = (String)value;
                box.setValue(string);
            } else if (value != null) {
                box.setValue(value.toString());
            } else {
                box.setValue("");
            }
            if (filter != null) {
                box.setFilter(s -> filter.matcher((CharSequence)s).matches());
            }
            box.setResponder(s -> {
                try {
                    this.setFieldValue(ConfigScreen.this.manager, parse.apply((String)s));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                box.setMessage(this.handleUpdatesOnChange(ConfigScreen.this.manager, widgets, ConfigScreen.this.changedFields));
            });
            return box;
        }

        private SliderButton createSlider(List<AbstractWidget> widgets) {
            WithinRange rangeAnnot = this.field.getAnnotation(WithinRange.class);
            Number current = (Number)this.getFieldValue(ConfigScreen.this.manager);
            if (current == null) {
                current = rangeAnnot.min();
            }
            SliderButton slider = new SliderButton(ConfigScreen.this.width - 188, 0, 150, 20, CommonComponents.EMPTY, rangeAnnot.min(), rangeAnnot.max(), current.doubleValue(), s -> {
                this.setFieldValue(ConfigScreen.this.manager, s.getValue());
                s.setMessage(this.handleUpdatesOnChange(ConfigScreen.this.manager, widgets, ConfigScreen.this.changedFields));
            });
            slider.setMessage((Component)Component.literal((String)DECIMAL_FORMAT.format(slider.getValue())));
            return slider;
        }

        private Component handleUpdatesOnChange(ConfigManager<T> manager, List<AbstractWidget> widgets, List<GuiEntry> changedFields) {
            Object newValue = this.getFieldValue(manager);
            if (changedFields.contains(this) && this.initialValue.equals(newValue)) {
                changedFields.remove(this);
            } else if (!changedFields.contains(this) && !this.initialValue.equals(newValue)) {
                changedFields.add(this);
            }
            this.validate(manager, widgets);
            Class<?> c = this.field.getType();
            if (c == Boolean.TYPE) {
                return GuiEntry.getBooleanComponent(Boolean.TRUE.equals(newValue));
            }
            if (newValue instanceof Number) {
                Number number = (Number)newValue;
                return Component.literal((String)DECIMAL_FORMAT.format(number.doubleValue()));
            }
            if (newValue instanceof Enum) {
                Enum enumValue = (Enum)newValue;
                return GuiEntry.getEnumComponent(manager, this.field, enumValue);
            }
            if (newValue instanceof Boolean) {
                Boolean boolValue = (Boolean)newValue;
                return GuiEntry.getBooleanComponent(boolValue);
            }
            if (newValue != null) {
                return Component.literal((String)newValue.toString());
            }
            return Component.literal((String)"");
        }

        private void validate(ConfigManager<T> manager, List<AbstractWidget> widgets) {
            Object newValue = this.getFieldValue(manager);
            Object t = manager.get();
            if (t instanceof ConfigExtensions) {
                ConfigExtensions ext = (ConfigExtensions)t;
                List<ConfigExtensions.ValidationError> errors = ext.getValidationErrors(manager, new ConfigExtensions.FieldValidationInfo(this.field.getName(), newValue, this.initialValue, this.field));
                errors.sort((o1, o2) -> o2.type().ordinal() - o1.type().ordinal());
                TextureWidget validationIcon = (TextureWidget)widgets.getFirst();
                if (!errors.isEmpty()) {
                    this.isValid = errors.getFirst().type() != ConfigExtensions.ValidationError.Type.ERROR;
                    validationIcon.visible = true;
                    validationIcon.setTexture(errors.getFirst().type().getTexture());
                    validationIcon.setTooltip(Tooltip.create((Component)errors.getFirst().message()));
                } else {
                    this.isValid = true;
                    validationIcon.visible = false;
                }
            }
        }

        protected Component getName() {
            return Component.translatable((String)this.translationKey);
        }

        protected List<FormattedCharSequence> getTooltip() {
            return this.tooltip;
        }

        protected boolean isValid() {
            return this.isValid;
        }

        @Nullable
        private <V> V getFieldValue(ConfigManager<T> manager) {
            try {
                return (V)this.field.get(manager.get());
            }
            catch (IllegalAccessException e) {
                JamLib.LOGGER.error("Failed to access field for config {}", (Object)manager.getConfigName(), (Object)e);
                return null;
            }
        }

        private <V> void setFieldValue(ConfigManager<T> manager, V v) {
            Object realValue = v;
            if (v instanceof Number) {
                Number n = (Number)v;
                Class<?> c = this.field.getType();
                if (c == Double.TYPE || c == Double.class) {
                    realValue = n.doubleValue();
                } else if (c == Float.TYPE || c == Float.class) {
                    realValue = Float.valueOf(n.floatValue());
                } else if (c == Integer.TYPE || c == Integer.class) {
                    realValue = n.intValue();
                } else if (c == Long.TYPE || c == Long.class) {
                    realValue = n.longValue();
                }
            }
            try {
                this.field.set(manager.get(), realValue);
            }
            catch (IllegalAccessException e) {
                JamLib.LOGGER.error("Failed to access field for config {}", (Object)manager.getConfigName(), (Object)e);
            }
        }

        private static enum Type {
            BOOLEAN,
            FLOAT,
            DOUBLE,
            INTEGER,
            LONG,
            STRING,
            ENUM,
            LIST;


            private static Type fromField(Field field) {
                Class<?> c = field.getType();
                if (c == Boolean.TYPE) {
                    return BOOLEAN;
                }
                if (c == Float.TYPE) {
                    return FLOAT;
                }
                if (c == Double.TYPE) {
                    return DOUBLE;
                }
                if (c == Integer.TYPE) {
                    return INTEGER;
                }
                if (c == Long.TYPE) {
                    return LONG;
                }
                if (c == String.class) {
                    return STRING;
                }
                if (c.isEnum()) {
                    return ENUM;
                }
                if (List.class.isAssignableFrom(c)) {
                    return LIST;
                }
                throw new IllegalArgumentException("Unsupported config type: " + String.valueOf(c));
            }
        }
    }

    private static class EnumButton<E extends Enum<E>>
    extends Button {
        private final Class<E> enumClass;
        private final Consumer<EnumButton<E>> onChange;
        private int index;

        protected EnumButton(int x, int y, int width, int height, MutableComponent description, Class<Enum<?>> enumClass, Consumer<EnumButton<E>> onChange) {
            super(x, y, width, height, CommonComponents.EMPTY, b -> {
                ((EnumButton)b).setIndex((((EnumButton)b).index + 1) % ((Enum[])((EnumButton)b).enumClass.getEnumConstants()).length);
                ((EnumButton)b).onChange.accept((EnumButton)b);
            }, s -> description);
            this.enumClass = enumClass;
            this.onChange = onChange;
            this.index = 0;
        }

        private E getValue() {
            return (E)((Enum[])this.enumClass.getEnumConstants())[this.index];
        }

        private void setValue(E value) {
            this.setIndex(((Enum)value).ordinal());
        }

        private void setIndex(int index) {
            this.index = index;
        }
    }

    private static class SliderButton
    extends AbstractWidget {
        private static final ResourceLocation SLIDER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider");
        private static final ResourceLocation HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_highlighted");
        private static final ResourceLocation SLIDER_HANDLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle");
        private static final ResourceLocation SLIDER_HANDLE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle_highlighted");
        private final double min;
        private final double max;
        private final Consumer<SliderButton> onChange;
        protected double value;
        private boolean canChangeValue;

        public SliderButton(int x, int y, int width, int height, Component message, double min, double max, double current, Consumer<SliderButton> onChange) {
            super(x, y, width, height, message);
            this.value = current;
            this.min = min;
            this.max = max;
            this.onChange = onChange;
        }

        private ResourceLocation getSprite() {
            return this.isFocused() && !this.canChangeValue ? HIGHLIGHTED_SPRITE : SLIDER_SPRITE;
        }

        private ResourceLocation getHandleSprite() {
            return !this.isHovered && !this.canChangeValue ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
        }

        @NotNull
        protected MutableComponent createNarrationMessage() {
            return Component.translatable((String)"gui.narrate.slider", (Object[])new Object[]{this.getMessage()});
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
            if (this.active) {
                if (this.isFocused()) {
                    narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.slider.usage.focused"));
                } else {
                    narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.slider.usage.hovered"));
                }
            }
        }

        public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            Minecraft minecraft = Minecraft.getInstance();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.blitSprite(this.getSprite(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            double position = this.value / (this.max - this.min);
            double handleX = (double)this.getX() + position * (double)(this.getWidth() - 8);
            guiGraphics.blitSprite(this.getHandleSprite(), (int)handleX, this.getY(), 8, this.getHeight());
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            int k = this.active ? 0xFFFFFF : 0xA0A0A0;
            this.renderScrollingString(guiGraphics, minecraft.font, 2, k | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        }

        public void onClick(double d, double e) {
            this.setValueFromMouse(d);
        }

        public void setFocused(boolean bl) {
            super.setFocused(bl);
            if (!bl) {
                this.canChangeValue = false;
            } else {
                InputType inputType = Minecraft.getInstance().getLastInputType();
                if (inputType == InputType.MOUSE || inputType == InputType.KEYBOARD_TAB) {
                    this.canChangeValue = true;
                }
            }
        }

        public boolean keyPressed(int i, int j, int k) {
            if (CommonInputs.selected((int)i)) {
                this.canChangeValue = !this.canChangeValue;
                return true;
            }
            if (this.canChangeValue) {
                boolean bl;
                boolean bl2 = bl = i == 263;
                if (bl || i == 262) {
                    float f = bl ? -1.0f : 1.0f;
                    double step = (this.max - this.min) / (double)((float)this.width / 8.0f);
                    this.setValue(Mth.clamp((double)(this.value + step * (double)f), (double)this.min, (double)this.max));
                    return true;
                }
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            double position = (d - (double)(this.getX() + 4)) / (double)(this.width - 8);
            this.setValue(Mth.clamp((double)(position * (this.max - this.min) + this.min), (double)this.min, (double)this.max));
        }

        protected void onDrag(double d, double e, double f, double g) {
            this.setValueFromMouse(d);
            super.onDrag(d, e, f, g);
        }

        public void playDownSound(SoundManager soundManager) {
        }

        public void onRelease(double d, double e) {
            super.playDownSound(Minecraft.getInstance().getSoundManager());
        }

        protected double getValue() {
            return this.value;
        }

        private void setValue(double d) {
            double e = this.value;
            this.value = Mth.clamp((double)d, (double)this.min, (double)this.max);
            if (e != this.value) {
                this.onChange.accept(this);
            }
        }
    }

    private static class TextureWidget
    extends AbstractWidget {
        private ResourceLocation texture;

        public TextureWidget(int x, int y, int width, int height, ResourceLocation texture) {
            super(x, y, width, height, CommonComponents.EMPTY);
            this.texture = texture;
        }

        public boolean isMouseOver(double d, double e) {
            return this.visible && d >= (double)this.getX() && e >= (double)this.getY() && d < (double)(this.getX() + this.width) && e < (double)(this.getY() + this.height);
        }

        public void setTexture(ResourceLocation texture) {
            this.texture = texture;
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            graphics.blit(this.texture, this.getX(), this.getY(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
        }

        protected void updateWidgetNarration(NarrationElementOutput _ignored) {
        }

        public void playDownSound(SoundManager _ignored) {
        }

        public boolean isActive() {
            return false;
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent _ignored) {
            return null;
        }
    }
}

