/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util.content;

import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.content.BCBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.util.content.BCFacingEntityBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BCFacingInteractibleBlock
extends BCFacingEntityBlock {
    public BCFacingInteractibleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public abstract int lookingAtSlot(BlockState var1, BlockHitResult var2);

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (player.isSecondaryUseActive()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!this.canAccessFromDirection(state, hit.getDirection())) {
            return super.useItemOn(stack, state, level, pos, player, hand, hit);
        }
        int slot = this.lookingAtSlot(state, hit);
        if (slot != -1 && (blockEntity = level.getBlockEntity(pos)) instanceof BCBlockEntity) {
            BCBlockEntity bcbe = (BCBlockEntity)blockEntity;
            if (bcbe.getLockKey() != null && !BaseContainerBlockEntity.canUnlock((Player)player, (LockCode)bcbe.getLockKey(), (Component)BCUtil.getNameAtPos(level, pos))) {
                return ItemInteractionResult.CONSUME;
            }
            ItemStack slotStack = bcbe.getItem(slot);
            if (stack.isEmpty() || bcbe.canPlaceItem(slot, stack)) {
                bcbe.setItem(slot, stack);
                player.setItemInHand(hand, slotStack);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    protected boolean canAccessFromDirection(BlockState state, Direction direction) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return facing == direction || facing == direction.getOpposite();
    }
}

