/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public final class BCUtil {
    public static ResourceLocation mcLoc(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    public static ResourceLocation cLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"c", (String)path);
    }

    public static ResourceLocation modLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"bibliocraft", (String)path);
    }

    public static void openBEMenu(Player player, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MenuProvider) {
            MenuProvider mp = (MenuProvider)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.openMenu(mp, buf -> buf.writeBlockPos(pos));
            }
        }
    }

    @SafeVarargs
    public static <T> Collection<T> merge(Collection<T> collection, T ... others) {
        return BCUtil.merge(new Collection[]{collection, Arrays.stream(others).toList()});
    }

    @SafeVarargs
    public static <T> Collection<T> merge(Collection<T> ... collections) {
        ArrayList<T> list = new ArrayList<T>();
        for (Collection<T> collection : collections) {
            list.addAll(collection);
        }
        return list;
    }

    public static <T> Collection<T> mergeRaw(Collection ... collections) {
        ArrayList list = new ArrayList();
        for (Collection collection : collections) {
            list.addAll(collection);
        }
        return list;
    }

    public static <T> List<T> extend(List<T> list, int size, T fill) {
        for (int i = list.size(); i < size; ++i) {
            list.add(fill);
        }
        return list;
    }

    public static int max(int ... ints) {
        return Arrays.stream(ints).max().getAsInt();
    }

    public static <E extends Enum<E>> Codec<E> enumCodec(Supplier<E[]> valuesSupplier) {
        return StringRepresentable.fromEnum(valuesSupplier);
    }

    public static <E extends Enum<E>> StreamCodec<ByteBuf, E> enumStreamCodec(Supplier<E[]> valuesSupplier, Function<E, Integer> ordinalSupplier) {
        return ByteBufCodecs.INT.map(e -> ((Enum[])valuesSupplier.get())[e], ordinalSupplier);
    }

    public static <T> Tag encodeNbt(Codec<T> codec, T value) {
        return (Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, value).getOrThrow();
    }

    public static <T> T decodeNbt(Codec<T> codec, Tag tag) {
        return (T)((Pair)codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow()).getFirst();
    }

    public static Component getNameAtPos(Level level, BlockPos pos) {
        Component component;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof Nameable) {
            Nameable nameable = (Nameable)blockEntity;
            component = nameable.getDisplayName();
        } else {
            component = level.getBlockState(pos).getBlock().getName();
        }
        return component;
    }

    public static <T> Comparator<T> reverseComparator(Comparator<T> comparator) {
        return (a, b) -> -comparator.compare(a, b);
    }

    public static <T extends BlockEntity> ItemStack tryInsert(Level level, BlockPos pos, Direction direction, ItemStack stack, @Nullable T source) {
        List list;
        Container container = HopperBlockEntity.getContainerAt((Level)level, (BlockPos)pos.relative(direction));
        if (container != null) {
            return HopperBlockEntity.addItem((Container)((Container)source), (Container)container, (ItemStack)stack, (Direction)direction.getOpposite());
        }
        IItemHandler cap = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, level.getBlockState(pos), source, (Object)direction);
        if (cap == null && !(list = level.getEntities((Entity)null, new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)), EntitySelector.ENTITY_STILL_ALIVE)).isEmpty()) {
            Entity entity;
            Collections.shuffle(list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && (cap = (IItemHandler)(entity = (Entity)iterator.next()).getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, (Object)direction)) == null) {
            }
        }
        if (cap != null) {
            for (int slot = 0; slot < cap.getSlots() && !stack.isEmpty(); ++slot) {
                stack = cap.insertItem(slot, stack, false);
            }
        }
        return stack;
    }

    public static Vec3 toVec3(Vec3i vec) {
        return new Vec3((double)vec.getX(), (double)vec.getY(), (double)vec.getZ());
    }
}

