/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.fancyarmorstand;

import com.github.minecraftschurlimods.bibliocraft.content.fancyarmorstand.FancyArmorStandBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.init.BCMenus;
import com.github.minecraftschurlimods.bibliocraft.util.content.BCMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FancyArmorStandMenu
extends BCMenu<FancyArmorStandBlockEntity> {
    public FancyArmorStandMenu(int id, Inventory inventory, FancyArmorStandBlockEntity blockEntity) {
        super(BCMenus.FANCY_ARMOR_STAND.get(), id, inventory, blockEntity);
    }

    public FancyArmorStandMenu(int id, Inventory inventory, FriendlyByteBuf buf) {
        super(BCMenus.FANCY_ARMOR_STAND.get(), id, inventory, buf);
    }

    @Override
    protected void addSlots(Inventory inventory) {
        this.addSlot(new EquipableSlot(this.blockEntity, 0, 80, 8, EquipmentSlot.HEAD));
        this.addSlot(new EquipableSlot(this.blockEntity, 1, 80, 26, EquipmentSlot.CHEST));
        this.addSlot(new EquipableSlot(this.blockEntity, 2, 80, 44, EquipmentSlot.LEGS));
        this.addSlot(new EquipableSlot(this.blockEntity, 3, 80, 62, EquipmentSlot.FEET));
        this.addInventorySlots(inventory, 8, 84);
        this.addSlot(new EquipableSlot((Container)inventory, 39, 126, 8, EquipmentSlot.HEAD));
        this.addSlot(new EquipableSlot((Container)inventory, 38, 126, 26, EquipmentSlot.CHEST));
        this.addSlot(new EquipableSlot((Container)inventory, 37, 126, 44, EquipmentSlot.LEGS));
        this.addSlot(new EquipableSlot((Container)inventory, 36, 126, 62, EquipmentSlot.FEET));
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        int slotCount = ((FancyArmorStandBlockEntity)this.blockEntity).getContainerSize();
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (index < slotCount) {
            ItemStack invArmorStack = this.tryMoveToInvArmor(index);
            if (invArmorStack != null) {
                return invArmorStack;
            }
            if (!this.moveItemStackTo(slot.getItem(), slotCount, slotCount + 36, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index > slotCount + 35) {
            ItemStack armorStandStack = this.tryMoveToArmorStand(index);
            if (armorStandStack != null) {
                return armorStandStack;
            }
            if (!this.moveItemStackTo(slot.getItem(), slotCount, slotCount + 36, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < slotCount + 9) {
            ItemStack tryMoveArmorStand = this.tryMoveToArmorStand(index);
            if (tryMoveArmorStand != null) {
                return tryMoveArmorStand;
            }
            ItemStack invArmorStack = this.tryMoveToInvArmor(index);
            if (invArmorStack != null) {
                return invArmorStack;
            }
            if (!this.moveItemStackTo(stack, slotCount + 9, slotCount + 36, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < slotCount + 36) {
            ItemStack tryMoveArmorStand = this.tryMoveToArmorStand(index);
            if (tryMoveArmorStand != null) {
                return tryMoveArmorStand;
            }
            ItemStack invArmorStack = this.tryMoveToInvArmor(index);
            if (invArmorStack != null) {
                return invArmorStack;
            }
            if (!this.moveItemStackTo(stack, slotCount, slotCount + 9, false)) {
                return ItemStack.EMPTY;
            }
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return originalStack;
    }

    @Nullable
    private ItemStack tryMoveToInvArmor(int index) {
        ItemStack stack = ((Slot)this.slots.get(index)).getItem();
        for (int i = 40; i < 44; ++i) {
            Slot beSlot = (Slot)this.slots.get(i);
            if (beSlot.hasItem() || !beSlot.mayPlace(stack) || this.moveItemStackTo(stack, i, i + 1, false)) continue;
            return ItemStack.EMPTY;
        }
        return null;
    }

    @Nullable
    private ItemStack tryMoveToArmorStand(int index) {
        ItemStack stack = ((Slot)this.slots.get(index)).getItem();
        for (int i = 0; i < 4; ++i) {
            Slot beSlot = (Slot)this.slots.get(i);
            if (beSlot.hasItem() || !beSlot.mayPlace(stack) || this.moveItemStackTo(stack, i, i + 1, false)) continue;
            return ItemStack.EMPTY;
        }
        return null;
    }

    private static class EquipableSlot
    extends Slot {
        private final EquipmentSlot slotType;

        public EquipableSlot(Container container, int index, int x, int y, EquipmentSlot slotType) {
            super(container, index, x, y);
            this.slotType = slotType;
        }

        public boolean mayPlace(ItemStack stack) {
            Equipable equipable;
            Item item = stack.getItem();
            return item instanceof Equipable && (equipable = (Equipable)item).getEquipmentSlot() == this.slotType;
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

