/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.cookiejar;

import com.github.minecraftschurlimods.bibliocraft.content.cookiejar.CookieJarMenu;
import com.github.minecraftschurlimods.bibliocraft.init.BCBlockEntities;
import com.github.minecraftschurlimods.bibliocraft.util.content.BCMenuBlockEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CookieJarBlockEntity
extends BCMenuBlockEntity {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            CookieJarBlockEntity.this.updateBlockState(state, true);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            CookieJarBlockEntity.this.updateBlockState(state, false);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int count, int openCount) {
        }

        protected boolean isOwnContainer(Player player) {
            if (player.containerMenu instanceof CookieJarMenu) {
                Object container = ((CookieJarMenu)player.containerMenu).getBlockEntity();
                return container == CookieJarBlockEntity.this;
            }
            return false;
        }
    };

    public CookieJarBlockEntity(BlockPos pos, BlockState state) {
        super(BCBlockEntities.COOKIE_JAR.get(), 8, CookieJarBlockEntity.defaultName("cookie_jar"), pos, state);
    }

    @Override
    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new CookieJarMenu(id, inventory, this);
    }

    private void updateBlockState(BlockState pState, boolean pOpen) {
        Objects.requireNonNull(this.level).setBlock(this.getBlockPos(), (BlockState)pState.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(pOpen)), 3);
    }

    public void startOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.incrementOpeners(pPlayer, Objects.requireNonNull(this.level), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.decrementOpeners(pPlayer, Objects.requireNonNull(this.level), this.getBlockPos(), this.getBlockState());
        }
    }
}

